/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.killmods.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.killmods.init.KillmodsModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber
public class KillmodsModBiomes {
    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
        Registry levelStemTypeRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().registryOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            NoiseGeneratorSettings moddedNoiseGeneratorSettings;
            ArrayList<SurfaceRules.RuleSource> surfaceRules;
            SurfaceRules.SequenceRuleSource sequenceRuleSource;
            SurfaceRules.RuleSource currentRuleSource;
            BiomeSource noiseGeneratorSettings;
            NoiseBasedChunkGenerator noiseGenerator;
            ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters;
            MultiNoiseBiomeSource noiseSource;
            ChunkGenerator chunkGenerator;
            DimensionType dimensionType = (DimensionType)levelStem.type().value();
            if (dimensionType == dimensionTypeRegistry.getOrThrow(BuiltinDimensionTypes.OVERWORLD)) {
                chunkGenerator = levelStem.generator();
                BiomeSource biomeSource = chunkGenerator.getBiomeSource();
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    noiseSource = (MultiNoiseBiomeSource)biomeSource;
                    parameters = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>(noiseSource.parameters().values());
                    KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.85f, (float)-0.55f), Climate.Parameter.span((float)-1.55f, (float)-0.44f), Climate.Parameter.span((float)-0.3986f, (float)1.1031f), Climate.Parameter.span((float)0.55f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"snow_spruce")))));
                    KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.85f, (float)-0.55f), Climate.Parameter.span((float)-1.55f, (float)-0.44f), Climate.Parameter.span((float)-0.3986f, (float)1.1031f), Climate.Parameter.span((float)0.55f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)1.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"snow_spruce")))));
                    KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.656f, (float)1.59f), Climate.Parameter.span((float)0.3001f, (float)1.56f), Climate.Parameter.span((float)0.17f, (float)1.65f), Climate.Parameter.span((float)-0.894f, (float)1.3018f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.650973f, (float)1.471f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"cursed_forest")))));
                    KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.656f, (float)1.59f), Climate.Parameter.span((float)0.3001f, (float)1.56f), Climate.Parameter.span((float)0.17f, (float)1.65f), Climate.Parameter.span((float)-0.894f, (float)1.3018f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.650973f, (float)1.471f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"cursed_forest")))));
                    KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)0.55f, (float)1.0f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.0f, (float)2.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"terrible_forest")))));
                    KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)-0.1f, (float)0.1f), Climate.Parameter.span((float)0.3f, (float)1.0f), Climate.Parameter.span((float)0.55f, (float)1.0f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.0f, (float)2.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"terrible_forest")))));
                    KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.5f, (float)1.0f), Climate.Parameter.span((float)-0.5f, (float)0.5f), Climate.Parameter.span((float)0.3f, (float)0.4921f), Climate.Parameter.span((float)-1.0001f, (float)-0.202f), Climate.Parameter.span((float)0.2f, (float)0.9f), Climate.Parameter.span((float)-1.0f, (float)2.0f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"night_caves")))));
                    chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                    chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
                }
                if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                    noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
                    noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.settings.value();
                    currentRuleSource = noiseGeneratorSettings.surfaceRule();
                    if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
                        sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                        surfaceRules = new ArrayList<SurfaceRules.RuleSource>(sequenceRuleSource.sequence());
                        KillmodsModBiomes.addSurfaceRule(surfaceRules, 1, KillmodsModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"night_caves")), ((Block)KillmodsModBlocks.NIGHTMARE_SCULK_BLOCK.get()).defaultBlockState(), ((Block)KillmodsModBlocks.NIGHTMARE_SKULK_BLOCK_2.get()).defaultBlockState(), ((Block)KillmodsModBlocks.NIGHTMARE_SKULK_BLOCK_2.get()).defaultBlockState()));
                        KillmodsModBiomes.addSurfaceRule(surfaceRules, 1, KillmodsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"snow_spruce")), Blocks.GRASS_BLOCK.defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.STONE.defaultBlockState()));
                        KillmodsModBiomes.addSurfaceRule(surfaceRules, 1, KillmodsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"cursed_forest")), ((Block)KillmodsModBlocks.CURSED_GRASS_2.get()).defaultBlockState(), ((Block)KillmodsModBlocks.CURSED_STONE.get()).defaultBlockState(), ((Block)KillmodsModBlocks.CURSED_STONE.get()).defaultBlockState()));
                        KillmodsModBiomes.addSurfaceRule(surfaceRules, 1, KillmodsModBiomes.preliminarySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"terrible_forest")), ((Block)KillmodsModBlocks.SUFFERING_GRASS.get()).defaultBlockState(), Blocks.STONE.defaultBlockState(), Blocks.STONE.defaultBlockState()));
                        moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.noiseSettings(), noiseGeneratorSettings.defaultBlock(), noiseGeneratorSettings.defaultFluid(), noiseGeneratorSettings.noiseRouter(), SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.spawnTarget(), noiseGeneratorSettings.seaLevel(), noiseGeneratorSettings.disableMobGeneration(), noiseGeneratorSettings.aquifersEnabled(), noiseGeneratorSettings.oreVeinsEnabled(), noiseGeneratorSettings.useLegacyRandomSource());
                        noiseGenerator.settings = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
                    }
                }
            }
            if (dimensionType != dimensionTypeRegistry.getOrThrow(BuiltinDimensionTypes.NETHER)) continue;
            chunkGenerator = levelStem.generator();
            noiseGeneratorSettings = chunkGenerator.getBiomeSource();
            if (noiseGeneratorSettings instanceof MultiNoiseBiomeSource) {
                noiseSource = (MultiNoiseBiomeSource)noiseGeneratorSettings;
                parameters = new ArrayList(noiseSource.parameters().values());
                KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.3977f, (float)1.9026f), Climate.Parameter.span((float)1.0f, (float)2.0f), Climate.Parameter.span((float)0.12f, (float)1.9212f), Climate.Parameter.span((float)0.3f, (float)1.1012f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.1868608f, (float)-0.38686076f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"the_bluefire_swamp")))));
                KillmodsModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-0.3977f, (float)1.9026f), Climate.Parameter.span((float)1.0f, (float)2.0f), Climate.Parameter.span((float)0.12f, (float)1.9212f), Climate.Parameter.span((float)0.3f, (float)1.1012f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.1868608f, (float)-0.38686076f), 0L), (Object)biomeRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"the_bluefire_swamp")))));
                chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
                chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            }
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.settings.value();
            currentRuleSource = noiseGeneratorSettings.surfaceRule();
            if (!(currentRuleSource instanceof SurfaceRules.SequenceRuleSource)) continue;
            sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
            surfaceRules = new ArrayList(sequenceRuleSource.sequence());
            KillmodsModBiomes.addSurfaceRule(surfaceRules, 2, KillmodsModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"killmods", (String)"the_bluefire_swamp")), ((Block)KillmodsModBlocks.BLUEFIRE_NYLIUM.get()).defaultBlockState(), Blocks.NETHERRACK.defaultBlockState(), Blocks.NETHERRACK.defaultBlockState()));
            moddedNoiseGeneratorSettings = new NoiseGeneratorSettings(noiseGeneratorSettings.noiseSettings(), noiseGeneratorSettings.defaultBlock(), noiseGeneratorSettings.defaultFluid(), noiseGeneratorSettings.noiseRouter(), SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new))), noiseGeneratorSettings.spawnTarget(), noiseGeneratorSettings.seaLevel(), noiseGeneratorSettings.disableMobGeneration(), noiseGeneratorSettings.aquifersEnabled(), noiseGeneratorSettings.oreVeinsEnabled(), noiseGeneratorSettings.useLegacyRandomSource());
            noiseGenerator.settings = new Holder.Direct((Object)moddedNoiseGeneratorSettings);
        }
    }

    private static SurfaceRules.RuleSource preliminarySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))})));
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))}));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    private static void addSurfaceRule(List<SurfaceRules.RuleSource> surfaceRules, int index, SurfaceRules.RuleSource rule) {
        if (!surfaceRules.contains(rule)) {
            surfaceRules.add(index, rule);
        }
    }
}

