/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.killmods.init;

import net.mcreator.killmods.potion.AntiPandemoniumPotionEffectMobEffect;
import net.mcreator.killmods.potion.DarknessPotionEffectMobEffect;
import net.mcreator.killmods.potion.FlyPotion3MobEffect;
import net.mcreator.killmods.potion.PandemoniumPotionEffectMobEffect;
import net.mcreator.killmods.procedures.AntiPandemoniumFoodEatenProcedure;
import net.mcreator.killmods.procedures.DarknessPotionExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class KillmodsModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"killmods");
    public static final DeferredHolder<MobEffect, MobEffect> PANDEMONIUM = REGISTRY.register("pandemonium", () -> new PandemoniumPotionEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> ANTI_PANDEMONIUM = REGISTRY.register("anti_pandemonium", () -> new AntiPandemoniumPotionEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> DARKNESS = REGISTRY.register("darkness", () -> new DarknessPotionEffectMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> FLY_POTION_3 = REGISTRY.register("fly_potion_3", () -> new FlyPotion3MobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            KillmodsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            KillmodsModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(ANTI_PANDEMONIUM)) {
            AntiPandemoniumFoodEatenProcedure.execute(entity);
        } else if (effectInstance.getEffect().is(DARKNESS)) {
            DarknessPotionExpiresProcedure.execute(entity);
        }
    }
}

