/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.killmods.item;

import net.mcreator.killmods.init.KillmodsModItems;
import net.mcreator.killmods.procedures.RainbowSwordMobIsHitWithToolProcedure;
import net.mcreator.killmods.procedures.RainbowSwordRightClickedInAirProcedure;
import net.mcreator.killmods.procedures.RainbowSwordRightClickedOnBlockProcedure;
import net.mcreator.killmods.procedures.RainbowSwordToolInHandTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RainbowSwordItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 128000;
        }

        public float getSpeed() {
            return 200.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        }

        public int getEnchantmentValue() {
            return 80;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)KillmodsModItems.RAINBOW_GEM.get())});
        }
    };

    public RainbowSwordItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)29.0f, (float)-2.0f)));
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        boolean retval = super.mineBlock(itemstack, world, blockstate, pos, entity);
        RainbowSwordMobIsHitWithToolProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), itemstack);
        return retval;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        RainbowSwordMobIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), itemstack);
        return retval;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        RainbowSwordRightClickedInAirProcedure.execute((Entity)entity);
        return ar;
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        RainbowSwordRightClickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), (Entity)context.getPlayer());
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            RainbowSwordToolInHandTickProcedure.execute(entity);
        }
    }
}

