/*
 * Decompiled with CFR 0.152.
 */
package io.creray.targeted.client.animation;

public final class AnimationProgress {
    public final float DURATION;
    private boolean isPaused = true;
    private float currentTime = 0.0f;
    private float goalTime;

    public AnimationProgress(float duration) {
        assert (duration >= 0.0f);
        this.goalTime = this.DURATION = duration;
    }

    public void runForward() {
        this.isPaused = false;
        this.goalTime = this.DURATION;
    }

    public void runBackward() {
        this.isPaused = false;
        this.goalTime = 0.0f;
    }

    public void runTowards(float progress) {
        this.isPaused = false;
        this.goalTime = progress * this.DURATION;
    }

    public void pause() {
        this.isPaused = true;
    }

    public void update(float delta) {
        if (this.isPaused) {
            return;
        }
        if (this.currentTime < this.goalTime) {
            this.currentTime += delta;
            if (this.currentTime >= this.goalTime) {
                this.currentTime = this.goalTime;
                this.pause();
            }
        } else {
            this.currentTime -= delta;
            if (this.currentTime <= this.goalTime) {
                this.currentTime = this.goalTime;
                this.pause();
            }
        }
    }

    public boolean isZero() {
        return this.currentTime == 0.0f;
    }

    public float get() {
        return this.currentTime / this.DURATION;
    }

    public float limitedBy(AnimationProgress other) {
        return Math.min(this.get(), other.get());
    }
}

