/*
 * Decompiled with CFR 0.152.
 */
package io.creray.targeted.client.crosshair;

import io.creray.targeted.client.crosshair.ModeSelector;
import io.creray.targeted.client.crosshair.mode.Mode;
import io.creray.targeted.client.crosshair.mode.Modes;
import io.creray.targeted.client.target.Target;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public final class Crosshair {
    private Target target = Target.empty();
    private Mode currentMode = Modes.DEFAULT;
    @Nullable
    private Mode nextMode;

    public void updateTarget(Target newTarget) {
        if (newTarget.equals(this.target)) {
            return;
        }
        this.target = newTarget;
        this.selectNextMode();
    }

    public void tick() {
        this.currentMode.tick();
        if (this.nextMode != null && this.currentMode.canBeSwitched()) {
            this.switchToNextMode();
        }
    }

    public void render(class_332 guiRenderer, class_9779 deltaTracker) {
        this.currentMode.render(guiRenderer, deltaTracker);
    }

    private void selectNextMode() {
        Mode selectedMode = ModeSelector.selectFor(this.target);
        if (selectedMode == this.currentMode) {
            this.nextMode = null;
            this.currentMode.enable();
        } else {
            this.nextMode = selectedMode;
            this.currentMode.disable();
        }
    }

    private void switchToNextMode() {
        assert (this.nextMode != null);
        this.currentMode = this.nextMode;
        this.currentMode.enable();
        this.nextMode = null;
    }
}

