/*
 * Decompiled with CFR 0.152.
 */
package com.example.gridbuildhelper.config;

import com.example.gridbuildhelper.GridBuildHelper;
import com.example.gridbuildhelper.config.ModConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final String CONFIG_FILE = "blockoutlines.json";
    private static final File CONFIG_PATH = new File(FabricLoader.getInstance().getConfigDir().toFile(), "blockoutlines.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static ModConfig config;
    public static ModConfig.Profile selectedProfileInternal;

    public static ModConfig.Profile getSelectedProfile() {
        return selectedProfileInternal;
    }

    public static void setSelectedProfileByName(String name) {
        ModConfig.Profile profile = ConfigManager.getProfileByName(name);
        if (profile != null) {
            ConfigManager.setSelectedProfile(profile);
        }
    }

    public static void setSelectedProfile(ModConfig.Profile profile) {
        if (profile != null) {
            selectedProfileInternal = profile;
            ConfigManager.config.lastUsedProfile = profile.name;
        }
    }

    public static void loadConfig() {
        ModConfig.Profile found;
        if (CONFIG_PATH.exists()) {
            try (FileReader reader = new FileReader(CONFIG_PATH);){
                config = (ModConfig)GSON.fromJson((Reader)reader, ModConfig.class);
            }
            catch (IOException e) {
                GridBuildHelper.LOGGER.error("Failed to load config", (Throwable)e);
            }
        }
        if (config == null) {
            config = new ModConfig();
            ModConfig.Profile defaultProfile = new ModConfig.Profile();
            ConfigManager.config.profiles.add(defaultProfile);
            ConfigManager.config.lastUsedProfile = defaultProfile.name;
            ConfigManager.saveProfile();
        }
        if ((found = ConfigManager.getProfileByName(ConfigManager.config.lastUsedProfile)) != null) {
            ConfigManager.setSelectedProfile(found);
        } else if (!ConfigManager.config.profiles.isEmpty()) {
            ConfigManager.setSelectedProfile(ConfigManager.config.profiles.getFirst());
        }
    }

    public static void saveProfile() {
        if (selectedProfileInternal != null) {
            ConfigManager.config.lastUsedProfile = ConfigManager.selectedProfileInternal.name;
        }
        try (FileWriter writer = new FileWriter(CONFIG_PATH);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            GridBuildHelper.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static ModConfig.Profile getProfileByName(String name) {
        return ConfigManager.config.profiles.stream().filter(p -> p.name.equals(name)).findFirst().orElse(null);
    }

    public static void renameProfile(String oldName, String newName) {
        Optional<ModConfig.Profile> match = ConfigManager.config.profiles.stream().filter(p -> p.name.equals(oldName)).findFirst();
        match.ifPresent(p -> {
            p.name = newName;
            if (ConfigManager.config.lastUsedProfile.equals(oldName)) {
                ConfigManager.config.lastUsedProfile = newName;
            }
            if (selectedProfileInternal != null && ConfigManager.selectedProfileInternal.name.equals(oldName)) {
                ConfigManager.selectedProfileInternal.name = newName;
            }
            ConfigManager.saveProfile();
        });
    }

    public static void removeProfile(String profileName) {
        ConfigManager.config.profiles.removeIf(p -> p.name.equals(profileName));
        if (selectedProfileInternal != null && ConfigManager.selectedProfileInternal.name.equals(profileName)) {
            selectedProfileInternal = null;
        }
        if (profileName.equals(ConfigManager.config.lastUsedProfile)) {
            if (!ConfigManager.config.profiles.isEmpty()) {
                ConfigManager.setSelectedProfile(ConfigManager.config.profiles.getFirst());
            } else {
                ConfigManager.config.lastUsedProfile = null;
            }
        }
        ConfigManager.saveProfile();
    }

    static {
        selectedProfileInternal = null;
    }
}

