/*
 * Decompiled with CFR 0.152.
 */
package com.example.gridbuildhelper.rendering;

import com.example.gridbuildhelper.config.ConfigManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class CubeRenderer {
    public static Set<class_2338> allGeneratedCubePositions = new HashSet<class_2338>();
    private static class_2338 originPos = null;
    private static boolean isEnabled = false;
    private static int currentStep = 0;
    private static int currentRadius = 0;
    private static int currentOffsetX = 0;
    private static int currentOffsetY = 0;
    private static int currentOffsetZ = 0;
    private static class_2338 lastCheckedPlayerBlockPos = null;
    private static int lastCheckedRadius = -1;
    private static int lastCheckedStep = -1;
    private static int lastCheckedOffsetX = Integer.MIN_VALUE;
    private static int lastCheckedOffsetY = Integer.MIN_VALUE;
    private static int lastCheckedOffsetZ = Integer.MIN_VALUE;

    public static void setEnabled(boolean enabled, class_2338 playerPosAtActivation) {
        isEnabled = enabled;
        if (enabled) {
            boolean configChanged;
            currentOffsetX = ConfigManager.selectedProfileInternal.startX;
            currentOffsetY = ConfigManager.selectedProfileInternal.startY;
            currentOffsetZ = ConfigManager.selectedProfileInternal.startZ;
            currentStep = ConfigManager.selectedProfileInternal.step;
            currentRadius = ConfigManager.selectedProfileInternal.radius;
            boolean bl = configChanged = currentOffsetX != lastCheckedOffsetX || currentOffsetY != lastCheckedOffsetY || currentOffsetZ != lastCheckedOffsetZ || currentStep != lastCheckedStep || currentRadius != lastCheckedRadius;
            if (originPos == null || configChanged) {
                originPos = playerPosAtActivation.method_10069(currentOffsetX, currentOffsetY, currentOffsetZ);
                allGeneratedCubePositions.clear();
                System.out.println("[CubeRenderer] Grid origin set to: " + originPos.method_23854() + " (Config Changed: " + configChanged + ")");
                lastCheckedOffsetX = currentOffsetX;
                lastCheckedOffsetY = currentOffsetY;
                lastCheckedOffsetZ = currentOffsetZ;
                lastCheckedStep = currentStep;
                lastCheckedRadius = currentRadius;
            }
            lastCheckedPlayerBlockPos = null;
        } else {
            allGeneratedCubePositions.clear();
            originPos = null;
            currentStep = 0;
            currentRadius = 0;
            currentOffsetX = 0;
            currentOffsetY = 0;
            currentOffsetZ = 0;
            lastCheckedPlayerBlockPos = null;
            lastCheckedRadius = -1;
            lastCheckedStep = -1;
            lastCheckedOffsetX = Integer.MIN_VALUE;
            lastCheckedOffsetY = Integer.MIN_VALUE;
            lastCheckedOffsetZ = Integer.MIN_VALUE;
            System.out.println("[CubeRenderer] Grid disabled. All cubes cleared.");
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void ensureCubesAroundPlayer(class_2338 currentPlayerBlockPos) {
        boolean configChanged;
        if (!isEnabled || originPos == null || currentPlayerBlockPos == null || ConfigManager.selectedProfileInternal == null) {
            return;
        }
        int newOffsetX = ConfigManager.selectedProfileInternal.startX;
        int newOffsetY = ConfigManager.selectedProfileInternal.startY;
        int newOffsetZ = ConfigManager.selectedProfileInternal.startZ;
        int newStep = ConfigManager.selectedProfileInternal.step;
        int newRadius = ConfigManager.selectedProfileInternal.radius;
        if (newRadius <= 0 || newStep <= 0) {
            return;
        }
        boolean playerMovedSignificantly = lastCheckedPlayerBlockPos == null || Math.abs(currentPlayerBlockPos.method_10263() - lastCheckedPlayerBlockPos.method_10263()) >= newStep / 2 || Math.abs(currentPlayerBlockPos.method_10264() - lastCheckedPlayerBlockPos.method_10264()) >= newStep / 2 || Math.abs(currentPlayerBlockPos.method_10260() - lastCheckedPlayerBlockPos.method_10260()) >= newStep / 2;
        boolean bl = configChanged = newOffsetX != lastCheckedOffsetX || newOffsetY != lastCheckedOffsetY || newOffsetZ != lastCheckedOffsetZ || newStep != lastCheckedStep || newRadius != lastCheckedRadius;
        if (!playerMovedSignificantly && !configChanged) {
            return;
        }
        currentOffsetX = newOffsetX;
        currentOffsetY = newOffsetY;
        currentOffsetZ = newOffsetZ;
        currentStep = newStep;
        currentRadius = newRadius;
        lastCheckedPlayerBlockPos = currentPlayerBlockPos;
        lastCheckedRadius = newRadius;
        lastCheckedStep = newStep;
        lastCheckedOffsetX = newOffsetX;
        lastCheckedOffsetY = newOffsetY;
        lastCheckedOffsetZ = newOffsetZ;
        int effectiveGenerationRange = Math.max(newRadius, newStep) + newStep * 3;
        int minX = (int)Math.floor((double)(currentPlayerBlockPos.method_10263() - effectiveGenerationRange - originPos.method_10263()) / (double)newStep) * newStep + originPos.method_10263();
        int maxX = (int)Math.ceil((double)(currentPlayerBlockPos.method_10263() + effectiveGenerationRange - originPos.method_10263()) / (double)newStep) * newStep + originPos.method_10263();
        int minY = (int)Math.floor((double)(currentPlayerBlockPos.method_10264() - effectiveGenerationRange - originPos.method_10264()) / (double)newStep) * newStep + originPos.method_10264();
        int maxY = (int)Math.ceil((double)(currentPlayerBlockPos.method_10264() + effectiveGenerationRange - originPos.method_10264()) / (double)newStep) * newStep + originPos.method_10264();
        int minZ = (int)Math.floor((double)(currentPlayerBlockPos.method_10260() - effectiveGenerationRange - originPos.method_10260()) / (double)newStep) * newStep + originPos.method_10260();
        int maxZ = (int)Math.ceil((double)(currentPlayerBlockPos.method_10260() + effectiveGenerationRange - originPos.method_10260()) / (double)newStep) * newStep + originPos.method_10260();
        int cubesAddedThisTick = 0;
        for (int x = minX; x <= maxX; x += newStep) {
            for (int y = minY; y <= maxY; y += newStep) {
                for (int z = minZ; z <= maxZ; z += newStep) {
                    class_2338 potentialCubePos = new class_2338(x, y, z);
                    if ((potentialCubePos.method_10263() - originPos.method_10263()) % newStep != 0 || (potentialCubePos.method_10264() - originPos.method_10264()) % newStep != 0 || (potentialCubePos.method_10260() - originPos.method_10260()) % newStep != 0) continue;
                    class_243 dynamicCheckOrigin = currentPlayerBlockPos.method_10069(currentOffsetX, currentOffsetY, currentOffsetZ).method_46558();
                    if (!(potentialCubePos.method_46558().method_1022(dynamicCheckOrigin) <= (double)(newRadius + newStep)) || !allGeneratedCubePositions.add(potentialCubePos)) continue;
                    ++cubesAddedThisTick;
                }
            }
        }
    }

    public static void renderCubes(class_4587 matrices, class_4184 camera) {
        if (!isEnabled || allGeneratedCubePositions.isEmpty() || originPos == null) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        int color = ConfigManager.selectedProfileInternal.getOutlineColorAsInt();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        class_4588 buffer = immediate.getBuffer(class_1921.method_23594());
        int renderVisibilityRadius = ConfigManager.selectedProfileInternal.radius;
        for (class_2338 pos : allGeneratedCubePositions) {
            if (!(class_243.method_24953((class_2382)pos).method_1022(cameraPos) <= (double)renderVisibilityRadius)) continue;
            class_238 box = new class_238(pos).method_989(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
            CubeRenderer.drawBoxLines(matrices, buffer, box, r, g, b, a);
        }
        immediate.method_22993();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
    }

    private static void drawLine(class_4588 buffer, class_4587.class_4665 entry, double x1, double y1, double z1, double x2, double y2, double z2, float r, float g, float b, float a) {
        Matrix4f positionMatrix = entry.method_23761();
        buffer.method_22918(positionMatrix, (float)x1, (float)y1, (float)z1).method_22915(r, g, b, a).method_60831(entry, 0.0f, 1.0f, 0.0f);
        buffer.method_22918(positionMatrix, (float)x2, (float)y2, (float)z2).method_22915(r, g, b, a).method_60831(entry, 0.0f, 1.0f, 0.0f);
    }

    private static void drawBoxLines(class_4587 matrices, class_4588 buffer, class_238 box, float r, float g, float b, float a) {
        class_4587.class_4665 entry = matrices.method_23760();
        double x1 = box.field_1323;
        double y1 = box.field_1322;
        double z1 = box.field_1321;
        double x2 = box.field_1320;
        double y2 = box.field_1325;
        double z2 = box.field_1324;
        CubeRenderer.drawLine(buffer, entry, x1, y1, z1, x2, y1, z1, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x1, y1, z1, x1, y1, z2, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x2, y1, z1, x2, y1, z2, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x1, y1, z2, x2, y1, z2, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x1, y2, z1, x2, y2, z1, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x1, y2, z1, x1, y2, z2, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x2, y2, z1, x2, y2, z2, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x1, y2, z2, x2, y2, z2, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x1, y1, z1, x1, y2, z1, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x2, y1, z1, x2, y2, z1, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x1, y1, z2, x1, y2, z2, r, g, b, a);
        CubeRenderer.drawLine(buffer, entry, x2, y1, z2, x2, y2, z2, r, g, b, a);
    }
}

