/*
 * Decompiled with CFR 0.152.
 */
package com.example.gridbuildhelper.ui.widget;

import com.example.gridbuildhelper.config.ConfigManager;
import com.example.gridbuildhelper.config.ModConfig;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class ProfileListWidget
extends class_350<ProfileEntry> {
    private final Consumer<ModConfig.Profile> onSelect;
    private final int debugWidth;
    private final int debugHeight;
    private final int debugTop;
    private final int debugBottom;
    private final int debugItemHeight;

    public ProfileListWidget(class_310 client, int width, int height, int top, int bottom, int itemHeight, Consumer<ModConfig.Profile> onSelect) {
        super(client, width, height, top, bottom, itemHeight);
        this.onSelect = onSelect;
        this.debugWidth = width;
        this.debugHeight = height;
        this.debugTop = top;
        this.debugBottom = bottom;
        this.debugItemHeight = itemHeight;
        System.out.println("ProfileListWidget Constructor -> Width: " + width + ", Height: " + height + ", Top: " + top + ", Bottom: " + bottom + ", ItemHeight: " + itemHeight);
        this.refreshList();
    }

    public void refreshList() {
        this.method_25339();
        for (ModConfig.Profile profile : ConfigManager.config.profiles) {
            this.method_25321(new ProfileEntry(profile, this.onSelect));
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    public int method_25322() {
        return this.field_22758 - 12;
    }

    @Environment(value=EnvType.CLIENT)
    public class ProfileEntry
    extends class_350.class_351<ProfileEntry> {
        private final ModConfig.Profile profile;
        private final Consumer<ModConfig.Profile> onClick;

        public ProfileEntry(ModConfig.Profile profile, Consumer<ModConfig.Profile> onClick) {
            this.profile = profile;
            this.onClick = onClick;
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            class_310 client = class_310.method_1551();
            System.out.println("ProfileEntry Render -> X: " + x + ", Y: " + y + ", EntryWidth: " + entryWidth + ", EntryHeight: " + entryHeight + ", ExpectedItemHeight: " + ProfileListWidget.this.debugItemHeight);
            int textColor = this.profile.name.equals(ConfigManager.selectedProfileInternal.name) ? 16766720 : 0xFFFFFF;
            context.method_25294(x, y, x + entryWidth, y + entryHeight, 0x6600FFFF);
            if (hovered) {
                context.method_25294(x, y, x + entryWidth, y + entryHeight, 0x44000000);
            }
            Object label = this.profile.name.equals(ConfigManager.selectedProfileInternal.name) ? "\u25b6 " + this.profile.name : this.profile.name;
            int textX = x + 4;
            Objects.requireNonNull(client.field_1772);
            int textY = y + (entryHeight - 9) / 2;
            Objects.requireNonNull(client.field_1772);
            System.out.println("   Text: '" + (String)label + "', Text X: " + textX + ", Text Y: " + textY + ", Font Height: " + 9);
            context.method_51439(client.field_1772, (class_2561)class_2561.method_43470((String)label), textX, textY, textColor, false);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.onClick.accept(this.profile);
            return true;
        }
    }
}

