/*
 * Decompiled with CFR 0.152.
 */
package com.ccr4ft3r.lightspeed.mixin.resources;

import com.ccr4ft3r.lightspeed.cache.GlobalCache;
import com.ccr4ft3r.lightspeed.interfaces.IPackResources;
import com.ccr4ft3r.lightspeed.interfaces.IPathResourcePack;
import com.ccr4ft3r.lightspeed.util.CacheUtil;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathPackResources;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PathPackResources.class})
public abstract class PathResourcePackMixin
implements IPathResourcePack,
IPackResources {
    @Shadow
    @Final
    private static Logger LOGGER;
    private final Map<String, Path> lightspeed$resolvedPathByResource = Maps.newConcurrentMap();
    private final Map<PackType, Set<String>> lightspeed$namespacesByPackType = Maps.newConcurrentMap();
    private final Map<PackType, Map<String, List<Path>>> lightspeed$filePathsByRootByPackType = PathResourcePackMixin.lightspeed$initPathsMap();
    @Unique
    private IModFile lightspeed$modFile;
    @Unique
    private String lightspeed$id;

    @Shadow
    protected abstract Path resolve(String ... var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initReturnInjected(String packId, boolean isBuiltin, Path source, CallbackInfo ci) {
        if (GlobalCache.isEnabled.booleanValue()) {
            GlobalCache.add(this);
        }
    }

    @Unique
    private static Map<PackType, Map<String, List<Path>>> lightspeed$initPathsMap() {
        ConcurrentMap map = Maps.newConcurrentMap();
        for (PackType packType : PackType.values()) {
            map.put(packType, Maps.newConcurrentMap());
        }
        return map;
    }

    @Inject(method={"resolve"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void resolveHeadInjected(String[] paths, CallbackInfoReturnable<Path> cir) {
        if (this.lightspeed$modFile == null) {
            if (!GlobalCache.isEnabled.booleanValue()) {
                return;
            }
            Path resolved = this.lightspeed$getResolvedPath(paths);
            if (resolved != null) {
                cir.setReturnValue((Object)resolved);
            }
            return;
        }
        if (!GlobalCache.isEnabled.booleanValue()) {
            cir.setReturnValue((Object)this.lightspeed$modFile.findResource(paths));
            return;
        }
        Path path = this.lightspeed$getResolvedPath(paths);
        if (path == null) {
            path = this.lightspeed$modFile.findResource(paths);
            this.lightspeed$resolvedPathByResource.put(Arrays.toString(paths), path);
        }
        cir.setReturnValue((Object)path);
    }

    @Inject(method={"resolve"}, at={@At(value="RETURN")}, remap=false)
    public void resolveReturnInjected(String[] paths, CallbackInfoReturnable<Path> cir) {
        if (!GlobalCache.isEnabled.booleanValue() || this.lightspeed$modFile != null) {
            return;
        }
        this.lightspeed$resolvedPathByResource.put(Arrays.toString(paths), (Path)cir.getReturnValue());
    }

    @Inject(method={"getNamespaces"}, at={@At(value="HEAD")}, cancellable=true)
    public void getNamespacesHeadInjected(PackType type, CallbackInfoReturnable<Set<String>> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        Set<String> namespaces = this.lightspeed$getCachedNamespaces(type);
        if (namespaces != null) {
            cir.setReturnValue(namespaces);
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")})
    public void getNamespacesReturnInjected(PackType type, CallbackInfoReturnable<Set<String>> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        if (GlobalCache.shouldCacheEmptyNamespaces.booleanValue() || cir.getReturnValue() != null && !((Set)cir.getReturnValue()).isEmpty()) {
            this.lightspeed$cacheNamespaces(type, (Set)cir.getReturnValue());
        }
    }

    @Inject(method={"getRootResource"}, at={@At(value="HEAD")}, cancellable=true)
    public void getRootResourceHeadInjected(String[] paths, CallbackInfoReturnable<IoSupplier<InputStream>> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        String cacheKey = Arrays.toString(paths);
        Boolean exists = this.lightspeed$exists(cacheKey);
        if (exists != null) {
            if (exists.booleanValue()) {
                Path path = this.resolve(paths);
                cir.setReturnValue((Object)IoSupplier.m_246697_((Path)path));
            } else {
                cir.setReturnValue(null);
            }
        }
    }

    @Inject(method={"getRootResource"}, at={@At(value="RETURN")})
    public void getRootResourceReturnInjected(String[] paths, CallbackInfoReturnable<IoSupplier<InputStream>> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        String cacheKey = Arrays.toString(paths);
        boolean exists = cir.getReturnValue() != null;
        this.lightspeed$cacheExists(cacheKey, exists);
    }

    @Override
    public void lightspeed$persistAndClearCache() {
        if (this.lightspeed$modFile != null) {
            CacheUtil.persist(this.lightspeed$getExistenceByResource(), new File(CacheUtil.HAS_RESOURCE_CACHE_DIR.getPath(), this.lightspeed$id + ".ser"));
            CacheUtil.persist(this.lightspeed$namespacesByPackType, new File(CacheUtil.NAMESPACE_CACHE_DIR.getPath(), this.lightspeed$id + ".ser"));
        }
        this.lightspeed$getExistenceByResource().clear();
        this.lightspeed$resolvedPathByResource.clear();
        this.lightspeed$namespacesByPackType.clear();
        this.lightspeed$filePathsByRootByPackType.clear();
    }

    @Override
    public void lightspeed$setModFile(IModFile modFile) {
        this.lightspeed$modFile = modFile;
        this.lightspeed$id = modFile.getModFileInfo().moduleName() + modFile.getModFileInfo().versionString() + "-" + FilenameUtils.getBaseName((String)modFile.getFilePath().toString()).replaceAll("[^a-zA-Z0-9.-]", "");
        this.lightspeed$setExistenceByResource(GlobalCache.PERSISTED_EXISTENCES_BY_MOD.computeIfAbsent(this.lightspeed$id, i -> Maps.newConcurrentMap()));
    }

    @Unique
    public Path lightspeed$getResolvedPath(String ... paths) {
        return this.lightspeed$resolvedPathByResource.get(Arrays.toString(paths));
    }

    @Unique
    public Boolean lightspeed$exists(String resourceName) {
        return (Boolean)this.lightspeed$getExistenceByResource().get(resourceName);
    }

    @Unique
    public void lightspeed$cacheExists(String resourceName, boolean exists) {
        this.lightspeed$getExistenceByResource().put(resourceName, exists);
    }

    @Unique
    public void lightspeed$cacheNamespaces(PackType packType, Set<String> namespaces) {
        this.lightspeed$namespacesByPackType.put(packType, namespaces);
    }

    @Unique
    public Set<String> lightspeed$getCachedNamespaces(PackType packType) {
        return this.lightspeed$namespacesByPackType.get(packType);
    }
}

