/*
 * Decompiled with CFR 0.152.
 */
package com.ccr4ft3r.lightspeed.mixin.resources;

import com.ccr4ft3r.lightspeed.cache.GlobalCache;
import com.ccr4ft3r.lightspeed.interfaces.IPackResources;
import com.ccr4ft3r.lightspeed.util.CacheUtil;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VanillaPackResources.class})
public abstract class VanillaPackResourcesMixin
implements IPackResources {
    @Unique
    private Map<String, Boolean> lightspeed$existencePerClientResource = Maps.newConcurrentMap();
    @Unique
    private Map<String, Boolean> lightspeed$existencePerServerResource = Maps.newConcurrentMap();
    @Unique
    private String lightspeed$versionId;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initReturnInjected(CallbackInfo ci) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        GlobalCache.add(this);
        try {
            this.lightspeed$versionId = Minecraft.m_91087_().m_91388_();
        }
        catch (Exception e) {
            this.lightspeed$versionId = "unknown";
        }
        this.lightspeed$existencePerClientResource = GlobalCache.PERSISTED_EXISTENCES_BY_MOD.computeIfAbsent(this.lightspeed$versionId + "-client", k -> Maps.newConcurrentMap());
        this.lightspeed$existencePerServerResource = GlobalCache.PERSISTED_EXISTENCES_BY_MOD.computeIfAbsent(this.lightspeed$versionId + "-server", k -> Maps.newConcurrentMap());
    }

    @Inject(method={"getResource"}, at={@At(value="HEAD")}, cancellable=true)
    public void getResourceHeadInjected(PackType packType, ResourceLocation location, CallbackInfoReturnable<IoSupplier<InputStream>> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        Boolean exists = this.lightspeed$exists(packType, location.toString());
        if (Boolean.FALSE.equals(exists)) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"getResource"}, at={@At(value="RETURN")})
    public void getResourceReturnInjected(PackType packType, ResourceLocation location, CallbackInfoReturnable<IoSupplier<InputStream>> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        boolean actuallyExists = cir.getReturnValue() != null;
        this.lightspeed$cacheExists(packType, location.toString(), actuallyExists);
    }

    @Unique
    public Boolean lightspeed$exists(PackType packType, String resourceName) {
        if (packType == PackType.CLIENT_RESOURCES) {
            return this.lightspeed$existencePerClientResource.get(resourceName);
        }
        return this.lightspeed$existencePerServerResource.get(resourceName);
    }

    @Unique
    public void lightspeed$cacheExists(PackType packType, String resourceName, boolean exists) {
        if (packType == PackType.CLIENT_RESOURCES) {
            this.lightspeed$existencePerClientResource.put(resourceName, exists);
        } else {
            this.lightspeed$existencePerServerResource.put(resourceName, exists);
        }
    }

    @Override
    public void lightspeed$persistAndClearCache() {
        if (this.lightspeed$versionId != null) {
            CacheUtil.persist(this.lightspeed$existencePerClientResource, new File(CacheUtil.HAS_RESOURCE_CACHE_DIR.getPath(), this.lightspeed$versionId + "-client.ser"));
            CacheUtil.persist(this.lightspeed$existencePerServerResource, new File(CacheUtil.HAS_RESOURCE_CACHE_DIR.getPath(), this.lightspeed$versionId + "-server.ser"));
        }
        this.lightspeed$existencePerClientResource.clear();
        this.lightspeed$existencePerServerResource.clear();
    }
}

