/*
 * Decompiled with CFR 0.152.
 */
package com.ccr4ft3r.lightspeed.mixin.resources;

import com.ccr4ft3r.lightspeed.cache.GlobalCache;
import com.ccr4ft3r.lightspeed.interfaces.IPackResources;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FilePackResources.class})
public abstract class FilePackResourcesMixin
implements IPackResources {
    @Unique
    private final Map<PackType, List<ZipEntry>> lightspeed$entriesByPackType = Maps.newConcurrentMap();

    @Shadow
    @Nullable
    protected abstract ZipFile m_10247_();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initReturnInjected(String name, File file, boolean builtin, CallbackInfo ci) {
        if (GlobalCache.isEnabled.booleanValue()) {
            GlobalCache.add(this);
        }
    }

    @Inject(method={"listResources"}, at={@At(value="HEAD")}, cancellable=true)
    public void listResourcesHeadInjected(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput, CallbackInfo ci) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        ZipFile zip = this.m_10247_();
        if (zip == null) {
            return;
        }
        String s = packType.m_10305_() + "/" + namespace + "/";
        String s1 = s + path + "/";
        List<ZipEntry> entries = this.lightspeed$entriesByPackType.get(packType);
        if (entries == null) {
            entries = zip.stream().filter(e -> !e.isDirectory()).collect(Collectors.toList());
            this.lightspeed$entriesByPackType.put(packType, entries);
        }
        entries.stream().filter(e -> e.getName().startsWith(s1)).forEach(entry -> {
            String s3 = entry.getName().substring(s.length());
            ResourceLocation resourcelocation = ResourceLocation.m_214293_((String)namespace, (String)s3);
            if (resourcelocation != null) {
                resourceOutput.accept((Object)resourcelocation, (Object)IoSupplier.m_247178_((ZipFile)zip, (ZipEntry)entry));
            }
        });
        ci.cancel();
    }

    @Override
    public void lightspeed$persistAndClearCache() {
        this.lightspeed$entriesByPackType.clear();
    }
}

