/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.lib.data.PluginVersion;
import org.leralix.tancommon.bstat.Metrics;
import org.leralix.tancommon.commands.PlayerCommandManager;
import org.leralix.tancommon.markers.CommonMarkerRegister;
import org.leralix.tancommon.markers.IconType;
import org.leralix.tancommon.storage.ChunkManager;
import org.leralix.tancommon.update.UpdateChunks;
import org.leralix.tancommon.update.UpdateForts;
import org.leralix.tancommon.update.UpdateLandMarks;
import org.tan.api.TanAPI;

public abstract class TownsAndNationsMapCommon
extends JavaPlugin {
    private static TownsAndNationsMapCommon plugin;
    private final Logger logger = this.getLogger();
    private CommonMarkerRegister markerRegister;
    private long updatePeriod;
    private final PluginVersion pluginVersion = new PluginVersion(Integer.valueOf(0), Integer.valueOf(12), Integer.valueOf(1));
    private UpdateLandMarks updateLandMarks;
    private UpdateChunks updateChunks;
    private UpdateForts updateForts;
    private final String subMapName = "[TaN - " + this.getSubMapName() + "] - ";

    public void onEnable() {
        this.saveDefaultConfig();
        plugin = this;
        this.logger.info(this.subMapName + "Loading Plugin");
        new Metrics(this, this.getBStatID());
        PluginManager pm = this.getServer().getPluginManager();
        Plugin tanPlugin = pm.getPlugin("TownsAndNations");
        if (tanPlugin == null || !tanPlugin.isEnabled()) {
            this.logger.severe(this.subMapName + "Cannot find Towns and Nations, check your logs to see if it enabled properly?!");
            this.setEnabled(false);
            return;
        }
        TanAPI api = TanAPI.getInstance();
        PluginVersion minTanVersion = api.getMinimumSupportingMapPlugin();
        if (this.pluginVersion.isOlderThan(minTanVersion)) {
            this.logger.log(Level.SEVERE, this.subMapName + "Towns and Nations is not compatible with this version of tanmap (minimum version: {0})", minTanVersion);
            this.setEnabled(false);
            return;
        }
        Objects.requireNonNull(this.getCommand("tanmap")).setExecutor((CommandExecutor)new PlayerCommandManager());
        this.checkConfigVersion();
        this.initialise();
        this.logger.info(this.subMapName + "Plugin is running");
    }

    private void checkConfigVersion() {
        String configFileName = "config.yml";
        InputStream internalConfigStream = plugin.getResource(configFileName);
        if (internalConfigStream == null) {
            return;
        }
        YamlConfiguration internalConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(internalConfigStream));
        int configVersion = plugin.getConfig().getInt("config-version", 0);
        int internalConfigVersion = internalConfig.getInt("config-version", 999);
        if (internalConfigVersion != configVersion) {
            plugin.getLogger().info(this.subMapName + "Updating config from version " + configVersion + " to version version " + internalConfigVersion);
            plugin.saveResource(configFileName, true);
            this.getConfig().set("config-version", (Object)internalConfigVersion);
        }
    }

    private void initialise() {
        this.markerRegister = this.createMarkerRegister();
        this.registerIcons(this.markerRegister);
        if (!this.markerRegister.isWorking()) {
            this.logger.severe(this.subMapName + "Cannot find marker API, retrying in 5 seconds");
            new BukkitRunnable(){

                public void run() {
                    TownsAndNationsMapCommon.this.initialise();
                }
            }.runTaskLater((Plugin)this, 100L);
            return;
        }
        this.logger.info(this.subMapName + "Marker API found");
        int per = this.getConfig().getInt("update.period", 300);
        if (per < 15) {
            per = 15;
        }
        this.updatePeriod = (long)per * 20L;
        this.markerRegister.setup();
        this.startTasks();
    }

    private void registerIcons(CommonMarkerRegister markerRegister) {
        File iconsDir = new File(this.getDataFolder(), "icons");
        if (!iconsDir.exists()) {
            iconsDir.mkdirs();
        }
        for (IconType iconType : IconType.values()) {
            File iconFile = new File(iconsDir, iconType.getFileName());
            if (!iconFile.exists()) {
                TownsAndNationsMapCommon.getPlugin().saveResource("icons/" + iconType.getFileName(), true);
            }
            markerRegister.registerIcon(iconType);
        }
    }

    private void startTasks() {
        this.updateChunks = new UpdateChunks(new ChunkManager(this.markerRegister), this.updatePeriod);
        this.updateLandMarks = new UpdateLandMarks(this.markerRegister, this.updatePeriod);
        this.updateForts = new UpdateForts(this.markerRegister, this.updatePeriod);
        Runnable deleteAllRunnable = () -> this.markerRegister.deleteAllMarkers();
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, deleteAllRunnable, 40L);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)this.updateChunks, 40L);
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, (Runnable)this.updateLandMarks, 40L);
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)this.updateForts, 40L, this.updatePeriod);
    }

    public void onDisable() {
    }

    public static TownsAndNationsMapCommon getPlugin() {
        return plugin;
    }

    public void updateDynmap() {
        this.markerRegister.deleteAllMarkers();
        this.updateChunks.update();
        this.updateLandMarks.update();
    }

    protected abstract String getSubMapName();

    protected abstract int getBStatID();

    protected abstract CommonMarkerRegister createMarkerRegister();
}

