/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.markers;

import java.util.Collection;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.leralix.tancommon.TownsAndNationsMapCommon;
import org.leralix.tancommon.markers.IconType;
import org.leralix.tancommon.storage.PolygonCoordinate;
import org.tan.api.interfaces.TanFort;
import org.tan.api.interfaces.TanLandmark;
import org.tan.api.interfaces.TanTerritory;

public abstract class CommonMarkerRegister {
    public void setup() {
        FileConfiguration cfg = TownsAndNationsMapCommon.getPlugin().getConfig();
        cfg.options().copyDefaults(true);
        TownsAndNationsMapCommon.getPlugin().saveConfig();
        String id = "townsandnations.landmarks";
        String name = cfg.getString("landmark_layer.name", "Towns and Nations - Landmarks");
        int minZoom = Math.max(cfg.getInt("landmark_layer.minimum_zoom", 0), 0);
        int chunkLayerPriority = Math.max(cfg.getInt("landmark_layer.priority", 10), 0);
        boolean hideByDefault = cfg.getBoolean("landmark_layer.hide_by_default", false);
        List worldsName = cfg.getStringList("landmark_layer.worlds");
        this.setupLandmarkLayer(id, name, minZoom, chunkLayerPriority, hideByDefault, worldsName);
        String id2 = "townsandnations.chunks";
        String name2 = cfg.getString("chunk_layer.name", "Towns and Nations");
        int minZoom2 = Math.max(cfg.getInt("chunk_layer.minimum_zoom", 0), 0);
        int chunkLayerPriority2 = Math.max(cfg.getInt("chunk_layer.priority", 10), 0);
        boolean hideByDefault2 = cfg.getBoolean("chunk_layer.hide_by_default", false);
        List worldsName2 = cfg.getStringList("chunk_layer.worlds");
        this.setupChunkLayer(id2, name2, minZoom2, chunkLayerPriority2, hideByDefault2, worldsName2);
        String id3 = "townsandnations.forts";
        String name3 = cfg.getString("chunk_layer.name", "Towns and Nations");
        int minZoom3 = Math.max(cfg.getInt("chunk_layer.minimum_zoom", 0), 0);
        int chunkLayerPriority3 = Math.max(cfg.getInt("chunk_layer.priority", 10), 0);
        boolean hideByDefault3 = cfg.getBoolean("chunk_layer.hide_by_default", false);
        List worldsName3 = cfg.getStringList("chunk_layer.worlds");
        this.setupFortLayer(id3, name3, minZoom3, chunkLayerPriority3, hideByDefault3, worldsName3);
    }

    protected abstract void setupLandmarkLayer(String var1, String var2, int var3, int var4, boolean var5, List<String> var6);

    protected abstract void setupChunkLayer(String var1, String var2, int var3, int var4, boolean var5, List<String> var6);

    protected abstract void setupFortLayer(String var1, String var2, int var3, int var4, boolean var5, List<String> var6);

    public abstract boolean isWorking();

    public abstract void registerNewLandmark(TanLandmark var1);

    public abstract void registerNewFort(TanFort var1);

    public abstract void registerNewArea(String var1, TanTerritory var2, boolean var3, String var4, PolygonCoordinate var5, String var6, Collection<PolygonCoordinate> var7);

    protected String generateDescription(TanLandmark landmark) {
        String res = TownsAndNationsMapCommon.getPlugin().getConfig().getString("landmark_infowindow");
        if (res == null) {
            return "No description";
        }
        ItemStack reward = landmark.getItem();
        String ownerName = landmark.isOwned() ? landmark.getOwner().getName() : "No owner";
        res = res.replace("%QUANTITY%", String.valueOf(reward.getAmount()));
        res = res.replace("%ITEM%", reward.getType().name());
        res = res.replace("%OWNER%", ownerName);
        return res;
    }

    protected String generateDescription(TanFort fort) {
        String res = TownsAndNationsMapCommon.getPlugin().getConfig().getString("fort_infowindow");
        if (res == null) {
            return "No description";
        }
        res = res.replace("%FORT_NAME%", fort.getName());
        res = res.replace("%OWNER%", fort.getOwner().getName());
        res = res.replace("%OCCUPIER%", fort.getOccupier() != null ? fort.getOccupier().getName() : "No occupier");
        return res;
    }

    public abstract void deleteAllMarkers();

    public abstract void registerIcon(IconType var1);
}

