/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.storage;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tancommon.markers.CommonMarkerRegister;
import org.leralix.tancommon.storage.GenericHoleDetector;
import org.leralix.tancommon.storage.PolygonCoordinate;
import org.leralix.tancommon.storage.RegionDescriptionStorage;
import org.leralix.tancommon.storage.TileFlags;
import org.leralix.tancommon.storage.TownDescriptionStorage;
import org.tan.api.interfaces.TanClaimedChunk;
import org.tan.api.interfaces.TanRegion;
import org.tan.api.interfaces.TanTerritory;
import org.tan.api.interfaces.TanTown;

public class ChunkManager {
    private final CommonMarkerRegister commonMarkerRegister;

    public ChunkManager(CommonMarkerRegister markerRegister) {
        this.commonMarkerRegister = markerRegister;
    }

    private void updateTerritory(TanTerritory territory, String infoWindowPopup) {
        int polyIndex = 0;
        Collection townClaimedChunks = territory.getClaimedChunks();
        if (townClaimedChunks.isEmpty()) {
            return;
        }
        HashMap<String, TileFlags> worldNameShapeMap = new HashMap<String, TileFlags>();
        LinkedList<TanClaimedChunk> claimedChunksToDraw = new LinkedList<TanClaimedChunk>();
        World currentWorld = null;
        TileFlags currentShape = null;
        for (TanClaimedChunk townClaimedChunk : townClaimedChunks) {
            World world = Bukkit.getWorld((UUID)townClaimedChunk.getWorldUUID());
            if (world == null) continue;
            if (world != currentWorld) {
                String worldName = world.getName();
                currentShape = (TileFlags)worldNameShapeMap.get(worldName);
                if (currentShape == null) {
                    currentShape = new TileFlags();
                    worldNameShapeMap.put(worldName, currentShape);
                }
                currentWorld = world;
            }
            if (currentShape == null) {
                currentShape = new TileFlags();
            }
            currentShape.setFlag(townClaimedChunk.getX(), townClaimedChunk.getZ(), true);
            claimedChunksToDraw.addLast(townClaimedChunk);
        }
        while (claimedChunksToDraw != null) {
            LinkedList<TanClaimedChunk> ourTownBlocks = null;
            LinkedList<TanClaimedChunk> townBlockLeftToDraw = null;
            TileFlags ourShape = null;
            int minx = Integer.MAX_VALUE;
            int minz = Integer.MAX_VALUE;
            for (TanClaimedChunk claimedChunk : claimedChunksToDraw) {
                int tbX = claimedChunk.getX();
                int tbZ = claimedChunk.getZ();
                World world = Bukkit.getWorld((UUID)claimedChunk.getWorldUUID());
                if (ourShape == null && world != currentWorld) {
                    currentWorld = world;
                    currentShape = (TileFlags)worldNameShapeMap.get(currentWorld.getName());
                }
                if (ourShape == null && currentShape.getFlag(tbX, tbZ)) {
                    ourShape = new TileFlags();
                    ourTownBlocks = new LinkedList<TanClaimedChunk>();
                    this.floodFillTarget(currentShape, ourShape, tbX, tbZ);
                    ourTownBlocks.add(claimedChunk);
                    minx = tbX;
                    minz = tbZ;
                    continue;
                }
                if (ourShape != null && world == currentWorld && ourShape.getFlag(tbX, tbZ)) {
                    ourTownBlocks.add(claimedChunk);
                    if (tbX < minx) {
                        minx = tbX;
                        minz = tbZ;
                        continue;
                    }
                    if (tbX != minx || tbZ >= minz) continue;
                    minz = tbZ;
                    continue;
                }
                if (townBlockLeftToDraw == null) {
                    townBlockLeftToDraw = new LinkedList<TanClaimedChunk>();
                }
                townBlockLeftToDraw.add(claimedChunk);
            }
            claimedChunksToDraw = townBlockLeftToDraw;
            if (ourShape == null) continue;
            polyIndex = this.traceTerritoryOutline(territory, polyIndex, infoWindowPopup, currentWorld.getName(), ourShape, minx, minz);
        }
    }

    public void updateTown(TanTown town) {
        String infoWindowPopup = TownDescriptionStorage.get(town.getID()).getChunkDescription();
        this.updateTerritory((TanTerritory)town, infoWindowPopup);
    }

    public void updateRegion(TanRegion region) {
        String infoWindowPopup = RegionDescriptionStorage.get(region.getID()).getChunkDescription();
        this.updateTerritory((TanTerritory)region, infoWindowPopup);
    }

    private void floodFillTarget(TileFlags src, TileFlags dest, int x, int y) {
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(new int[]{x, y});
        while (!stack.isEmpty()) {
            int[] nxt = (int[])stack.pop();
            x = nxt[0];
            if (!src.getFlag(x, y = nxt[1])) continue;
            src.setFlag(x, y, false);
            dest.setFlag(x, y, true);
            if (src.getFlag(x + 1, y)) {
                stack.push(new int[]{x + 1, y});
            }
            if (src.getFlag(x - 1, y)) {
                stack.push(new int[]{x - 1, y});
            }
            if (src.getFlag(x, y + 1)) {
                stack.push(new int[]{x, y + 1});
            }
            if (!src.getFlag(x, y - 1)) continue;
            stack.push(new int[]{x, y - 1});
        }
    }

    private int traceTerritoryOutline(TanTerritory territoryData, int polyIndex, String infoWindowPopup, String worldName, TileFlags ourShape, int minx, int minz) {
        String polyid = territoryData.getID() + "_" + polyIndex;
        PolygonCoordinate polygonCoordinate = this.createPolygon(ourShape, minx, minz);
        Collection<PolygonCoordinate> holes = this.createTerritoryHoles(ourShape, polygonCoordinate);
        this.commonMarkerRegister.registerNewArea(polyid, territoryData, false, worldName, polygonCoordinate, infoWindowPopup, holes);
        return ++polyIndex;
    }

    private Collection<PolygonCoordinate> createTerritoryHoles(TileFlags ourShape, PolygonCoordinate computedShape) {
        ArrayList<PolygonCoordinate> holes = new ArrayList<PolygonCoordinate>();
        int minX = computedShape.getSmallestX() / 16;
        int minZ = computedShape.getSmallestZ() / 16;
        int maxX = computedShape.getBiggestX() / 16;
        int maxZ = computedShape.getBiggestZ() / 16;
        GenericHoleDetector genericHoleDetector = new GenericHoleDetector(ourShape);
        for (TileFlags tileFlags : genericHoleDetector.getHoles(minX, minZ, maxX, maxZ)) {
            int holeStartX = -1;
            int holeStartZ = -1;
            boolean found = false;
            for (int x = minX; x <= maxX && !found; ++x) {
                for (int z = minZ; z <= maxZ && !found; ++z) {
                    if (!tileFlags.getFlag(x, z) || tileFlags.getFlag(x + 1, z) && tileFlags.getFlag(x - 1, z) && tileFlags.getFlag(x, z + 1) && tileFlags.getFlag(x, z - 1)) continue;
                    holeStartX = x;
                    holeStartZ = z;
                    found = true;
                }
            }
            if (!found) continue;
            holes.add(this.createPolygon(tileFlags, holeStartX, holeStartZ));
        }
        return holes;
    }

    private PolygonCoordinate createPolygon(TileFlags ourShape, int minx, int minz) {
        int cur_x = minx;
        int cur_z = minz;
        direction dir = direction.XPLUS;
        ArrayList<int[]> linelist = new ArrayList<int[]>();
        linelist.add(new int[]{minx, minz});
        int nbIters = 0;
        int nbMaxIters = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("polygon_max_points", 100000);
        while ((cur_x != minx || cur_z != minz || dir != direction.ZMINUS) && nbIters < nbMaxIters) {
            ++nbIters;
            switch (dir) {
                case XPLUS: {
                    if (!ourShape.getFlag(cur_x + 1, cur_z)) {
                        linelist.add(new int[]{cur_x + 1, cur_z});
                        dir = direction.ZPLUS;
                        break;
                    }
                    if (!ourShape.getFlag(cur_x + 1, cur_z - 1)) {
                        ++cur_x;
                        break;
                    }
                    linelist.add(new int[]{cur_x + 1, cur_z--});
                    dir = direction.ZMINUS;
                    ++cur_x;
                    break;
                }
                case ZPLUS: {
                    if (!ourShape.getFlag(cur_x, cur_z + 1)) {
                        linelist.add(new int[]{cur_x + 1, cur_z + 1});
                        dir = direction.XMINUS;
                        break;
                    }
                    if (!ourShape.getFlag(cur_x + 1, cur_z + 1)) {
                        ++cur_z;
                        break;
                    }
                    linelist.add(new int[]{cur_x + 1, cur_z + 1});
                    dir = direction.XPLUS;
                    ++cur_x;
                    ++cur_z;
                    break;
                }
                case XMINUS: {
                    if (!ourShape.getFlag(cur_x - 1, cur_z)) {
                        linelist.add(new int[]{cur_x, cur_z + 1});
                        dir = direction.ZMINUS;
                        break;
                    }
                    if (!ourShape.getFlag(cur_x - 1, cur_z + 1)) {
                        --cur_x;
                        break;
                    }
                    linelist.add(new int[]{cur_x--, cur_z + 1});
                    dir = direction.ZPLUS;
                    ++cur_z;
                    break;
                }
                case ZMINUS: {
                    if (!ourShape.getFlag(cur_x, cur_z - 1)) {
                        linelist.add(new int[]{cur_x, cur_z});
                        dir = direction.XPLUS;
                        break;
                    }
                    if (!ourShape.getFlag(cur_x - 1, cur_z - 1)) {
                        --cur_z;
                        break;
                    }
                    linelist.add(new int[]{cur_x--, cur_z--});
                    dir = direction.XMINUS;
                }
            }
        }
        int sz = linelist.size();
        int[] x = new int[sz];
        int[] z = new int[sz];
        for (int i = 0; i < sz; ++i) {
            int[] line = (int[])linelist.get(i);
            x[i] = line[0] * 16;
            z[i] = line[1] * 16;
        }
        return new PolygonCoordinate(x, z);
    }

    static enum direction {
        XPLUS,
        ZPLUS,
        XMINUS,
        ZMINUS;

    }
}

