/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tancommon.storage;

import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import org.leralix.tancommon.storage.TileFlags;

public class GenericHoleDetector {
    private TileFlags gridFlags;

    public GenericHoleDetector(TileFlags gridFlags) {
        this.gridFlags = gridFlags;
    }

    public Collection<TileFlags> getHoles(int minX, int minY, int maxX, int maxY) {
        HashSet<TileFlags> holes = new HashSet<TileFlags>();
        TileFlags visited = new TileFlags();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                TileFlags hole;
                if (this.gridFlags.getFlag(x, y) || visited.getFlag(x, y) || !this.floodFill(hole = new TileFlags(), visited, x, y, minX, minY, maxX, maxY)) continue;
                holes.add(hole);
            }
        }
        return holes;
    }

    private boolean floodFill(TileFlags hole, TileFlags visited, int startX, int startY, int minX, int minY, int maxX, int maxY) {
        Stack<int[]> stack = new Stack<int[]>();
        stack.push(new int[]{startX, startY});
        boolean isHole = true;
        while (!stack.isEmpty()) {
            int y;
            int[] point = (int[])stack.pop();
            int x = point[0];
            if (visited.getFlag(x, y = point[1])) continue;
            visited.setFlag(x, y, true);
            if (this.gridFlags.getFlag(x, y)) continue;
            hole.setFlag(x, y, true);
            if (x > minX) {
                stack.push(new int[]{x - 1, y});
            }
            if (x < maxX) {
                stack.push(new int[]{x + 1, y});
            }
            if (y > minY) {
                stack.push(new int[]{x, y - 1});
            }
            if (y >= maxY) continue;
            stack.push(new int[]{x, y + 1});
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                if (!hole.getFlag(x, y) || x != minX && x != maxX && y != minY && y != maxY) continue;
                return false;
            }
        }
        return isHole;
    }
}

