/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tandynmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PolyLineMarker;
import org.leralix.tancommon.TownsAndNationsMapCommon;
import org.leralix.tancommon.markers.CommonMarkerRegister;
import org.leralix.tancommon.markers.IconType;
import org.leralix.tancommon.storage.PolygonCoordinate;
import org.leralix.tandynmap.TownsAndNationsDynmap;
import org.tan.api.interfaces.TanClaimedChunk;
import org.tan.api.interfaces.TanFort;
import org.tan.api.interfaces.TanLandmark;
import org.tan.api.interfaces.TanTerritory;

public class DynmapMarkerRegister
extends CommonMarkerRegister {
    private final MarkerAPI dynmapLayerAPI;
    private MarkerSet landmarkMarkerSet;
    private MarkerSet chunkMarkerSet;
    private MarkerSet fortMarkerSet;

    public DynmapMarkerRegister() {
        Plugin plugin = TownsAndNationsDynmap.getPlugin().getServer().getPluginManager().getPlugin("dynmap");
        if (plugin instanceof DynmapAPI) {
            DynmapAPI dynmapAPI = (DynmapAPI)plugin;
            this.dynmapLayerAPI = dynmapAPI.getMarkerAPI();
        } else {
            this.dynmapLayerAPI = null;
        }
    }

    @Override
    protected void setupLandmarkLayer(String id, String name, int minZoom, int chunkLayerPriority, boolean hideByDefault, List<String> worldsName) {
        this.landmarkMarkerSet = this.dynmapLayerAPI.createMarkerSet("landmarks", name, null, false);
    }

    @Override
    protected void setupChunkLayer(String id, String name, int minZoom, int chunkLayerPriority, boolean hideByDefault, List<String> worldsName) {
        this.chunkMarkerSet = this.dynmapLayerAPI.createMarkerSet("chunks", name, null, false);
    }

    @Override
    protected void setupFortLayer(String id, String name, int minZoom, int chunkLayerPriority, boolean hideByDefault, List<String> worldsName) {
        this.fortMarkerSet = this.dynmapLayerAPI.createMarkerSet("forts", name, null, false);
    }

    @Override
    public boolean isWorking() {
        return this.dynmapLayerAPI != null;
    }

    @Override
    public void registerNewLandmark(TanLandmark landmark) {
        Marker marker = this.landmarkMarkerSet.findMarker(landmark.getID());
        if (marker != null) {
            marker.deleteMarker();
        }
        Location location = landmark.getLocation();
        marker = this.landmarkMarkerSet.createMarker(landmark.getID(), landmark.getName(), location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), landmark.isOwned() ? this.dynmapLayerAPI.getMarkerIcon(IconType.LANDMARK_CLAIMED.getFileName()) : this.dynmapLayerAPI.getMarkerIcon(IconType.LANDMARK_UNCLAIMED.getFileName()), true);
        marker.setDescription(this.generateDescription(landmark));
    }

    @Override
    public void registerNewFort(TanFort fort) {
        Marker marker = this.fortMarkerSet.findMarker(fort.getID());
        if (marker != null) {
            marker.deleteMarker();
        }
        Location location = fort.getFlagPosition().getLocation();
        marker = this.fortMarkerSet.createMarker(fort.getID(), fort.getName(), location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), this.dynmapLayerAPI.getMarkerIcon(IconType.FORT.getFileName()), true);
        marker.setDescription(this.generateDescription(fort));
    }

    @Override
    public void registerNewArea(String polyid, TanTerritory territoryData, boolean b, String worldName, PolygonCoordinate coordinates, String infoWindowPopup, Collection<PolygonCoordinate> holes) {
        Color chunkColor = territoryData.getColor();
        int i = 0;
        for (TanClaimedChunk chunk : territoryData.getClaimedChunks()) {
            String id = polyid + "_" + i;
            AreaMarker areaMarker = this.chunkMarkerSet.findAreaMarker(id);
            if (areaMarker != null) {
                areaMarker.deleteMarker();
            }
            double[] x = new double[4];
            double[] z = new double[4];
            x[0] = (double)chunk.getX() * 16.0;
            x[1] = (double)chunk.getX() * 16.0;
            x[2] = (double)(chunk.getX() + 1) * 16.0 + 0.01;
            x[3] = (double)(chunk.getX() + 1) * 16.0 + 0.01;
            z[0] = (double)chunk.getZ() * 16.0;
            z[1] = (double)(chunk.getZ() + 1) * 16.0 + 0.01;
            z[2] = (double)(chunk.getZ() + 1) * 16.0 + 0.01;
            z[3] = (double)chunk.getZ() * 16.0;
            areaMarker = this.chunkMarkerSet.createAreaMarker(id, territoryData.getName() + "_" + i, b, worldName, x, z, false);
            areaMarker.setLineStyle(0, 0.6, chunkColor.asRGB());
            areaMarker.setFillStyle(0.6, chunkColor.asRGB());
            areaMarker.setDescription(infoWindowPopup);
            ++i;
        }
        ArrayList<PolygonCoordinate> polygonLines = new ArrayList<PolygonCoordinate>(holes);
        polygonLines.add(coordinates);
        i = 0;
        for (PolygonCoordinate lines : polygonLines) {
            String id = polyid + "_l" + i;
            PolyLineMarker polyLineMarker = this.chunkMarkerSet.findPolyLineMarker(id);
            if (polyLineMarker != null) {
                polyLineMarker.deleteMarker();
            }
            double[] hx = DynmapMarkerRegister.loopCoordinates(lines.getX());
            double[] hz = DynmapMarkerRegister.loopCoordinates(lines.getZ());
            polyLineMarker = this.chunkMarkerSet.createPolyLineMarker(id, territoryData.getName() + "_line_" + i, true, worldName, hx, hz, hz, false);
            polyLineMarker.setLineStyle(2, 9.0, chunkColor.asRGB());
            ++i;
        }
    }

    private static double[] loopCoordinates(int[] coordinates) {
        double[] x = Arrays.stream(coordinates).asDoubleStream().toArray();
        double[] xLooped = Arrays.copyOf(x, x.length + 1);
        xLooped[x.length] = x[0];
        return xLooped;
    }

    @Override
    public void deleteAllMarkers() {
        for (AreaMarker areaMarker : this.chunkMarkerSet.getAreaMarkers()) {
            areaMarker.deleteMarker();
        }
        for (Marker marker : this.landmarkMarkerSet.getMarkers()) {
            marker.deleteMarker();
        }
        for (AreaMarker areaMarker : this.fortMarkerSet.getAreaMarkers()) {
            areaMarker.deleteMarker();
        }
    }

    @Override
    public void registerIcon(IconType iconType) {
        this.dynmapLayerAPI.createMarkerIcon(iconType.getFileName(), iconType.getFileName(), TownsAndNationsMapCommon.getPlugin().getResource("icons/" + iconType.getFileName()));
    }
}

