/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tandynmap.markers;

import java.awt.Color;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerSet;
import org.leralix.tancommon.markers.CommonAreaMarker;
import org.leralix.tancommon.markers.CommonMarkerSet;
import org.leralix.tandynmap.markers.DynmapAreaMarker;
import org.tan.api.interfaces.TanLandmark;

public class DynmapMarkerSet
extends CommonMarkerSet {
    private final MarkerAPI markerAPI;
    private final MarkerSet markerSet;

    public DynmapMarkerSet(MarkerAPI markerAPI, String id, String layerName, int minZoom, int chunkLayerPriority, boolean hideByDefault) {
        this.markerAPI = markerAPI;
        this.markerSet = markerAPI.createMarkerSet(id, layerName, null, false);
        this.markerSet.setMinZoom(minZoom);
        this.markerSet.setLayerPriority(chunkLayerPriority);
        this.markerSet.setHideByDefault(hideByDefault);
    }

    @Override
    public void deleteAllMarkers() {
        for (AreaMarker areaMarker : this.markerSet.getAreaMarkers()) {
            areaMarker.deleteMarker();
        }
        for (Marker marker : this.markerSet.getMarkers()) {
            marker.deleteMarker();
        }
    }

    @Override
    public void createLandmark(TanLandmark landmark, String name, String worldName, int x, int y, int z, boolean b) {
        Marker marker = this.markerSet.findMarker(landmark.getID());
        if (marker != null) {
            marker.deleteMarker();
        }
        marker = this.markerSet.createMarker(landmark.getID(), name, worldName, (double)x, (double)y, (double)z, this.markerAPI.getMarkerIcon("diamond"), b);
        marker.setDescription(this.generateDescription(landmark));
    }

    @Override
    public CommonAreaMarker createAreaMarker(String polyID, String name, boolean b, String worldName, double[] x, double[] z, Color color, String description) {
        AreaMarker areaMarker = this.markerSet.findAreaMarker(polyID);
        if (areaMarker != null) {
            areaMarker.deleteMarker();
        }
        AreaMarker marker = this.markerSet.createAreaMarker(polyID, name, b, worldName, x, z, false);
        marker.setDescription(description);
        return new DynmapAreaMarker(marker);
    }
}

