package archives.tater.phantomfall;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1770;
import net.minecraft.class_1948;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4081;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

import static archives.tater.phantomfall.PhantomFallAttachments.*;
import static java.lang.Math.min;

@SuppressWarnings("UnstableApiUsage")
public class PhantomFall implements ModInitializer {
	public static final String MOD_ID = "phantomfall";

	public static class_2960 id(String path) {
		return class_2960.method_60655(MOD_ID, path);
	}

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    private static class_3414 registerSound(class_2960 id) {
        return class_2378.method_10230(class_7923.field_41172, id, class_3414.method_47908(id));
    }

	public static final PhantomFallConfig CONFIG = PhantomFallConfig.createToml(
			FabricLoader.getInstance().getConfigDir(),
			MOD_ID,
			MOD_ID,
			PhantomFallConfig.class
	);

	public static final class_6862<class_8110> PHANTOM_PICKUP = class_6862.method_40092(class_7924.field_42534, id("phantom_pickup"));

    public static final class_2400 INSOMNIA_OMEN_PARTICLE = class_2378.method_10230(
            class_7923.field_41180,
            id("insomnia_omen"),
            FabricParticleTypes.simple()
    );

    public static final class_3414 EVENT_MOB_EFFECT_INSOMNIA_OMEN = registerSound(id("event.mob_effect.insomnia_omen"));

    public static final class_6880<class_1291> INSOMNIA_OMEN = class_2378.method_47985(
            class_7923.field_41174,
            id("insomnia_omen"),
            new class_1291(class_4081.field_18273, 0x5061A4FF, INSOMNIA_OMEN_PARTICLE) {}.method_58616(EVENT_MOB_EFFECT_INSOMNIA_OMEN)
    );

	public static boolean canWearPhantom(class_1657 player) {
		var chestEquipment = player.method_6118(class_1304.field_6174).method_7909();
		return !(chestEquipment instanceof class_1770) && !(chestEquipment instanceof FabricElytraItem);
	}

	public static List<Integer> distributeSizes(int value, class_5819 random) {
		var sizes = new ArrayList<Integer>();
		var remaining = value;
		while (remaining > 0) {
			var size = min(random.method_39332(1, CONFIG.server.maxPhantomSize), remaining);
			sizes.add(size); // Phantom size starts at 0
			remaining -= size;
		}
		return sizes;
	}

    public static boolean hasInsomniaOrOmen(class_1309 entity) {
        return entity.method_6059(class_1294.field_16595) || entity.method_6059(INSOMNIA_OMEN);
    }

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.
        PhantomFallAttachments.register();

		ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> {
			if (blocked) return;
			if (entity.method_6128()) return;
            if (!source.method_48789(PHANTOM_PICKUP)) return;
			var attacker = source.method_5529();
			if (!(attacker instanceof class_1593)) return;
			if (entity.method_5854() instanceof class_1593) return;
			if ((entity instanceof class_1657) && entity.hasAttached(PHANTOM_DATA)) return;
            entity.method_5804(attacker);
        });
		ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, damageAmount) -> {
            if (!(entity instanceof class_1593 phantom) || !(entity.method_31483() instanceof class_1657 player)) return true;

			player.method_29239();

            if (damageSource.method_5529() != player || !canWearPhantom(player) || EntityElytraEvents.CUSTOM.invoker().useCustomElytra(entity, false)) return true;

            phantom.method_6033(1);
            PhantomFallAttachments.setPhantom(player, phantom);
            phantom.method_31472();
            player.method_23669();

            return false;
        });
		EntityElytraEvents.CUSTOM.register((entity, tickElytra) ->
				entity instanceof class_1657 player && player.hasAttached(PHANTOM_DATA));

        EntitySleepEvents.START_SLEEPING.register((entity, sleepingPos) -> {
            var badOmenInstance = entity.method_6112(class_1294.field_16595);
            if (badOmenInstance == null) return;
            var amplifier = badOmenInstance.method_5578();
            entity.method_6016(class_1294.field_16595);
            entity.method_6092(new class_1293(INSOMNIA_OMEN, (amplifier + 1) * 20 * 60 * 20));
        });

        EntitySleepEvents.ALLOW_SETTING_SPAWN.register((player, sleepingPos) -> !hasInsomniaOrOmen(player));
        EntitySleepEvents.ALLOW_RESETTING_TIME.register(player -> !hasInsomniaOrOmen(player));
        EntitySleepEvents.ALLOW_SLEEP_TIME.register((player,  sleepingPos, vanillaResult) -> hasInsomniaOrOmen(player) && player.method_37908().method_8597().method_29960() ? class_1269.field_5812 : class_1269.field_5811);
        EntitySleepEvents.ALLOW_NEARBY_MONSTERS.register((player, sleepingPos, vanillaResult) -> hasInsomniaOrOmen(player) ? class_1269.field_5812 : class_1269.field_5811);

		EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
			var world = entity.method_37908();
			if (!(world instanceof class_3218 serverWorld)) return;
			if (!(entity instanceof class_1657 player)) return;
			int cooldown = player.getAttachedOrElse(PHANTOM_COOLDOWN, 0);
			if (cooldown > 0) return;
			world.method_8533(); // day/night is based on ambient light which normally only updates every tick
			if (!world.method_23886() && !hasInsomniaOrOmen(player)) {
				player.removeAttached(PHANTOMS_SPAWNED);
				return;
			}
			if (world.method_8597().comp_642() && !world.method_8311(entity.method_24515())) return;

			int spawnedPhantoms = player.getAttachedOrElse(PHANTOMS_SPAWNED, 0);
			var random = world.method_8409();

			if (!hasInsomniaOrOmen(player) && random.method_43057() > CONFIG.server.baseSpawnChance + CONFIG.server.spawnChanceIncrease * spawnedPhantoms) return;

			var success = false;

			for (var size : distributeSizes(min(spawnedPhantoms + 1, CONFIG.server.maxSpawnScore), random)) {
				var blockPos = entity.method_24515().method_10086(20 + random.method_43048(15)).method_10089(-10 + random.method_43048(21)).method_10077(-10 + random.method_43048(21));
				if (!class_1948.method_8662(world, blockPos, world.method_8320(blockPos), world.method_8316(blockPos), class_1299.field_6078)) continue;
				var phantom = class_1299.field_6078.method_5883(world);
				if (phantom == null) continue;
				phantom.method_5725(blockPos, 0.0F, 0.0F);
				phantom.method_5943(serverWorld, world.method_8404(entity.method_24515()), class_3730.field_16459, null);
				phantom.method_7091(size);
				phantom.method_6033(phantom.method_6063());
				serverWorld.method_30771(phantom);
				success = true;
			}

			if (success) {
				player.method_17356(class_3417.field_14813, player.method_5634(), 1f, 0.6f);
                PhantomFallAttachments.increaseAmount(player);
                PhantomFallAttachments.setCooldown(player);
			}
		});
	}
}
