package archives.tater.phantomfall;

import archives.tater.phantomfall.render.PhantomBodyFeatureRenderer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRenderEvents;
import net.fabricmc.fabric.api.client.rendering.v1.LivingEntityFeatureRendererRegistrationCallback;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_5498;
import net.minecraft.class_591;
import net.minecraft.class_711;
import org.jetbrains.annotations.Nullable;

import static archives.tater.phantomfall.PhantomFallAttachments.PHANTOM_DATA;

@SuppressWarnings("UnstableApiUsage")
public class PhantomFallClient implements ClientModInitializer {

	private static boolean perspectiveChanged = false;
	private static @Nullable class_5498 savedPerspective = null;

	public static void savePerspective() {
		var options = class_310.method_1551().field_1690;
		savedPerspective = options.method_31044();
		options.method_31043(class_5498.field_26665);
	}

	public static void restorePerspective() {
		if (savedPerspective == null) return;
		var options = class_310.method_1551().field_1690;
		if (options.method_31044() == class_5498.field_26665)
			options.method_31043(savedPerspective);
		savedPerspective = null;
	}

	public static void clearPerspective() {
		savedPerspective = null;
	}

	@SuppressWarnings("unchecked")
    @Override
	public void onInitializeClient() {
		// This entrypoint is suitable for setting up client-specific logic, such as rendering.
        ParticleFactoryRegistry.getInstance().register(PhantomFall.INSOMNIA_OMEN_PARTICLE, class_711.class_715::new);

		LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
			if (entityType == class_1299.field_6097)
                registrationHelper.register(new PhantomBodyFeatureRenderer((class_3883<class_1657, class_591<class_1657>>) entityRenderer, context.method_32170()));
		});
		LivingEntityFeatureRenderEvents.ALLOW_CAPE_RENDER.register(player ->
				!player.hasAttached(PHANTOM_DATA));
		ClientTickEvents.END_WORLD_TICK.register(clientWorld -> {
			if (!PhantomFall.CONFIG.client.changePerspective) return;
			var clientPlayer = class_310.method_1551().field_1724;
			if (clientPlayer == null) return;
			if (clientPlayer.hasAttached(PHANTOM_DATA)) {
				if (!perspectiveChanged) {
					savePerspective();
					perspectiveChanged = true;
				}
			} else {
				if (perspectiveChanged) {
					restorePerspective();
					perspectiveChanged = false;
				}
			}
		});
		ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
			clearPerspective();
			perspectiveChanged = false;
		});
	}
}
