package archives.tater.phantomfall.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1297;
import net.minecraft.class_1593;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@Mixin(class_1297.class)
public abstract class EntityMixin {
    @Shadow public abstract double getY();

    @SuppressWarnings("ConstantValue")
    @ModifyArg(
            method = "updatePassengerPosition(Lnet/minecraft/entity/Entity;Lnet/minecraft/entity/Entity$PositionUpdater;)V",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity$PositionUpdater;accept(Lnet/minecraft/entity/Entity;DDD)V"),
            index = 2
    )
    protected double updatePassengerPosition(double y, @Local(argsOnly = true, ordinal = 1) class_1297 passenger) {
        if (!((Object) this instanceof class_1593)) return y;
        return getY() - passenger.method_17682();
    }
}
