package archives.tater.phantomfall.mixin;

import archives.tater.phantomfall.PhantomFall;
import archives.tater.phantomfall.PhantomFallAttachments;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import com.mojang.authlib.GameProfile;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends class_1657 {
    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @ModifyExpressionValue(
            method = "trySleep",
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/dimension/DimensionType;natural()Z")
    )
    private boolean allowInsomniaOmen(boolean original) {
        return original || PhantomFall.hasInsomniaOrOmen(this);
    }

    @Inject(
            method = "tick",
            at = @At("TAIL")
    )
    private void tickAttachments(CallbackInfo ci) {
        PhantomFallAttachments.tickAttachments((class_3222) (class_1657) this);
    }
}
