package archives.tater.phantomfall.render;

import archives.tater.phantomfall.PhantomFallAttachments;
import archives.tater.phantomfall.mixin.client.PhantomEntityModelAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_588;
import net.minecraft.class_591;
import net.minecraft.class_6230;
import net.minecraft.class_742;
import net.minecraft.class_7833;
import net.minecraft.client.render.entity.model.*;

@Environment(EnvType.CLIENT)
public class PhantomBodyFeatureRenderer extends class_3887<class_1657, class_591<class_1657>> {
    private final class_588<class_1593> model;

    private static final class_2960 TEXTURE = class_2960.method_60656("textures/entity/phantom.png");

    public PhantomBodyFeatureRenderer(class_3883<class_1657, class_591<class_1657>> context, class_5599 loader) {
        super(context);
        model = new class_588<>(loader.method_32072(class_5602.field_27620));
        model.method_41909(class_6230.field_32606).ifPresent(modelPart -> modelPart.field_3665 = false);
        model.method_41909(class_6230.field_32608).ifPresent(modelPart -> modelPart.field_3654 = 0);
    }

    @Override
    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_1657 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        var phantom = PhantomFallAttachments.getPhantom(entity);
        if (phantom == null) return;

        var velocityNormY = entity.method_18798().method_1029().field_1351;
        var value = velocityNormY > 0 ? 0f : Math.pow(-velocityNormY, 1.5);

        var pitch = (float) (value * (Math.PI / 18) + value * Math.PI / 12);
        var yaw = (float) (value * (-Math.PI / 4) + value * Math.PI / 12);

        if (entity instanceof class_742 clientPlayer) {
            pitch = clientPlayer.field_3900 = clientPlayer.field_3900 + (pitch - clientPlayer.field_3900) * 0.1F;
            yaw = clientPlayer.field_3899 = clientPlayer.field_3899 + (yaw - clientPlayer.field_3899) * 0.1F;
        }

        matrices.method_22903();
        matrices.method_22904(0, 0, 2 / 16.0); // Pivot point

        matrices.method_22907(class_7833.field_40714.rotationDegrees(-90));
        matrices.method_22907(class_7833.field_40714.rotation(pitch));

        matrices.method_22904(0, 0, -1 / 16.0); // Scaling center

        var scale = 1f + 0.15f * phantom.method_7084();
        matrices.method_22905(scale, scale, scale);

        matrices.method_22904(1 / 32.0, -1 / 16.0, 8 / 16.0); // Model center

        setAngles(model, pitch, yaw);
        model.method_60879(matrices, vertexConsumers.getBuffer(model.method_23500(TEXTURE)), light, class_4608.field_21444);

        matrices.method_22909();
    }

    private static void setAngles(class_588<class_1593> model, float pitch, float yaw) {
        var accessor = (PhantomEntityModelAccessor) model;

        accessor.getLeftWingBase().field_3675 = yaw;
        accessor.getLeftWingTip().field_3675 = yaw;
        accessor.getRightWingBase().field_3675 = -yaw;
        accessor.getRightWingTip().field_3675 = -yaw;
    }
}
