/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.phantomfall;

import archives.tater.phantomfall.PhantomFallAttachments;
import archives.tater.phantomfall.PhantomFallConfig;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3610;
import net.minecraft.class_3730;
import net.minecraft.class_4081;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomFall
implements ModInitializer {
    public static final String MOD_ID = "phantomfall";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"phantomfall");
    public static final PhantomFallConfig CONFIG = (PhantomFallConfig)PhantomFallConfig.createToml((Path)FabricLoader.getInstance().getConfigDir(), (String)"phantomfall", (String)"phantomfall", PhantomFallConfig.class);
    public static final class_6862<class_8110> PHANTOM_PICKUP = class_6862.method_40092((class_5321)class_7924.field_42534, (class_2960)PhantomFall.id("phantom_pickup"));
    public static final class_2400 INSOMNIA_OMEN_PARTICLE = (class_2400)class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)PhantomFall.id("insomnia_omen"), (Object)FabricParticleTypes.simple());
    public static final class_3414 EVENT_MOB_EFFECT_INSOMNIA_OMEN = PhantomFall.registerSound(PhantomFall.id("event.mob_effect.insomnia_omen"));
    public static final class_6880<class_1291> INSOMNIA_OMEN = class_2378.method_47985((class_2378)class_7923.field_41174, (class_2960)PhantomFall.id("insomnia_omen"), (Object)new class_1291(class_4081.field_18273, 1348576511, (class_2394)INSOMNIA_OMEN_PARTICLE){}.method_58616(EVENT_MOB_EFFECT_INSOMNIA_OMEN));

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    private static class_3414 registerSound(class_2960 id) {
        return (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)id, (Object)class_3414.method_47908((class_2960)id));
    }

    public static boolean canWearPhantom(class_1657 player) {
        class_1792 chestEquipment = player.method_6118(class_1304.field_6174).method_7909();
        return !(chestEquipment instanceof class_1770) && !(chestEquipment instanceof FabricElytraItem);
    }

    public static List<Integer> distributeSizes(int value, class_5819 random) {
        int size;
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        for (int remaining = value; remaining > 0; remaining -= size) {
            size = Math.min(random.method_39332(1, PhantomFall.CONFIG.server.maxPhantomSize), remaining);
            sizes.add(size);
        }
        return sizes;
    }

    public static boolean hasInsomniaOrOmen(class_1309 entity) {
        return entity.method_6059(class_1294.field_16595) || entity.method_6059(INSOMNIA_OMEN);
    }

    public void onInitialize() {
        PhantomFallAttachments.register();
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> {
            if (blocked) {
                return;
            }
            if (entity.method_6128()) {
                return;
            }
            if (!source.method_48789(PHANTOM_PICKUP)) {
                return;
            }
            class_1297 attacker = source.method_5529();
            if (!(attacker instanceof class_1593)) {
                return;
            }
            if (entity.method_5854() instanceof class_1593) {
                return;
            }
            if (entity instanceof class_1657 && entity.hasAttached(PhantomFallAttachments.PHANTOM_DATA)) {
                return;
            }
            entity.method_5804(attacker);
        });
        ServerLivingEntityEvents.ALLOW_DEATH.register((entity, damageSource, damageAmount) -> {
            class_1297 patt0$temp;
            class_1593 phantom;
            block5: {
                block4: {
                    if (!(entity instanceof class_1593)) break block4;
                    phantom = (class_1593)entity;
                    patt0$temp = entity.method_31483();
                    if (patt0$temp instanceof class_1657) break block5;
                }
                return true;
            }
            class_1657 player = (class_1657)patt0$temp;
            player.method_29239();
            if (damageSource.method_5529() != player || !PhantomFall.canWearPhantom(player) || ((EntityElytraEvents.Custom)EntityElytraEvents.CUSTOM.invoker()).useCustomElytra(entity, false)) {
                return true;
            }
            phantom.method_6033(1.0f);
            PhantomFallAttachments.setPhantom((AttachmentTarget)player, phantom);
            phantom.method_31472();
            player.method_23669();
            return false;
        });
        EntityElytraEvents.CUSTOM.register((entity, tickElytra) -> {
            class_1657 player;
            return entity instanceof class_1657 && (player = (class_1657)entity).hasAttached(PhantomFallAttachments.PHANTOM_DATA);
        });
        EntitySleepEvents.START_SLEEPING.register((entity, sleepingPos) -> {
            class_1293 badOmenInstance = entity.method_6112(class_1294.field_16595);
            if (badOmenInstance == null) {
                return;
            }
            int amplifier = badOmenInstance.method_5578();
            entity.method_6016(class_1294.field_16595);
            entity.method_6092(new class_1293(INSOMNIA_OMEN, (amplifier + 1) * 20 * 60 * 20));
        });
        EntitySleepEvents.ALLOW_SETTING_SPAWN.register((player, sleepingPos) -> !PhantomFall.hasInsomniaOrOmen((class_1309)player));
        EntitySleepEvents.ALLOW_RESETTING_TIME.register(player -> !PhantomFall.hasInsomniaOrOmen((class_1309)player));
        EntitySleepEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> PhantomFall.hasInsomniaOrOmen((class_1309)player) && player.method_37908().method_8597().method_29960() ? class_1269.field_5812 : class_1269.field_5811);
        EntitySleepEvents.ALLOW_NEARBY_MONSTERS.register((player, sleepingPos, vanillaResult) -> PhantomFall.hasInsomniaOrOmen((class_1309)player) ? class_1269.field_5812 : class_1269.field_5811);
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            class_1937 world = entity.method_37908();
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = (class_3218)world;
            if (!(entity instanceof class_1657)) {
                return;
            }
            class_1657 player = (class_1657)entity;
            int cooldown = (Integer)player.getAttachedOrElse(PhantomFallAttachments.PHANTOM_COOLDOWN, (Object)0);
            if (cooldown > 0) {
                return;
            }
            world.method_8533();
            if (!world.method_23886() && !PhantomFall.hasInsomniaOrOmen((class_1309)player)) {
                player.removeAttached(PhantomFallAttachments.PHANTOMS_SPAWNED);
                return;
            }
            if (world.method_8597().comp_642() && !world.method_8311(entity.method_24515())) {
                return;
            }
            int spawnedPhantoms = (Integer)player.getAttachedOrElse(PhantomFallAttachments.PHANTOMS_SPAWNED, (Object)0);
            class_5819 random = world.method_8409();
            if (!PhantomFall.hasInsomniaOrOmen((class_1309)player) && random.method_43057() > PhantomFall.CONFIG.server.baseSpawnChance + PhantomFall.CONFIG.server.spawnChanceIncrease * (float)spawnedPhantoms) {
                return;
            }
            boolean success = false;
            for (Integer size : PhantomFall.distributeSizes(Math.min(spawnedPhantoms + 1, PhantomFall.CONFIG.server.maxSpawnScore), random)) {
                class_1593 phantom;
                class_2338 blockPos = entity.method_24515().method_10086(20 + random.method_43048(15)).method_10089(-10 + random.method_43048(21)).method_10077(-10 + random.method_43048(21));
                if (!class_1948.method_8662((class_1922)world, (class_2338)blockPos, (class_2680)world.method_8320(blockPos), (class_3610)world.method_8316(blockPos), (class_1299)class_1299.field_6078) || (phantom = (class_1593)class_1299.field_6078.method_5883(world)) == null) continue;
                phantom.method_5725(blockPos, 0.0f, 0.0f);
                phantom.method_5943((class_5425)serverWorld, world.method_8404(entity.method_24515()), class_3730.field_16459, null);
                phantom.method_7091(size.intValue());
                phantom.method_6033(phantom.method_6063());
                serverWorld.method_30771((class_1297)phantom);
                success = true;
            }
            if (success) {
                player.method_17356(class_3417.field_14813, player.method_5634(), 1.0f, 0.6f);
                PhantomFallAttachments.increaseAmount((AttachmentTarget)player);
                PhantomFallAttachments.setCooldown((AttachmentTarget)player);
            }
        });
    }
}

