/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.phantomfall;

import archives.tater.phantomfall.PhantomFall;
import com.mojang.serialization.Codec;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_9135;
import org.jetbrains.annotations.Nullable;

public class PhantomFallAttachments {
    public static final AttachmentType<class_2487> PHANTOM_DATA = AttachmentRegistry.create((class_2960)PhantomFall.id("phantom_data"), builder -> builder.persistent(class_2487.field_25128).syncWith(class_9135.field_48556, AttachmentSyncPredicate.all()));
    public static final AttachmentType<Integer> PHANTOMS_SPAWNED = AttachmentRegistry.create((class_2960)PhantomFall.id("phantoms_spawned"), builder -> builder.persistent(Codec.intRange((int)0, (int)Integer.MAX_VALUE)).copyOnDeath());
    public static final AttachmentType<Integer> PHANTOM_COOLDOWN = AttachmentRegistry.create((class_2960)PhantomFall.id("phantom_cooldown"), builder -> builder.persistent(Codec.intRange((int)0, (int)Integer.MAX_VALUE)).copyOnDeath());
    public static final AttachmentType<class_1593> CACHED_PHANTOM = AttachmentRegistry.create((class_2960)PhantomFall.id("cached_phantom"));

    public static void setPhantom(AttachmentTarget target, class_1593 phantom) {
        target.setAttached(PHANTOM_DATA, (Object)phantom.method_5647(new class_2487()));
    }

    @Nullable
    public static class_1593 getPhantom(AttachmentTarget target, class_1937 world) {
        class_2487 phantomData = (class_2487)target.getAttached(PHANTOM_DATA);
        if (phantomData == null) {
            return null;
        }
        if (target.hasAttached(CACHED_PHANTOM)) {
            return (class_1593)target.getAttached(CACHED_PHANTOM);
        }
        class_1593 phantom = (class_1593)class_1299.field_6078.method_5883(world);
        if (phantom == null) {
            return null;
        }
        phantom.method_5651(phantomData);
        target.setAttached(CACHED_PHANTOM, (Object)phantom);
        return phantom;
    }

    @Nullable
    public static class_1593 getPhantom(class_1297 entity) {
        return PhantomFallAttachments.getPhantom((AttachmentTarget)entity, entity.method_37908());
    }

    public static void increaseAmount(AttachmentTarget target) {
        target.setAttached(PHANTOMS_SPAWNED, (Object)((Integer)target.getAttachedOrElse(PHANTOMS_SPAWNED, (Object)0) + 1));
    }

    public static void setCooldown(AttachmentTarget target) {
        target.setAttached(PHANTOM_COOLDOWN, (Object)(20 * PhantomFall.CONFIG.server.spawnCooldown));
    }

    public static void tickAttachments(class_3222 player) {
        int cooldown = (Integer)player.getAttachedOrElse(PHANTOM_COOLDOWN, (Object)0);
        if (cooldown > 0) {
            player.setAttached(PHANTOM_COOLDOWN, (Object)(cooldown - 1));
        }
        class_2487 phantomData = (class_2487)player.getAttached(PHANTOM_DATA);
        if (player.method_37908().field_9236 || phantomData == null || player.method_5805() && player.method_6128() && PhantomFall.canWearPhantom((class_1657)player)) {
            return;
        }
        player.removeAttached(PHANTOM_DATA);
        class_1593 phantom = (class_1593)class_1299.field_6078.method_5883(player.method_37908());
        if (phantom == null) {
            return;
        }
        phantom.method_5651(phantomData);
        phantom.method_33574(player.method_19538());
        phantom.method_18799(class_243.field_1353);
        player.method_37908().method_8649((class_1297)phantom);
        phantom.method_5643(player.method_48923().method_48802((class_1657)player), Float.MAX_VALUE);
    }

    public static void register() {
    }
}

