/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.phantomfall;

import folk.sisby.kaleido.api.WrappedConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.DisplayNameConvention;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.FloatRange;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.IntegerRange;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.SerializedNameConvention;
import folk.sisby.kaleido.lib.quiltconfig.api.metadata.NamingSchemes;

@DisplayNameConvention(value=NamingSchemes.SPACE_SEPARATED_LOWER_CASE_INITIAL_UPPER_CASE)
@SerializedNameConvention(value=NamingSchemes.SNAKE_CASE)
public class PhantomFallConfig
extends WrappedConfig {
    public final Client client = new Client();
    public final Server server = new Server();

    public static class Client
    implements WrappedConfig.Section {
        @Comment(value={"Whether the player should be set to third person upon gaining phantom wings"})
        public boolean changePerspective = true;
    }

    public static class Server
    implements WrappedConfig.Section {
        @Comment(value={"Largest phantom size that can spawn naturally"})
        @IntegerRange(min=1L, max=16L)
        public int maxPhantomSize = 4;
        @Comment(value={"Chance of phantoms spawning when a player is on 0 previous spawns"})
        @FloatRange(min=0.0, max=1.0)
        public float baseSpawnChance = 0.5f;
        @Comment(value={"How much the spawn chance should increase per previous spawn"})
        @FloatRange(min=0.0, max=1.0)
        public float spawnChanceIncrease = 0.05f;
        @Comment(value={"The cap for the \"spawning score\" used to spawn a group of phantoms"})
        @IntegerRange(min=1L, max=64L)
        public int maxSpawnScore = 8;
        @Comment(value={"The cooldown for spawning phantoms in seconds"})
        @IntegerRange(min=0L, max=600L)
        public int spawnCooldown = 60;
    }
}

