/*
 * Decompiled with CFR 0.152.
 */
package archives.tater.phantomfall.render;

import archives.tater.phantomfall.PhantomFallAttachments;
import archives.tater.phantomfall.mixin.client.PhantomEntityModelAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1593;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_5602;
import net.minecraft.class_588;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7833;

@Environment(value=EnvType.CLIENT)
public class PhantomBodyFeatureRenderer
extends class_3887<class_1657, class_591<class_1657>> {
    private final class_588<class_1593> model;
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/entity/phantom.png");

    public PhantomBodyFeatureRenderer(class_3883<class_1657, class_591<class_1657>> context, class_5599 loader) {
        super(context);
        this.model = new class_588(loader.method_32072(class_5602.field_27620));
        this.model.method_41909("head").ifPresent(modelPart -> {
            modelPart.field_3665 = false;
        });
        this.model.method_41909("body").ifPresent(modelPart -> {
            modelPart.field_3654 = 0.0f;
        });
    }

    public void render(class_4587 matrices, class_4597 vertexConsumers, int light, class_1657 entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        class_1593 phantom = PhantomFallAttachments.getPhantom((class_1297)entity);
        if (phantom == null) {
            return;
        }
        double velocityNormY = entity.method_18798().method_1029().field_1351;
        double value = velocityNormY > 0.0 ? 0.0 : Math.pow(-velocityNormY, 1.5);
        float pitch = (float)(value * 0.17453292519943295 + value * Math.PI / 12.0);
        float yaw = (float)(value * -0.7853981633974483 + value * Math.PI / 12.0);
        if (entity instanceof class_742) {
            class_742 clientPlayer = (class_742)entity;
            clientPlayer.field_3900 += (pitch - clientPlayer.field_3900) * 0.1f;
            pitch = clientPlayer.field_3900;
            clientPlayer.field_3899 += (yaw - clientPlayer.field_3899) * 0.1f;
            yaw = clientPlayer.field_3899;
        }
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, 0.125);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
        matrices.method_22907(class_7833.field_40714.rotation(pitch));
        matrices.method_22904(0.0, 0.0, -0.0625);
        float scale = 1.0f + 0.15f * (float)phantom.method_7084();
        matrices.method_22905(scale, scale, scale);
        matrices.method_22904(0.03125, -0.0625, 0.5);
        PhantomBodyFeatureRenderer.setAngles(this.model, pitch, yaw);
        this.model.method_60879(matrices, vertexConsumers.getBuffer(this.model.method_23500(TEXTURE)), light, class_4608.field_21444);
        matrices.method_22909();
    }

    private static void setAngles(class_588<class_1593> model, float pitch, float yaw) {
        PhantomEntityModelAccessor accessor = (PhantomEntityModelAccessor)model;
        accessor.getLeftWingBase().field_3675 = yaw;
        accessor.getLeftWingTip().field_3675 = yaw;
        accessor.getRightWingBase().field_3675 = -yaw;
        accessor.getRightWingTip().field_3675 = -yaw;
    }
}

