package archives.tater.phantomfall;

import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentTarget;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1593;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_8942;
import net.minecraft.class_9135;
import com.mojang.serialization.Codec;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("UnstableApiUsage")
public class PhantomFallAttachments {
    public static final AttachmentType<class_2487> PHANTOM_DATA = AttachmentRegistry.create(PhantomFall.id("phantom_data"), builder -> builder
            .persistent(class_2487.field_25128)
            .syncWith(class_9135.field_48556, AttachmentSyncPredicate.all())
    );

    public static final AttachmentType<Integer> PHANTOMS_SPAWNED = AttachmentRegistry.create(PhantomFall.id("phantoms_spawned"), builder -> builder
            .persistent(Codec.intRange(0, Integer.MAX_VALUE))
            .copyOnDeath()
    );
    public static final AttachmentType<Integer> PHANTOM_COOLDOWN = AttachmentRegistry.create(PhantomFall.id("phantom_cooldown"), builder -> builder
            .persistent(Codec.intRange(0, Integer.MAX_VALUE))
            .copyOnDeath()
    );

    public static final AttachmentType<class_1593> CACHED_PHANTOM = AttachmentRegistry.create(PhantomFall.id("cached_phantom"));

    public static void setPhantom(AttachmentTarget target, class_1593 phantom) {
        try (var logging = new class_8942.class_11340(phantom.method_71370(), PhantomFall.LOGGER)) {
            var writeView = class_11362.method_71459(logging, phantom.method_56673());
            phantom.method_5647(writeView);
            target.setAttached(PHANTOM_DATA, writeView.method_71475());
        }
    }

    private static @Nullable class_1593 createPhantom(class_2487 data, class_1937 world) {
        var phantom = class_1299.field_6078.method_5883(world, class_3730.field_16459);
        if (phantom == null) return null;
        try (var logging = new class_8942.class_11340(phantom.method_71370(), PhantomFall.LOGGER)) {
            phantom.method_5651(class_11352.method_71417(logging, world.method_30349(), data));
        }
        return phantom;
    }

    public static @Nullable class_1593 getPhantom(AttachmentTarget target, class_1937 world) {
        var phantomData = target.getAttached(PHANTOM_DATA);
        if (phantomData == null) return null;
        if (target.hasAttached(CACHED_PHANTOM)) return target.getAttached(CACHED_PHANTOM);
        var phantom = createPhantom(phantomData, world);
        target.setAttached(CACHED_PHANTOM, phantom);
        return phantom;
    }

    public static @Nullable class_1593 getPhantom(class_1297 entity) {
        return getPhantom(entity, entity.method_73183());
    }

    public static void increaseAmount(AttachmentTarget target) {
        target.setAttached(PHANTOMS_SPAWNED, target.getAttachedOrElse(PHANTOMS_SPAWNED, 0) + 1);
    }

    public static void setCooldown(AttachmentTarget target) {
        target.setAttached(PHANTOM_COOLDOWN, 20 * PhantomFall.CONFIG.server.spawnCooldown);
    }

    public static void tickAttachments(class_3222 player) {
        int cooldown = player.getAttachedOrElse(PHANTOM_COOLDOWN, 0);
        if (cooldown > 0) {
            player.setAttached(PHANTOM_COOLDOWN, cooldown - 1);
        }

        var phantomData = player.getAttached(PHANTOM_DATA);
        if (!(player.method_51469() instanceof class_3218 serverWorld) || phantomData == null || (player.method_5805() && player.method_6128() && PhantomFall.canWearPhantom(player))) return;
        player.removeAttached(PHANTOM_DATA);
        var phantom = createPhantom(phantomData, serverWorld);
        if (phantom == null) return;
        phantom.method_33574(player.method_73189());
        phantom.method_18799(class_243.field_1353);
        serverWorld.method_8649(phantom);
        phantom.method_64397(serverWorld, player.method_48923().method_48802(player), Float.MAX_VALUE);
    }

    public static void register() {
    }
}
