package archives.tater.phantomfall.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1593;
import net.minecraft.class_1937;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static java.lang.Math.max;

@Mixin(class_1593.class)
public abstract class PhantomEntityMixin extends class_1308 {
	protected PhantomEntityMixin(class_1299<? extends class_1308> entityType, class_1937 world) {
		super(entityType, world);
	}

	@Shadow public abstract int getPhantomSize();

	@ModifyArg(
			method = "initialize",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/mob/PhantomEntity;setPhantomSize(I)V")
	)
	private int defaultSize(int size) {
		return size == 0 ? 1 : size;
	}

	@ModifyExpressionValue(
			method = "onSizeChanged",
			at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/mob/PhantomEntity;getPhantomSize()I")
	)
	private int reduceDamageIncrease(int original) {
		return max(original - 1, 0);
	}

	@SuppressWarnings("DataFlowIssue")
    @Inject(
			method = "onSizeChanged",
			at = @At("TAIL")
	)
	private void increaseHealth(CallbackInfo ci) {
		method_5996(class_5134.field_23716).method_6192(16 + 4 * getPhantomSize());
	}
}
