package archives.tater.phantomfall.render;

import archives.tater.phantomfall.PhantomFallAttachments;
import archives.tater.phantomfall.PhantomFallClient;
import archives.tater.phantomfall.render.state.PhantomBodyRenderState;
import net.minecraft.class_10055;
import net.minecraft.class_11659;
import net.minecraft.class_11890;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5599;
import net.minecraft.class_591;
import net.minecraft.class_6230;
import net.minecraft.class_7833;

public class PhantomBodyFeatureRenderer extends class_3887<class_10055, class_591> {
    private final PhantomBodyModel model;

    private static final class_2960 TEXTURE = class_2960.method_60656("textures/entity/phantom.png");

    public PhantomBodyFeatureRenderer(class_3883<class_10055, class_591> context, class_5599 loader) {
        super(context);
        model = new PhantomBodyModel(loader.method_32072(PhantomFallClient.PHANTOM_BODY_LAYER));
        model.method_63512().method_32086(class_6230.field_32608).field_3654 = 0;
    }

    @SuppressWarnings("UnstableApiUsage")
    public static void updateState(class_11890 player, class_10055 state) {
        var phantom = PhantomFallAttachments.getPhantom(player);

        if (phantom == null) return;

        var phantomState = new PhantomBodyRenderState();

        var velocityNormY = player.method_18798().method_1029().field_1351;
        var value = velocityNormY > 0 ? 0f : Math.pow(-velocityNormY, 1.5);

        var pitch = (float) (value * (Math.PI / 18) + value * Math.PI / 12);
        var yaw = (float) (value * (-Math.PI / 4) + value * Math.PI / 12);

        var lastState = player.getAttachedOrCreate(PhantomFallClient.PHANTOM_BODY_LAST, PhantomBodyRenderState::new);

        phantomState.pitch = lastState.pitch = lastState.pitch + (pitch - lastState.pitch) * 0.1f;
        phantomState.yaw = lastState.yaw = lastState.yaw + (yaw - lastState.yaw) * 0.1f;
        phantomState.size = phantom.method_7084();

        state.setData(PhantomFallClient.PHANTOM_BODY, phantomState);
    }

    @Override
    public void render(class_4587 matrices, class_11659 queue, int light, class_10055 state, float limbAngle, float limbDistance) {
        var phantomState = state.getData(PhantomFallClient.PHANTOM_BODY);
        if (phantomState == null) return;
        var pitch = phantomState.pitch;
        var yaw = phantomState.yaw;
        var size = phantomState.size;

        matrices.method_22903();
        matrices.method_22904(0, 0, 2 / 16.0); // Pivot point

        matrices.method_22907(class_7833.field_40714.rotationDegrees(-90));
        matrices.method_22907(class_7833.field_40714.rotation(pitch));

        matrices.method_22904(0, 0, -1 / 16.0); // Scaling center

        var scale = 1f + 0.15f * size;
        matrices.method_22905(scale, scale, scale);

        matrices.method_22904(1 / 32.0, -1 / 16.0, 8 / 16.0); // Model center

        queue.method_73489(model, phantomState, matrices, model.method_23500(TEXTURE), light, class_4608.field_21444, 0, null);

        matrices.method_22909();
    }

}
