/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_8030;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryScreenUtil;

@Mixin(value={class_332.class})
public abstract class GuiGraphicsMixin
implements FactoryGuiGraphics.Accessor {
    @Unique
    private int blitColor = -1;
    @Unique
    private Function<class_2960, class_1921> renderingOverride = class_1921::method_62277;
    @Mutable
    @Shadow
    @Final
    private class_4597.class_4598 field_44658;
    @Shadow
    @Final
    private class_332.class_8214 field_44659;
    @Shadow
    @Final
    private class_310 field_44656;
    @Unique
    private class_4597.class_4598 lastBufferSource;
    @Unique
    private final FactoryGuiGraphics factoryGuiGraphics = new FactoryGuiGraphics(){

        @Override
        public class_332 context() {
            return (class_332)GuiGraphicsMixin.this;
        }

        @Override
        public void disableDepthTest() {
            FactoryScreenUtil.disableDepthTest();
            GuiGraphicsMixin.this.renderingOverride = class_1921::method_62275;
        }

        @Override
        public void enableDepthTest() {
            FactoryScreenUtil.enableDepthTest();
            GuiGraphicsMixin.this.renderingOverride = class_1921::method_62277;
        }

        @Override
        public void blit(class_2960 texture, int x, int y, int uvX, int uvY, int width, int height) {
            this.context().method_25290(GuiGraphicsMixin.this.renderingOverride, texture, x, y, (float)uvX, (float)uvY, width, height, 256, 256);
        }

        @Override
        public void blit(class_2960 texture, int x, int y, int z, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.innerBlit(GuiGraphicsMixin.this.renderingOverride, texture, x, x + width, y, y + height, 0, (uvX + 0.0f) / (float)textureWidth, (uvX + (float)width) / (float)textureWidth, (uvY + 0.0f) / (float)textureHeight, (uvY + (float)height) / (float)textureHeight, GuiGraphicsMixin.this.blitColor);
        }

        @Override
        public void blit(class_2960 texture, int x, int xd, int y, int yd, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.innerBlit(GuiGraphicsMixin.this.renderingOverride, texture, x, xd, y, yd, 0, (uvX + 0.0f) / (float)textureWidth, (uvX + (float)width) / (float)textureWidth, (uvY + 0.0f) / (float)textureHeight, (uvY + (float)height) / (float)textureHeight, GuiGraphicsMixin.this.blitColor);
        }

        @Override
        public void blit(class_2960 texture, int x, int y, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.context().method_25290(GuiGraphicsMixin.this.renderingOverride, texture, x, y, uvX, uvY, width, height, textureWidth, textureHeight);
        }

        @Override
        public void blitSprite(class_2960 resourceLocation, int x, int y, int width, int height) {
            this.context().method_52707(GuiGraphicsMixin.this.renderingOverride, resourceLocation, x, y, width, height, GuiGraphicsMixin.this.blitColor);
        }

        @Override
        public void blitSprite(class_2960 resourceLocation, int x, int y, int z, int width, int height) {
            if (z != 0) {
                FactoryGuiMatrixStack.of(this.context().method_51448()).pushPose();
                FactoryGuiMatrixStack.of(this.context().method_51448()).translate(0.0, z, 0.0);
            }
            this.context().method_52707(GuiGraphicsMixin.this.renderingOverride, resourceLocation, x, y, width, height, GuiGraphicsMixin.this.blitColor);
            if (z != 0) {
                FactoryGuiMatrixStack.of(this.context().method_51448()).popPose();
            }
        }

        @Override
        public void blitSprite(class_2960 resourceLocation, int textureWidth, int textureHeight, int uvX, int uvY, int x, int y, int z, int width, int height) {
            if (z != 0) {
                FactoryGuiMatrixStack.of(this.context().method_51448()).pushPose();
                FactoryGuiMatrixStack.of(this.context().method_51448()).translate(0.0, z, 0.0);
            }
            this.context().method_52708(GuiGraphicsMixin.this.renderingOverride, resourceLocation, textureWidth, textureHeight, uvX, uvY, x, y, width, height);
            if (z != 0) {
                FactoryGuiMatrixStack.of(this.context().method_51448()).popPose();
            }
        }

        @Override
        public void blit(int x, int y, int z, int width, int height, class_1058 textureAtlasSprite) {
            if (z != 0) {
                FactoryGuiMatrixStack.of(this.context().method_51448()).pushPose();
                FactoryGuiMatrixStack.of(this.context().method_51448()).translate(0.0, z, 0.0);
            }
            this.context().method_52709(GuiGraphicsMixin.this.renderingOverride, textureAtlasSprite, x, y, width, height);
            if (z != 0) {
                FactoryGuiMatrixStack.of(this.context().method_51448()).popPose();
            }
        }

        @Override
        public void enableScissor(int x, int y, int xd, int yd, boolean matrixAffects) {
            if (matrixAffects) {
                Matrix4f matrix4f = ((class_4587)FactoryGuiMatrixStack.of(this.context().method_51448()).getNative()).method_23760().method_23761();
                Vector3f vector3f = matrix4f.transformPosition((float)x, (float)y, 0.0f, new Vector3f());
                Vector3f vector3f2 = matrix4f.transformPosition((float)xd, (float)yd, 0.0f, new Vector3f());
                GuiGraphicsMixin.this.method_49698(GuiGraphicsMixin.this.field_44659.method_49700(new class_8030(class_3532.method_15375((float)vector3f.x), class_3532.method_15375((float)vector3f.y), class_3532.method_15375((float)(vector3f2.x - vector3f.x)), class_3532.method_15375((float)(vector3f2.y - vector3f.y)))));
            } else {
                this.context().method_44379(x, y, xd, yd);
            }
        }

        @Override
        public void setColor(int color, boolean changeBlend) {
            this.setColor(ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), ColorUtil.getAlpha(color), changeBlend);
        }

        @Override
        public void setColor(float r, float g, float b, float a, boolean changeBlend) {
            if (changeBlend) {
                if (a < 1.0f) {
                    FactoryScreenUtil.enableBlend();
                } else {
                    FactoryScreenUtil.disableBlend();
                }
            }
            this.context().method_51452();
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }

        @Override
        public float[] getColor() {
            return RenderSystem.getShaderColor();
        }

        @Override
        public void setBlitColor(float r, float g, float b, float a) {
            GuiGraphicsMixin.this.blitColor = ColorUtil.colorFromFloat(r, g, b, a);
        }

        @Override
        public void setBlitColor(int color) {
            GuiGraphicsMixin.this.blitColor = color;
        }

        @Override
        public int getBlitColor() {
            return GuiGraphicsMixin.this.blitColor;
        }

        private void innerBlit(Function<class_2960, class_1921> function, class_2960 resourceLocation, int i, int j, int k, int l, int z, float f, float g, float h, float m, int n) {
            class_1921 renderType = function.apply(resourceLocation);
            Matrix4f matrix4f = ((class_4587)FactoryGuiMatrixStack.of(this.context().method_51448()).getNative()).method_23760().method_23761();
            class_4588 vertexConsumer = this.getBufferSource().getBuffer(renderType);
            vertexConsumer.method_22918(matrix4f, (float)i, (float)k, (float)z).method_22913(f, h).method_39415(n);
            vertexConsumer.method_22918(matrix4f, (float)i, (float)l, (float)z).method_22913(f, m).method_39415(n);
            vertexConsumer.method_22918(matrix4f, (float)j, (float)l, (float)z).method_22913(g, m).method_39415(n);
            vertexConsumer.method_22918(matrix4f, (float)j, (float)k, (float)z).method_22913(g, h).method_39415(n);
            this.getBufferSource().method_22994(renderType);
        }

        @Override
        public class_4597.class_4598 getBufferSource() {
            return GuiGraphicsMixin.this.field_44658;
        }

        @Override
        public void pushBufferSource(class_4597.class_4598 newBufferSource) {
            GuiGraphicsMixin.this.lastBufferSource = GuiGraphicsMixin.this.field_44658;
            GuiGraphicsMixin.this.field_44658 = newBufferSource;
        }

        @Override
        public void popBufferSource() {
            if (GuiGraphicsMixin.this.lastBufferSource != null) {
                GuiGraphicsMixin.this.field_44658 = GuiGraphicsMixin.this.lastBufferSource;
            }
        }
    };

    @Shadow
    protected abstract void method_49698(class_8030 var1);

    @Override
    public FactoryGuiGraphics getFactoryGuiGraphics() {
        return this.factoryGuiGraphics;
    }

    @ModifyArg(method={"blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIIIIIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;IIIIIIIII)V"), index=10)
    public int blitBlitCustom(int par3) {
        return this.blitColor;
    }

    @ModifyArg(method={"blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIIII)V"), index=6)
    public int blitSprite(int par3) {
        return this.blitColor;
    }

    @ModifyArg(method={"blitSprite(Ljava/util/function/Function;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;IIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Ljava/util/function/Function;Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;IIIII)V"), index=6)
    public int blitSpriteAtlas(int par3) {
        return this.blitColor;
    }

    @ModifyArg(method={"blit(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIFFIIIIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Ljava/util/function/Function;Lnet/minecraft/resources/ResourceLocation;IIFFIIIIIII)V"), index=12)
    public int blit(int par3) {
        return this.blitColor;
    }
}

