/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkProtocol;
import net.minecraftforge.network.PacketDistributor;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.network.SecureExecutor;

public interface CommonNetwork {
    public static final Multimap<UUID, String> ENABLED_PLAYERS = HashMultimap.create();

    public static <T extends Payload> void sendToPlayer(ServerPlayer serverPlayer, T packetHandler) {
        CommonNetwork.sendToPlayer(serverPlayer, packetHandler, false);
    }

    public static <T extends Payload> void sendToPlayer(ServerPlayer serverPlayer, T payload, boolean bypassCheck) {
        if (!bypassCheck && !ENABLED_PLAYERS.get((Object)serverPlayer.getUUID()).contains(payload.identifier().location().getNamespace())) {
            return;
        }
        PacketDistributor.PLAYER.with((Object)serverPlayer).send(NetworkProtocol.PLAY.buildPacket(PacketFlow.CLIENTBOUND, payload.type().id(), payload::encode));
    }

    public static <T extends Payload> void sendToPlayers(Collection<ServerPlayer> serverPlayers, T payload, boolean bypassCheck) {
        serverPlayers.forEach(s -> CommonNetwork.sendToPlayer(s, payload, bypassCheck));
    }

    public static <T extends Payload> void sendToPlayers(Collection<ServerPlayer> serverPlayers, T payload) {
        CommonNetwork.sendToPlayers(serverPlayers, payload, false);
    }

    public static <T extends Payload> void sendToServer(T payload) {
        CommonNetwork.sendToServer(payload, false);
    }

    public static <T extends Payload> void sendToServer(T payload, boolean bypassCheck) {
        if (!FactoryAPI.isClient() || !bypassCheck && !FactoryAPIClient.hasModOnServer(payload.identifier().location().getNamespace())) {
            return;
        }
        PacketDistributor.SERVER.noArg().send(NetworkProtocol.PLAY.buildPacket(PacketFlow.SERVERBOUND, payload.type().id(), payload::encode));
    }

    public static void encodeComponent(PlayBuf buf, Component component) {
        ComponentSerialization.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf.get()), (Object)component);
    }

    public static Component decodeComponent(PlayBuf buf) {
        return (Component)ComponentSerialization.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf.get()));
    }

    public static void encodeItemStack(PlayBuf buf, ItemStack stack) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf.get()), (Object)stack);
    }

    public static ItemStack decodeItemStack(PlayBuf buf) {
        return (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf.get()));
    }

    public static void encodeBuf(PlayBuf buf, PlayBuf toEncode) {
        ((RegistryFriendlyByteBuf)buf.get()).writeVarInt(((RegistryFriendlyByteBuf)toEncode.get()).readableBytes());
        ((RegistryFriendlyByteBuf)buf.get()).writeBytes((ByteBuf)toEncode.get());
    }

    public static PlayBuf decodeBuf(PlayBuf buf) {
        int readable = ((RegistryFriendlyByteBuf)buf.get()).readVarInt();
        if (readable > 0) {
            return PlayBuf.fromBuf(new FriendlyByteBuf(((RegistryFriendlyByteBuf)buf.get()).readBytes(readable)));
        }
        return PlayBuf.create();
    }

    public static interface Payload
    extends CustomPacketPayload {
        public void apply(Context var1);

        default public void applyClient() {
            this.apply(Context.createClientContext());
        }

        default public void applyServer(Supplier<Player> player) {
            this.apply(Context.createServerContext(player));
        }

        default public void applySided(boolean client, Supplier<Player> player) {
            if (client) {
                this.applyClient();
            } else {
                this.applyServer(player);
            }
        }

        public Identifier<? extends Payload> identifier();

        default public void encode(RegistryFriendlyByteBuf buf) {
            this.encode(() -> buf);
        }

        public void encode(PlayBuf var1);

        default public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return this.identifier().type();
        }

        public static interface Context {
            public SecureExecutor executor();

            public Player player();

            default public MinecraftServer server() {
                return FactoryAPIPlatform.getEntityServer((Entity)this.player());
            }

            public boolean isClient();

            public static Context createClientContext() {
                return Context.createContext(FactoryAPIClient.SECURE_EXECUTOR, FactoryAPIClient::getClientPlayer, true);
            }

            public static Context createServerContext(Supplier<Player> player) {
                return Context.createContext(FactoryAPI.SECURE_EXECUTOR, player, true);
            }

            public static Context createContext(final SecureExecutor executor, final Supplier<Player> playerSupplier, final boolean isClient) {
                return new Context(){

                    @Override
                    public SecureExecutor executor() {
                        return executor;
                    }

                    @Override
                    public Player player() {
                        return (Player)playerSupplier.get();
                    }

                    @Override
                    public boolean isClient() {
                        return isClient;
                    }
                };
            }
        }
    }

    public static interface Identifier<T extends Payload> {
        public ResourceLocation location();

        public T decode(RegistryFriendlyByteBuf var1);

        public CustomPacketPayload.Type<T> type();

        public StreamCodec<RegistryFriendlyByteBuf, T> codec();

        public static <T extends Payload> Identifier<T> create(ResourceLocation location, Supplier<T> decoder) {
            return Identifier.create(location, (PlayBuf b) -> (Payload)decoder.get());
        }

        public static <T extends Payload> Identifier<T> create(final ResourceLocation location, final Function<PlayBuf, T> decoder) {
            final CustomPacketPayload.Type type = new CustomPacketPayload.Type(location);
            final StreamCodec codec = StreamCodec.of((b, p) -> p.encode((RegistryFriendlyByteBuf)b), b -> (Payload)decoder.apply(() -> b));
            return new Identifier<T>(){

                @Override
                public ResourceLocation location() {
                    return location;
                }

                @Override
                public T decode(RegistryFriendlyByteBuf buf) {
                    return (Payload)decoder.apply(() -> buf);
                }

                @Override
                public CustomPacketPayload.Type<T> type() {
                    return type;
                }

                @Override
                public StreamCodec<RegistryFriendlyByteBuf, T> codec() {
                    return codec;
                }
            };
        }
    }

    public static interface PlayBuf
    extends Supplier<RegistryFriendlyByteBuf> {
        public static PlayBuf create() {
            return PlayBuf.fromBuf(new FriendlyByteBuf(Unpooled.buffer()));
        }

        public static PlayBuf of(RegistryFriendlyByteBuf buf) {
            return () -> buf;
        }

        public static PlayBuf fromBuf(FriendlyByteBuf buf) {
            return PlayBuf.of(new RegistryFriendlyByteBuf((ByteBuf)buf, FactoryAPIPlatform.getRegistryAccess()));
        }
    }

    public static abstract class EmptyPayload
    implements Payload {
        private final Identifier<? extends Payload> identifier;

        public EmptyPayload(Identifier<? extends Payload> identifier) {
            this.identifier = identifier;
        }

        @Override
        public void encode(PlayBuf buf) {
        }

        @Override
        public Identifier<? extends Payload> identifier() {
            return this.identifier;
        }
    }
}

