/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryScreenUtil;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin
implements FactoryGuiGraphics.Accessor {
    @Mutable
    @Shadow
    @Final
    private MultiBufferSource.BufferSource bufferSource;
    @Shadow
    @Final
    private GuiGraphics.ScissorStack scissorStack;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private MultiBufferSource.BufferSource lastBufferSource;
    @Unique
    private final FactoryGuiGraphics factoryGuiGraphics = new FactoryGuiGraphics(){
        final FactoryGuiMatrixStack pose = FactoryGuiMatrixStack.of(this.context().pose());

        @Override
        public GuiGraphics context() {
            return (GuiGraphics)GuiGraphicsMixin.this;
        }

        @Override
        public void disableDepthTest() {
            FactoryScreenUtil.disableDepthTest();
        }

        @Override
        public void enableDepthTest() {
            FactoryScreenUtil.enableDepthTest();
        }

        @Override
        public void blit(ResourceLocation texture, int x, int y, int uvX, int uvY, int width, int height) {
            this.context().blit(texture, x, y, uvX, uvY, width, height);
        }

        @Override
        public void blit(ResourceLocation texture, int x, int y, int z, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.context().blit(texture, x, y, z, uvX, uvY, width, height, textureWidth, textureHeight);
        }

        @Override
        public void blit(ResourceLocation texture, int x, int xd, int y, int yd, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.context().blit(texture, x, xd, y, yd, uvX, uvY, width, height, textureWidth, textureHeight);
        }

        @Override
        public void blit(ResourceLocation texture, int x, int y, float uvX, float uvY, int width, int height, int textureWidth, int textureHeight) {
            this.context().blit(texture, x, y, uvX, uvY, width, height, textureWidth, textureHeight);
        }

        @Override
        public void blitSprite(ResourceLocation resourceLocation, int x, int y, int width, int height) {
            this.context().blitSprite(resourceLocation, x, y, width, height);
        }

        @Override
        public void blitSprite(ResourceLocation resourceLocation, int x, int y, int z, int width, int height) {
            this.context().blitSprite(resourceLocation, x, y, z, width, height);
        }

        @Override
        public void blitSprite(ResourceLocation resourceLocation, int textureWidth, int textureHeight, int uvX, int uvY, int x, int y, int z, int width, int height) {
            this.context().blitSprite(resourceLocation, textureWidth, textureHeight, uvX, uvY, x, y, z, width, height);
        }

        @Override
        public void blit(int x, int y, int z, int width, int height, TextureAtlasSprite textureAtlasSprite) {
            this.context().blit(x, y, z, width, height, textureAtlasSprite);
        }

        @Override
        public void enableScissor(int x, int y, int xd, int yd, boolean matrixAffects) {
            if (matrixAffects) {
                Matrix4f matrix4f = ((PoseStack)FactoryGuiMatrixStack.of(this.context().pose()).getNative()).last().pose();
                Vector3f vector3f = matrix4f.transformPosition((float)x, (float)y, 0.0f, new Vector3f());
                Vector3f vector3f2 = matrix4f.transformPosition((float)xd, (float)yd, 0.0f, new Vector3f());
                GuiGraphicsMixin.this.applyScissor(GuiGraphicsMixin.this.scissorStack.push(new ScreenRectangle(Mth.floor((float)vector3f.x), Mth.floor((float)vector3f.y), Mth.floor((float)(vector3f2.x - vector3f.x)), Mth.floor((float)(vector3f2.y - vector3f.y)))));
            } else {
                this.context().enableScissor(x, y, xd, yd);
            }
        }

        @Override
        public void setColor(int color, boolean changeBlend) {
            this.setColor(ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), ColorUtil.getAlpha(color), changeBlend);
        }

        @Override
        public void setColor(float r, float g, float b, float a, boolean changeBlend) {
            if (changeBlend) {
                if (a < 1.0f) {
                    FactoryScreenUtil.enableBlend();
                } else {
                    FactoryScreenUtil.disableBlend();
                }
            }
            this.context().setColor(r, g, b, a);
        }

        @Override
        public float[] getColor() {
            return RenderSystem.getShaderColor();
        }

        @Override
        public MultiBufferSource.BufferSource getBufferSource() {
            return GuiGraphicsMixin.this.bufferSource;
        }

        @Override
        public void pushBufferSource(MultiBufferSource.BufferSource newBufferSource) {
            GuiGraphicsMixin.this.lastBufferSource = GuiGraphicsMixin.this.bufferSource;
            GuiGraphicsMixin.this.bufferSource = newBufferSource;
        }

        @Override
        public void popBufferSource() {
            if (GuiGraphicsMixin.this.lastBufferSource != null) {
                GuiGraphicsMixin.this.bufferSource = GuiGraphicsMixin.this.lastBufferSource;
            }
        }

        @Override
        public FactoryGuiMatrixStack pose() {
            return this.pose;
        }
    };

    @Shadow
    protected abstract void applyScissor(ScreenRectangle var1);

    @Override
    public FactoryGuiGraphics getFactoryGuiGraphics() {
        return this.factoryGuiGraphics;
    }

    @Inject(method={"blitTiledSprite"}, at={@At(value="HEAD")}, cancellable=true)
    public void blitTiledSprite(TextureAtlasSprite textureAtlasSprite, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s, CallbackInfo ci) {
        this.getFactoryGuiGraphics().blitTiledSprite(textureAtlasSprite, i, j, k, l, m, n, o, p, q, r, s);
        ci.cancel();
    }
}

