/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.forge;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.TransportState;

public interface ForgeItemStoragePlatform
extends IPlatformItemHandler,
IPlatformHandlerApi<IItemHandler> {
    default public int getContainerSize() {
        return ((IItemHandler)this.getHandler()).getSlots();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < ((IItemHandler)this.getHandler()).getSlots(); ++i) {
            if (((IItemHandler)this.getHandler()).getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ArbitrarySupplier<IItemHandlerModifiable> getModifiableHandler() {
        return () -> {
            IItemHandlerModifiable h;
            Object patt0$temp = this.getHandler();
            return patt0$temp instanceof IItemHandlerModifiable ? (h = (IItemHandlerModifiable)patt0$temp) : null;
        };
    }

    @Override
    @NotNull
    default public ItemStack getItem(int slot) {
        return ((IItemHandler)this.getHandler()).getStackInSlot(slot);
    }

    default public void setItem(int i, ItemStack arg) {
        this.getModifiableHandler().ifPresent(m -> m.setStackInSlot(i, arg));
    }

    @Override
    default public void setChanged() {
    }

    @Override
    @NotNull
    default public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return ((IItemHandler)this.getHandler()).insertItem(slot, stack, simulate);
    }

    @Override
    @NotNull
    default public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ((IItemHandler)this.getHandler()).extractItem(slot, amount, simulate);
    }

    default public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        return ((IItemHandler)this.getHandler()).isItemValid(slot, stack);
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }

    default public void clearContent() {
        this.getModifiableHandler().ifPresent(m -> {
            for (int i = 0; i < ((IItemHandler)this.getHandler()).getSlots(); ++i) {
                m.setStackInSlot(i, ItemStack.EMPTY);
            }
        });
    }

    @Override
    default public CompoundTag serializeTag() {
        return new CompoundTag();
    }

    @Override
    default public void deserializeTag(CompoundTag tag) {
    }
}

