/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.network;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.mixin.base.RecipeManagerAccessor;

public class CommonRecipeManager {
    public static <R extends Recipe<?>> RecipeHolder<R> byId(ResourceLocation id, RecipeType<R> type) {
        return CommonRecipeManager.getRecipeManager().byKey(id).orElse(null);
    }

    public static <R extends Recipe<?>> Collection<RecipeHolder<R>> byType(RecipeType<R> type) {
        return ((RecipeManagerAccessor)CommonRecipeManager.getRecipeManager()).getRecipeByType(type);
    }

    public static <R extends Recipe<I>, I extends RecipeInput> Optional<RecipeHolder<R>> getRecipeFor(RecipeType<R> type, I input, Level level) {
        Collection<RecipeHolder<R>> recipes = CommonRecipeManager.byType(type);
        for (RecipeHolder<R> recipe : recipes) {
            if (!recipe.value().matches(input, level)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public static <R extends Recipe<I>, I extends RecipeInput> Optional<ItemStack> getResultFor(RecipeType<R> type, I input, Level level) {
        return CommonRecipeManager.getRecipeFor(type, input, level).map(r -> r.value().assemble(input, (HolderLookup.Provider)level.registryAccess()));
    }

    public static RecipeManager getRecipeManager() {
        return FactoryAPI.currentServer == null ? FactoryAPIClient.getRecipeManager() : FactoryAPI.currentServer.getRecipeManager();
    }
}

