/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import com.mojang.authlib.GameProfile;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import wily.factoryapi.base.FactoryExtraMenuSupplier;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player
implements FactoryExtraMenuSupplier.PrepareMenu {
    @Shadow
    private int containerCounter;

    public ServerPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Shadow
    protected abstract void nextContainerCounter();

    @Shadow
    public abstract void closeContainer();

    @Shadow
    protected abstract void initMenu(AbstractContainerMenu var1);

    @Override
    public Optional<AbstractContainerMenu> prepareMenu(MenuProvider provider, Consumer<AbstractContainerMenu> openClientMenu) {
        if (provider == null) {
            return Optional.empty();
        }
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        this.nextContainerCounter();
        AbstractContainerMenu abstractContainerMenu = provider.createMenu(this.containerCounter, this.getInventory(), (Player)this);
        if (abstractContainerMenu == null) {
            if (this.isSpectator()) {
                this.displayClientMessage((Component)Component.translatable((String)"container.spectatorCantOpen").withStyle(ChatFormatting.RED), true);
            }
            return Optional.empty();
        }
        openClientMenu.accept(abstractContainerMenu);
        this.initMenu(abstractContainerMenu);
        this.containerMenu = abstractContainerMenu;
        return Optional.of(this.containerMenu);
    }
}

