/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import wily.factoryapi.base.IFactoryExpandedStorage;
import wily.factoryapi.util.FactoryItemUtil;

public interface IFactoryContainerMenu<T extends BlockEntity> {
    public T getBlockEntity();

    default public BlockPos getBlockPos() {
        return this.getBlockEntity().getBlockPos();
    }

    default public BlockState getBlockState() {
        return this.getBlockEntity().getBlockState();
    }

    public Player getPlayer();

    public NonNullList<Slot> getSlots();

    default public void updateChanges() {
    }

    default public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        int machineSlots = ((IFactoryExpandedStorage)this.getBlockEntity()).getSlots(player).size();
        int inventorySlots = machineSlots + 27;
        int totalSlots = machineSlots + 36;
        Slot slot = (Slot)this.getSlots().get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            itemstack = stack.copy();
            if (index < machineSlots) {
                if (!this.moveItemStackToSlot(stack, machineSlots, totalSlots, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, itemstack);
            } else if (!this.moveItemStackToSlot(stack, 0, machineSlots, false)) {
                if (index < inventorySlots ? !this.moveItemStackToSlot(stack, inventorySlots, totalSlots, true) : index < totalSlots && !this.moveItemStackToSlot(stack, machineSlots, inventorySlots, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return itemstack;
    }

    default public boolean moveItemStackToSlot(ItemStack itemStack, int i, int j, boolean inclusive) {
        ItemStack itemStack2;
        Slot slot;
        boolean bl2 = false;
        int k = i;
        if (inclusive) {
            k = j - 1;
        }
        if (itemStack.isStackable()) {
            while (!itemStack.isEmpty() && !(!inclusive ? k >= j : k < i)) {
                slot = (Slot)this.getSlots().get(k);
                itemStack2 = slot.getItem();
                if (!itemStack2.isEmpty() && FactoryItemUtil.equalItems(itemStack, itemStack2) && slot.mayPlace(itemStack)) {
                    int l = itemStack2.getCount() + itemStack.getCount();
                    if (l <= slot.getMaxStackSize(itemStack)) {
                        itemStack.setCount(0);
                        itemStack2.setCount(l);
                        slot.setChanged();
                        bl2 = true;
                    } else if (itemStack2.getCount() < slot.getMaxStackSize(itemStack)) {
                        itemStack.shrink(itemStack.getMaxStackSize() - itemStack2.getCount());
                        itemStack2.setCount(itemStack.getMaxStackSize());
                        slot.setChanged();
                        bl2 = true;
                    }
                }
                if (inclusive) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        if (!itemStack.isEmpty()) {
            k = inclusive ? j - 1 : i;
            while (!(!inclusive ? k >= j : k < i)) {
                slot = (Slot)this.getSlots().get(k);
                itemStack2 = slot.getItem();
                if (itemStack2.isEmpty() && slot.mayPlace(itemStack)) {
                    if (itemStack.getCount() > slot.getMaxStackSize()) {
                        slot.set(itemStack.split(slot.getMaxStackSize()));
                    } else {
                        slot.set(itemStack.split(itemStack.getCount()));
                    }
                    slot.setChanged();
                    bl2 = true;
                    break;
                }
                if (inclusive) {
                    --k;
                    continue;
                }
                ++k;
            }
        }
        return bl2;
    }
}

