/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3324;
import net.minecraft.class_3695;
import net.minecraft.class_5352;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.util.TriConsumer;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.network.CommonNetwork;

public class FactoryEvent<T> {
    protected final List<T> listeners = new ArrayList<T>();
    public final T invoker;

    public FactoryEvent(Function<FactoryEvent<T>, T> invoker) {
        this.invoker = invoker.apply(this);
    }

    public void invokeAll(Consumer<T> invoker) {
        this.listeners.forEach(invoker);
    }

    public void invokeAnyMatch(Predicate<T> invoker) {
        for (T listener : this.listeners) {
            if (!invoker.test(listener)) continue;
            return;
        }
    }

    public void register(T listener) {
        this.listeners.add(listener);
    }

    public static void setup(Runnable run) {
        run.run();
    }

    public static void tagsLoaded(Runnable run) {
        CommonLifecycleEvents.TAGS_LOADED.register((s, t) -> run.run());
    }

    public static void serverStarted(Consumer<MinecraftServer> apply) {
        ServerLifecycleEvents.SERVER_STARTED.register(apply::accept);
    }

    public static void serverStopping(Consumer<MinecraftServer> apply) {
        ServerLifecycleEvents.SERVER_STOPPING.register(apply::accept);
    }

    public static void serverStopped(Consumer<MinecraftServer> apply) {
        ServerLifecycleEvents.SERVER_STOPPED.register(apply::accept);
    }

    public static void preServerTick(Consumer<MinecraftServer> apply) {
        ServerTickEvents.START_SERVER_TICK.register(apply::accept);
    }

    public static void afterServerTick(Consumer<MinecraftServer> apply) {
        ServerTickEvents.END_SERVER_TICK.register(apply::accept);
    }

    public static void registerReloadListener(class_3264 type, final class_3302 reloadListener) {
        final class_2960 location = FactoryAPI.createLocation(reloadListener.method_22322());
        ResourceManagerHelper.get((class_3264)type).registerReloadListener(new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return location;
            }

            public String method_22322() {
                return reloadListener.method_22322();
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
                return reloadListener.method_25931(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
            }
        });
    }

    public static void registerCommands(TriConsumer<CommandDispatcher<class_2168>, class_7157, class_2170.class_5364> register) {
        CommandRegistrationCallback.EVENT.register((arg_0, arg_1, arg_2) -> register.accept(arg_0, arg_1, arg_2));
    }

    public static class_3288 createBuiltInPack(class_2960 name, class_2561 displayName, boolean defaultEnabled, class_3264 type, class_3288.class_3289 position, Path resourcePath) {
        return class_3288.method_45275((String)name.toString(), (class_2561)displayName, (boolean)false, (class_3288.class_7680)new class_3259.class_8619(resourcePath, true), (class_3264)type, (class_3288.class_3289)position, (class_5352)class_5352.method_45281(arg_0 -> ((class_5352)class_5352.field_25348).method_45282(arg_0), (boolean)defaultEnabled));
    }

    public static void registerBuiltInPacks(Consumer<PackRegistry> registry) {
        registry.accept((path, name, component, position, enabledByDefault) -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)name, (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer(name.method_12836()).orElseThrow()), (class_2561)component, (ResourcePackActivationType)(enabledByDefault ? ResourcePackActivationType.DEFAULT_ENABLED : ResourcePackActivationType.NORMAL)));
    }

    public static void registerPayload(Consumer<PayloadRegistry> registry) {
        registry.accept(new PayloadRegistry(){

            @Override
            public <T extends CommonNetwork.Payload> void register(boolean c2s, CommonNetwork.Identifier<T> id) {
                if (c2s) {
                    ServerPlayNetworking.registerGlobalReceiver((class_2960)id.location(), (m, l, h, b, s) -> id.decode(b).applyServer(() -> h.field_14140));
                } else if (FactoryAPI.isClient()) {
                    FactoryAPIClient.registerPayload(id);
                }
            }
        });
    }

    @FunctionalInterface
    public static interface PackRegistry {
        public void register(String var1, class_2960 var2, class_2561 var3, class_3288.class_3289 var4, boolean var5);

        default public void register(String path, class_2960 name, boolean enabledByDefault) {
            this.register(path, name, (class_2561)class_2561.method_43471((String)(name.method_12836() + ".builtin." + name.method_12832())), class_3288.class_3289.field_14280, enabledByDefault);
        }

        default public void registerResourcePack(class_2960 location, boolean enabledByDefault) {
            this.register("resourcepacks/" + location.method_12832(), location, enabledByDefault);
        }

        default public void registerResourcePack(String pathName, boolean enabledByDefault) {
            this.registerResourcePack(FactoryAPI.createVanillaLocation(pathName), enabledByDefault);
        }
    }

    public static interface PayloadRegistry {
        public <T extends CommonNetwork.Payload> void register(boolean var1, CommonNetwork.Identifier<T> var2);
    }

    public static interface PlayerEvent
    extends Consumer<class_3222> {
        public static final FactoryEvent<Consumer<class_3324>> RELOAD_RESOURCES_EVENT = new FactoryEvent<Consumer>(e -> s -> e.invokeAll(t -> t.accept(s)));
        public static final FactoryEvent<PlayerEvent> JOIN_EVENT = new FactoryEvent<PlayerEvent>(e -> s -> e.invokeAll(t -> t.accept(s)));
        public static final FactoryEvent<PlayerEvent> REMOVED_EVENT = new FactoryEvent<PlayerEvent>(e -> s -> e.invokeAll(t -> t.accept(s)));
    }

    public static interface ServerSave {
        public static final FactoryEvent<ServerSave> EVENT = new FactoryEvent<ServerSave>(e -> (server, log, flush, force) -> e.invokeAll(t -> t.run(server, log, flush, force)));

        public void run(MinecraftServer var1, boolean var2, boolean var3, boolean var4);
    }
}

