/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import wily.factoryapi.util.FluidInstance;

public interface ItemContainerPlatform {
    public static boolean isBlockItem(ItemStack s) {
        return s.getItem() instanceof BlockItem;
    }

    public static Fluid getBucketFluid(BucketItem item) {
        return item.content;
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return !stack.isEmpty() && ItemContainerPlatform.getItemFluidHandler(stack) != null;
    }

    public static boolean isEnergyContainer(ItemStack stack) {
        return !stack.isEmpty() && ItemContainerPlatform.getItemEnergyStorage(stack) != null;
    }

    public static FluidInstance getFluid(ItemStack stack) {
        ResourceHandler<FluidResource> fluidHandler = ItemContainerPlatform.getItemFluidHandler(stack);
        return fluidHandler != null ? FluidInstance.create(((FluidResource)fluidHandler.getResource(0)).getFluid(), fluidHandler.getAmountAsInt(0)) : FluidInstance.empty();
    }

    public static FluidInstance getFluid(Player player, InteractionHand hand) {
        return ItemContainerPlatform.getFluid(player.getItemInHand(hand));
    }

    public static int fillItem(FluidInstance fluidInstance, Player player, InteractionHand hand) {
        return ItemContainerPlatform.fillItem(player.getItemInHand(hand), player, hand, fluidInstance).fluidInstance().getAmount();
    }

    public static ItemFluidContext fillItem(ItemStack stack, FluidInstance fluidInstance) {
        return ItemContainerPlatform.fillItem(stack, null, null, fluidInstance);
    }

    public static FluidInstance drainItem(int maxDrain, Player player, InteractionHand hand) {
        return ItemContainerPlatform.drainItem(maxDrain, player.getItemInHand(hand), player, hand).fluidInstance();
    }

    public static ItemFluidContext drainItem(int maxDrain, ItemStack stack) {
        return ItemContainerPlatform.drainItem(maxDrain, stack, null, null);
    }

    public static int insertEnergy(int energy, Player player, InteractionHand hand) {
        return ItemContainerPlatform.insertEnergy(energy, player.getItemInHand(hand)).contextEnergy();
    }

    public static ItemEnergyContext insertEnergy(int energy, ItemStack stack) {
        try (Transaction transaction = Transaction.open(null);){
            int insert = ItemContainerPlatform.getItemEnergyStorage(stack).insert(energy, (TransactionContext)transaction);
            transaction.commit();
            ItemEnergyContext itemEnergyContext = new ItemEnergyContext(insert, stack);
            return itemEnergyContext;
        }
    }

    public static int extractEnergy(int energy, Player player, InteractionHand hand) {
        return ItemContainerPlatform.extractEnergy(energy, player.getItemInHand(hand)).contextEnergy();
    }

    public static ItemEnergyContext extractEnergy(int energy, ItemStack stack) {
        try (Transaction transaction = Transaction.open(null);){
            int insert = ItemContainerPlatform.getItemEnergyStorage(stack).extract(energy, (TransactionContext)transaction);
            transaction.commit();
            ItemEnergyContext itemEnergyContext = new ItemEnergyContext(insert, stack);
            return itemEnergyContext;
        }
    }

    public static int getEnergy(ItemStack stack) {
        return ItemContainerPlatform.isEnergyContainer(stack) ? 0 : ItemContainerPlatform.getItemEnergyStorage(stack).getAmountAsInt();
    }

    public static ResourceHandler<FluidResource> getItemFluidHandler(ItemStack stack) {
        return (ResourceHandler)stack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)stack));
    }

    public static EnergyHandler getItemEnergyStorage(ItemStack stack) {
        return (EnergyHandler)stack.getCapability(Capabilities.Energy.ITEM, (Object)ItemAccess.forStack((ItemStack)stack));
    }

    public static ItemFluidContext fillItem(ItemStack stack, Player player, InteractionHand hand, FluidInstance fluidInstance) {
        if (!ItemContainerPlatform.isFluidContainer(stack) || player == null && stack.getCount() != 1) {
            return new ItemFluidContext(stack);
        }
        boolean simulate = player != null && player.isCreative();
        ResourceHandler tank = (ResourceHandler)stack.getCapability(Capabilities.Fluid.ITEM, (Object)(player == null ? ItemAccess.forStack((ItemStack)stack) : ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand)));
        try (Transaction transaction = Transaction.open(null);){
            SoundEvent sound;
            int amount = tank.insert((Resource)FluidResource.of((FluidStack)fluidInstance.toStack()), fluidInstance.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            if (player != null && amount > 0 && (sound = fluidInstance.getFluid().getFluidType().getSound(fluidInstance.toStack(), SoundActions.BUCKET_FILL)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), sound, SoundSource.PLAYERS, 0.6f, 0.8f);
            }
            ItemFluidContext itemFluidContext = new ItemFluidContext(FluidInstance.create(fluidInstance.getFluid(), amount), player == null ? stack : player.getItemInHand(hand));
            return itemFluidContext;
        }
    }

    public static ItemFluidContext drainItem(int maxDrain, ItemStack stack, Player player, InteractionHand hand) {
        if (!ItemContainerPlatform.isFluidContainer(stack) || player == null && stack.getCount() != 1) {
            return new ItemFluidContext(stack);
        }
        boolean simulate = player != null && player.isCreative();
        ResourceHandler tank = (ResourceHandler)stack.getCapability(Capabilities.Fluid.ITEM, (Object)(player == null ? ItemAccess.forStack((ItemStack)stack) : ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand)));
        try (Transaction transaction = Transaction.open(null);){
            SoundEvent sound;
            FluidResource resource = (FluidResource)tank.getResource(0);
            int amount = tank.extract((Resource)resource, maxDrain, (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            if (player != null && amount > 0 && (sound = resource.getFluid().getFluidType().getSound(resource.toStack(amount), SoundActions.BUCKET_EMPTY)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), sound, SoundSource.PLAYERS, 0.6f, 0.8f);
            }
            ItemFluidContext itemFluidContext = new ItemFluidContext(FluidInstance.create(resource.getFluid(), amount), player == null ? stack : player.getItemInHand(hand));
            return itemFluidContext;
        }
    }

    public record ItemFluidContext(FluidInstance fluidInstance, ItemStack container) {
        public ItemFluidContext(ItemStack container) {
            this(FluidInstance.empty(), container);
        }
    }

    public record ItemEnergyContext(int contextEnergy, ItemStack container) {
        public ItemEnergyContext(ItemStack container) {
            this(0, container);
        }
    }
}

