/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.base.IHasIdentifier;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.ITagSerializable;
import wily.factoryapi.util.FluidInstance;

public interface IPlatformFluidHandler
extends ITagSerializable<CompoundTag>,
IPlatformHandler,
IHasIdentifier,
ResourceHandler<FluidResource> {
    @NotNull
    public FluidInstance getFluidInstance();

    public int getMaxFluid();

    public boolean isFluidValid(@NotNull FluidInstance var1);

    public int fill(FluidInstance var1, boolean var2);

    @NotNull
    public FluidInstance drain(FluidInstance var1, boolean var2);

    @NotNull
    public FluidInstance drain(int var1, boolean var2);

    default public int getTotalSpace() {
        return Math.max(0, this.getMaxFluid() - this.getFluidInstance().getAmount());
    }

    public void setFluid(FluidInstance var1);

    default public void setCapacity(int capacity) {
        throw new UnsupportedOperationException("This Platform Fluid Handler capacity can't be modified!");
    }

    default public String getName() {
        return this.identifier().getName() + "Tank";
    }

    @Override
    default public void deserializeTag(CompoundTag tag) {
        this.setFluid(FluidInstance.fromTag(tag));
        Tag t = (Tag)tag.tags.get("capacity");
        if (t instanceof NumericTag) {
            if (t instanceof LongTag) {
                LongTag l = (LongTag)t;
                this.setCapacity(FluidInstance.getMilliBucketsFluidAmount(l.value()));
            } else if (t instanceof IntTag) {
                IntTag i = (IntTag)t;
                this.setCapacity(i.value());
            }
        }
    }

    @Override
    default public CompoundTag serializeTag() {
        CompoundTag tag = FluidInstance.toTag(this.getFluidInstance());
        tag.putInt("capacity", this.getMaxFluid());
        return tag;
    }

    default public int size() {
        return 1;
    }

    default public FluidResource getResource(int i) {
        return FluidResource.of((FluidStack)this.getFluidInstance().toStack());
    }

    default public long getAmountAsLong(int i) {
        return this.getFluidInstance().getAmount();
    }

    default public long getCapacityAsLong(int i, FluidResource resource) {
        return this.getMaxFluid();
    }

    default public boolean isValid(int i, FluidResource resource) {
        return this.isFluidValid(FluidInstance.create(resource.getFluid(), 1000));
    }

    default public int insert(int i, FluidResource resource, int j, TransactionContext transactionContext) {
        final FluidInstance fluid = FluidInstance.create(resource.getFluid(), j);
        if (transactionContext instanceof Transaction) {
            Transaction transaction = (Transaction)transactionContext;
            transaction.addCommittingJournal((SnapshotJournal)new SnapshotJournal<Integer>(){

                protected Integer createSnapshot() {
                    return 0;
                }

                protected void revertToSnapshot(Integer object) {
                }

                protected void releaseSnapshot(Integer snapshot) {
                    IPlatformFluidHandler.this.fill(fluid, false);
                }
            });
        }
        return this.fill(fluid, true);
    }

    default public int extract(int i, FluidResource resource, int j, TransactionContext transactionContext) {
        final FluidInstance fluid = FluidInstance.create(resource.getFluid(), j);
        if (transactionContext instanceof Transaction) {
            Transaction transaction = (Transaction)transactionContext;
            transaction.addCommittingJournal((SnapshotJournal)new SnapshotJournal<Integer>(){

                protected Integer createSnapshot() {
                    return 0;
                }

                protected void revertToSnapshot(Integer object) {
                }

                protected void releaseSnapshot(Integer snapshot) {
                    IPlatformFluidHandler.this.drain(fluid, false);
                }
            });
        }
        return this.drain(fluid, true).getAmount();
    }
}

