/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.neoforge;

import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.util.FluidInstance;

public interface NeoForgeFluidHandlerPlatform
extends IPlatformFluidHandler,
IPlatformHandlerApi<ResourceHandler<FluidResource>> {
    @Override
    default public SlotsIdentifier identifier() {
        return SlotsIdentifier.GENERIC;
    }

    @Override
    @NotNull
    default public FluidInstance getFluidInstance() {
        return FactoryAPIPlatform.fluidStackToInstance(((FluidResource)((ResourceHandler)this.getHandler()).getResource(0)).toStack(((ResourceHandler)this.getHandler()).getAmountAsInt(0)));
    }

    @Override
    default public int getMaxFluid() {
        return ((ResourceHandler)this.getHandler()).getCapacityAsInt(0, (Resource)((FluidResource)((ResourceHandler)this.getHandler()).getResource(0)));
    }

    @Override
    default public boolean isFluidValid(@NotNull FluidInstance instance) {
        return ((ResourceHandler)this.getHandler()).isValid(0, (Resource)FluidResource.of((FluidStack)instance.toStack()));
    }

    @Override
    default public int fill(FluidInstance resource, boolean simulate) {
        try (Transaction transaction = Transaction.open(null);){
            int amount = ((ResourceHandler)this.getHandler()).insert((Resource)FluidResource.of((FluidStack)resource.toStack()), resource.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            int n = amount;
            return n;
        }
    }

    @Override
    @NotNull
    default public FluidInstance drain(FluidInstance resource, boolean simulate) {
        try (Transaction transaction = Transaction.open(null);){
            int amount = ((ResourceHandler)this.getHandler()).extract((Resource)FluidResource.of((FluidStack)resource.toStack()), resource.getAmount(), (TransactionContext)transaction);
            if (!simulate) {
                transaction.commit();
            }
            FluidInstance fluidInstance = resource.copyWithAmount(amount);
            return fluidInstance;
        }
    }

    @Override
    @NotNull
    default public FluidInstance drain(int maxDrain, boolean simulate) {
        return this.drain(this.getFluidInstance().copyWithAmount(maxDrain), simulate);
    }

    @Override
    default public void setFluid(FluidInstance fluidStack) {
        if (!this.getFluidInstance().isEmpty()) {
            this.drain(this.getFluidInstance(), false);
        }
        this.fill(fluidStack, false);
    }

    @Override
    default public TransportState getTransport() {
        return TransportState.EXTRACT_INSERT;
    }

    @Override
    default public CompoundTag serializeTag() {
        return new CompoundTag();
    }

    @Override
    default public void deserializeTag(CompoundTag nbt) {
    }
}

