/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.util.DualMap;

public class ListMap<K, V>
implements DualMap<K, V> {
    final Map<K, V> backendMap;
    final List<K> keys;
    final List<V> values;
    final Set<Map.Entry<K, V>> backendSet = new AbstractSet<Map.Entry<K, V>>(){

        @Override
        public int size() {
            return ListMap.this.size();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                int actual = 0;
                boolean canRemove = false;

                @Override
                public boolean hasNext() {
                    return this.actual < this.size();
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("No more elements.");
                    }
                    this.canRemove = true;
                    AbstractMap.SimpleEntry entry = new AbstractMap.SimpleEntry<K, V>(ListMap.this.keys.get(this.actual), ListMap.this.values.get(this.actual)){

                        @Override
                        public V setValue(V value) {
                            return ListMap.this.put(this.getKey(), value);
                        }
                    };
                    ++this.actual;
                    return entry;
                }

                @Override
                public void remove() {
                    if (!this.canRemove) {
                        throw new IllegalStateException("Cannot remove without calling next()");
                    }
                    ListMap.this.remove(ListMap.this.keys.get(--this.actual));
                    this.canRemove = false;
                }
            };
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }
    };

    public ListMap(Builder<K, V> builder) {
        this.backendMap = new HashMap();
        this.keys = builder.keys;
        this.values = builder.values;
        if (this.keys.size() != this.values.size()) {
            throw new UnsupportedOperationException("Invalid ListMap Builder: It should have the same amount of keys and values!");
        }
        for (int i = 0; i < this.keys.size(); ++i) {
            this.backendMap.put(this.keys.get(i), this.values.get(i));
        }
    }

    public ListMap() {
        this(new Builder());
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.keys.contains(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.values.contains(o);
    }

    @Override
    public V get(Object o) {
        return this.backendMap.get(o);
    }

    public V getByIndex(int i) {
        return this.values.get(i);
    }

    @Override
    public K getKey(V value) {
        return this.getKeyOrDefault(value, null);
    }

    public K getKeyByIndex(int i) {
        return this.keys.get(i);
    }

    @Override
    public K getKeyOrDefault(V value, K defaultKey) {
        return this.containsValue(value) ? this.keys.get(this.values.indexOf(value)) : defaultKey;
    }

    public int indexOf(V value) {
        return this.values.indexOf(value);
    }

    public int indexOfKey(K key) {
        return this.keys.indexOf(key);
    }

    @Override
    @Nullable
    public V put(K k, V v) {
        V oldValue = null;
        if (!this.containsKey(k)) {
            this.keys.add(k);
            this.values.add(v);
            this.backendMap.put(k, v);
        } else {
            oldValue = this.values.set(this.keys.indexOf(k), v);
        }
        return oldValue;
    }

    @Override
    public V remove(Object o) {
        int index = this.keys.indexOf(o);
        if (index >= 0) {
            this.keys.remove(index);
            this.backendMap.remove(o);
            return this.values.remove(index);
        }
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        this.keys.clear();
        this.values.clear();
        this.backendMap.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return Set.copyOf(this.keys);
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.values;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backendSet;
    }

    public record Builder<K, V>(List<K> keys, List<V> values) {
        public Builder() {
            this(new ArrayList(), new ArrayList());
        }

        public Builder<K, V> put(K key, V value) {
            this.keys.add(key);
            this.values.add(value);
            return this;
        }

        public <OK, OV> Builder<OK, OV> mapEntries(Function<K, OK> keyMapper, Function<V, OV> valueMapper) {
            return new Builder(this.keys.stream().map(keyMapper).collect(Collectors.toList()), this.values.stream().map(valueMapper).collect(Collectors.toList()));
        }

        public <OK> Builder<OK, V> mapKeys(Function<K, OK> keyMapper) {
            return new Builder(this.keys.stream().map(keyMapper).collect(Collectors.toList()), this.values);
        }

        public <OV> Builder<K, OV> mapValues(Function<V, OV> valueMapper) {
            return new Builder(this.keys, this.values.stream().map(valueMapper).collect(Collectors.toList()));
        }

        public ListMap<K, V> build() {
            return new ListMap(this);
        }
    }
}

