/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.mixin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.spectator.SpectatorGui;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.Objective;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.VariablesMap;

@Mixin(value={Gui.class})
public abstract class GuiMixin
implements UIAccessor,
GuiAccessor {
    @Shadow
    private int overlayMessageTime;
    @Shadow
    @Nullable
    private Component overlayMessageString;
    @Unique
    private final List<Renderable> renderables = new ArrayList<Renderable>();
    @Unique
    private final VariablesMap<String, ArbitrarySupplier<?>> elements = new VariablesMap();
    @Unique
    private final List<UIDefinition> definitions = new ArrayList<UIDefinition>();
    @Unique
    private final List<UIDefinition> staticDefinitions = new ArrayList<UIDefinition>();

    @Override
    @Nullable
    public Screen getScreen() {
        return null;
    }

    @Override
    public boolean initialized() {
        return true;
    }

    @Override
    public List<UIDefinition> getDefinitions() {
        return this.definitions;
    }

    @Override
    public List<UIDefinition> getStaticDefinitions() {
        return this.staticDefinitions;
    }

    @Override
    public List<GuiEventListener> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public List<Renderable> getChildrenRenderables() {
        return this.renderables;
    }

    @Override
    public <T extends GuiEventListener> T removeChild(T listener) {
        if (listener instanceof Renderable) {
            Renderable r = (Renderable)listener;
            this.renderables.remove(r);
        }
        return listener;
    }

    @Override
    public <T extends GuiEventListener> T addChild(int renderableIndex, T listener, boolean isRenderable, boolean isNarratable) {
        if (listener instanceof Renderable) {
            Renderable r = (Renderable)listener;
            this.addRenderable(renderableIndex, r);
        }
        return listener;
    }

    @Override
    public void beforeInit(UIAccessor accessor) {
        UIAccessor.super.beforeInit(accessor);
        this.putSupplierComponent("overlayMessage.component", () -> this.overlayMessageString == null ? CommonComponents.EMPTY : this.overlayMessageString);
        this.getElements().put("overlayMessage.time", Bearer.of(() -> this.overlayMessageTime, i -> {
            this.overlayMessageTime = i;
        }));
    }

    @Override
    public VariablesMap<String, ArbitrarySupplier<?>> getElements() {
        return this.elements;
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void beforeTick(CallbackInfo ci) {
        this.beforeTick();
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void afterTick(CallbackInfo ci) {
        this.afterTick();
    }

    @Inject(method={"renderVignette"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderVignette(GuiGraphics guiGraphics, Entity entity, CallbackInfo ci) {
        FactoryGuiElement.VIGNETTE.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderVignette"}, at={@At(value="RETURN")})
    public void renderVignetteReturn(GuiGraphics guiGraphics, Entity entity, CallbackInfo ci) {
        FactoryGuiElement.VIGNETTE.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderCrosshair(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.CROSSHAIR.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderCrosshair"}, at={@At(value="RETURN")})
    public void renderCrosshairReturn(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.CROSSHAIR.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderEffects"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderEffects(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.EFFECTS.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderEffects"}, at={@At(value="RETURN")})
    public void renderEffectsReturn(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.EFFECTS.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderItemHotbar"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderHotbar(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.HOTBAR.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderItemHotbar"}, at={@At(value="RETURN")})
    public void renderHotbarReturn(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.HOTBAR.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"displayScoreboardSidebar"}, at={@At(value="HEAD")}, cancellable=true)
    private void displayScoreboardSidebar(GuiGraphics guiGraphics, Objective objective, CallbackInfo ci) {
        FactoryGuiElement.SCOREBOARD.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"displayScoreboardSidebar"}, at={@At(value="RETURN")})
    private void displayScoreboardSidebarReturn(GuiGraphics guiGraphics, Objective objective, CallbackInfo ci) {
        FactoryGuiElement.SCOREBOARD.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderOverlayMessage"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderOverlayMessage(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.OVERLAY_MESSAGE.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderOverlayMessage"}, at={@At(value="RETURN")})
    public void renderOverlayMessageReturn(GuiGraphics guiGraphics, DeltaTracker deltaTracker, CallbackInfo ci) {
        FactoryGuiElement.OVERLAY_MESSAGE.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderPlayerHealth"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderHealth(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.PLAYER_HEALTH.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderPlayerHealth"}, at={@At(value="RETURN")})
    public void renderHealthReturn(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.PLAYER_HEALTH.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderVehicleHealth"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderVehicleHealth(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.VEHICLE_HEALTH.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderVehicleHealth"}, at={@At(value="RETURN")})
    public void renderVehicleHealthReturn(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.VEHICLE_HEALTH.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderHealthLevel", "renderArmorLevel", "renderFoodLevel", "renderAirLevel"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void renderNeoForgeHealth(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.PLAYER_HEALTH.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderHealthLevel", "renderArmorLevel", "renderFoodLevel", "renderAirLevel"}, at={@At(value="RETURN")}, remap=false)
    public void renderNeoForgeHealthReturn(GuiGraphics guiGraphics, CallbackInfo ci) {
        FactoryGuiElement.PLAYER_HEALTH.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderExperienceBar(GuiGraphics guiGraphics, int i, CallbackInfo ci) {
        FactoryGuiElement.EXPERIENCE_BAR.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderExperienceBar"}, at={@At(value="RETURN")})
    public void renderExperienceBarReturn(GuiGraphics guiGraphics, int i, CallbackInfo ci) {
        FactoryGuiElement.EXPERIENCE_BAR.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderJumpMeter"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderJumpMeter(PlayerRideableJumping playerRideableJumping, GuiGraphics guiGraphics, int i, CallbackInfo ci) {
        FactoryGuiElement.JUMP_METER.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderJumpMeter"}, at={@At(value="RETURN")})
    public void renderJumpMeterReturn(PlayerRideableJumping playerRideableJumping, GuiGraphics guiGraphics, int i, CallbackInfo ci) {
        FactoryGuiElement.JUMP_METER.finalizeMixin(guiGraphics, this);
    }

    @Inject(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void renderSelectedItemName(GuiGraphics guiGraphics, int shift, CallbackInfo ci) {
        FactoryGuiElement.SELECTED_ITEM_NAME.prepareMixin(guiGraphics, this, ci);
    }

    @Inject(method={"renderSelectedItemName(Lnet/minecraft/client/gui/GuiGraphics;I)V"}, at={@At(value="RETURN")}, remap=false)
    public void renderSelectedItemNameReturn(GuiGraphics guiGraphics, int shift, CallbackInfo ci) {
        FactoryGuiElement.SELECTED_ITEM_NAME.finalizeMixin(guiGraphics, this);
    }

    @Override
    @Accessor
    public abstract SpectatorGui getSpectatorGui();

    @Override
    @Accessor
    public abstract ItemStack getLastToolHighlight();

    @Override
    @Accessor
    public abstract int getToolHighlightTimer();
}

