/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.gui.screens.RealmsBackupScreen;
import com.mojang.realmsclient.gui.screens.RealmsConfirmScreen;
import com.mojang.realmsclient.gui.screens.RealmsInviteScreen;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.AccessibilityOnboardingScreen;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.DirectJoinServerScreen;
import net.minecraft.client.gui.screens.EditServerScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.BlastFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.BrewingStandScreen;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.DispenserScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.gui.screens.inventory.FurnaceScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.client.gui.screens.inventory.HopperScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.LoomScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.client.gui.screens.inventory.SmithingScreen;
import net.minecraft.client.gui.screens.inventory.SmokerScreen;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.options.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.options.ChatOptionsScreen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.client.gui.screens.options.MouseSettingsScreen;
import net.minecraft.client.gui.screens.options.OnlineOptionsScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.options.SkinCustomizationScreen;
import net.minecraft.client.gui.screens.options.SoundOptionsScreen;
import net.minecraft.client.gui.screens.options.VideoSettingsScreen;
import net.minecraft.client.gui.screens.options.controls.ControlsScreen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.telemetry.TelemetryInfoScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.item.ItemStack;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.DatapackRepositoryAccessor;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.util.BooleanExpressionEvaluator;
import wily.factoryapi.util.DynamicUtil;
import wily.factoryapi.util.ExpressionEvaluator;
import wily.factoryapi.util.FactoryItemUtil;
import wily.factoryapi.util.ListMap;

public class UIDefinitionManager
implements ResourceManagerReloadListener {
    public static final String UI_DEFINITIONS = "ui_definitions";
    public static final ListMap<ResourceLocation, Class<?>> NAMED_UI_TARGETS = new ListMap.Builder<String, Class<Screen>>().put("screen", Screen.class).put("accessibility_onboarding_screen", AccessibilityOnboardingScreen.class).put("title_screen", TitleScreen.class).put("options_screen", OptionsScreen.class).put("skin_customization_screen", SkinCustomizationScreen.class).put("video_settings_screen", VideoSettingsScreen.class).put("language_select_screen", LanguageSelectScreen.class).put("pack_selection_screen", PackSelectionScreen.class).put("telemetry_info_screen", TelemetryInfoScreen.class).put("online_options_screen", OnlineOptionsScreen.class).put("sound_options_screen", SoundOptionsScreen.class).put("controls_screen", ControlsScreen.class).put("mouse_settings_screen", MouseSettingsScreen.class).put("key_binds_screen", KeyBindsScreen.class).put("chat_options_screen", ChatOptionsScreen.class).put("accessibility_options_screen", AccessibilityOptionsScreen.class).put("credits_and_attribution_screen", CreditsAndAttributionScreen.class).put("win_screen", WinScreen.class).put("confirm_link_screen", ConfirmLinkScreen.class).put("select_world_screen", SelectWorldScreen.class).put("create_world_screen", CreateWorldScreen.class).put("edit_world_screen", EditWorldScreen.class).put("join_multiplayer_screen", JoinMultiplayerScreen.class).put("edit_server_screen", EditServerScreen.class).put("direct_join_server_screen", DirectJoinServerScreen.class).put("realms_main_screen", RealmsMainScreen.class).put("realms_screen", RealmsScreen.class).put("realms_confirm_screen", RealmsConfirmScreen.class).put("realms_backup_screen", RealmsBackupScreen.class).put("realms_invite_screen", RealmsInviteScreen.class).put("share_to_lan_screen", ShareToLanScreen.class).put("advancements_screen", AdvancementsScreen.class).put("stats_screen", StatsScreen.class).put("confirm_screen", ConfirmScreen.class).put("level_loading_screen", LevelLoadingScreen.class).put("progress_screen", ProgressScreen.class).put("generic_message_screen", GenericMessageScreen.class).put("receiving_level_screen", ReceivingLevelScreen.class).put("connect_screen", ConnectScreen.class).put("pause_screen", PauseScreen.class).put("inventory_screen", InventoryScreen.class).put("crafting_screen", CraftingScreen.class).put("container_screen", ContainerScreen.class).put("abstract_furnace_screen", AbstractFurnaceScreen.class).put("furnace_screen", FurnaceScreen.class).put("smoker_screen", SmokerScreen.class).put("blast_furnace_screen", BlastFurnaceScreen.class).put("loom_screen", LoomScreen.class).put("stonecutter_screen", StonecutterScreen.class).put("grindstone_screen", GrindstoneScreen.class).put("enchantment_screen", EnchantmentScreen.class).put("hopper_screen", HopperScreen.class).put("dispenser_screen", DispenserScreen.class).put("shulker_box_screen", ShulkerBoxScreen.class).put("anvil_screen", AnvilScreen.class).put("smithing_screen", SmithingScreen.class).put("brewing_stand_screen", BrewingStandScreen.class).put("beacon_screen", BeaconScreen.class).put("chat_screen", ChatScreen.class).put("in_bed_chat_screen", InBedChatScreen.class).put("gui", Gui.class).mapKeys(FactoryAPI::createVanillaLocation).build();
    public static final ListMap<ResourceLocation, Function<Screen, Screen>> DEFAULT_SCREENS_MAP = new ListMap.Builder<String, Function<Screen, Screen>>().put("title", s -> new TitleScreen()).put("options", s -> new OptionsScreen(s, Minecraft.getInstance().options)).put("language_select", s -> new LanguageSelectScreen(s, Minecraft.getInstance().options, Minecraft.getInstance().getLanguageManager())).put("video_settings", s -> new VideoSettingsScreen(s, Minecraft.getInstance(), Minecraft.getInstance().options)).put("skin_customization", s -> new SkinCustomizationScreen(s, Minecraft.getInstance().options)).put("online_options", s -> new OnlineOptionsScreen(s, Minecraft.getInstance().options)).put("controls", s -> new ControlsScreen(s, Minecraft.getInstance().options)).put("mouse_settings", s -> new MouseSettingsScreen(s, Minecraft.getInstance().options)).put("key_binds", s -> new KeyBindsScreen(s, Minecraft.getInstance().options)).put("chat_options", s -> new ChatOptionsScreen(s, Minecraft.getInstance().options)).put("accessibility_options", s -> new AccessibilityOptionsScreen(s, Minecraft.getInstance().options)).put("credits_and_attribution", CreditsAndAttributionScreen::new).put("select_world", SelectWorldScreen::new).mapKeys(FactoryAPI::createVanillaLocation).build();
    public final ListMap<ResourceLocation, UIDefinition> map = new ListMap();
    public final List<UIDefinition> staticList = new ArrayList<UIDefinition>();

    public static void registerNamedUITarget(ResourceLocation id, Class<?> uiClass) {
        NAMED_UI_TARGETS.put(id, uiClass);
    }

    public static void registerNamedUITarget(String path, Class<?> uiClass) {
        UIDefinitionManager.registerNamedUITarget(FactoryAPI.createVanillaLocation(path), uiClass);
    }

    public static void registerDefaultScreen(ResourceLocation id, Function<Screen, Screen> defaultScreen) {
        DEFAULT_SCREENS_MAP.put(id, defaultScreen);
    }

    public static void registerDefaultScreen(String path, Function<Screen, Screen> defaultScreen) {
        UIDefinitionManager.registerDefaultScreen(FactoryAPI.createVanillaLocation(path), defaultScreen);
    }

    public String getName() {
        return "factoryapi:ui_definition_manager";
    }

    public static Checkbox createCheckbox(boolean selected, BiConsumer<Checkbox, Boolean> onPress) {
        return Checkbox.builder((Component)Component.empty(), (Font)Minecraft.getInstance().font).selected(selected).onValueChange(onPress::accept).build();
    }

    public static List<Integer> parseIntRange(String s) {
        if (!s.contains(",")) {
            return Collections.singletonList(Integer.parseInt(s));
        }
        String[] numbers = s.split(",");
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (int i = 0; i < numbers.length; ++i) {
            boolean closed = numbers[i].startsWith("[");
            if (closed || numbers[i].startsWith("]")) {
                boolean endClosed;
                int start = Integer.parseInt(numbers[i].substring(1));
                if (!(endClosed = numbers[++i].endsWith("]")) && !numbers[i].endsWith("[")) {
                    FactoryAPI.LOGGER.warn("Incorrect integer interval syntax at ordinal {}, skipping this. \nInteger Range: {}", (Object)(i - 1), (Object)s);
                    continue;
                }
                int end = Integer.parseInt(numbers[i].replace(endClosed ? "]" : "[", ""));
                IntStream.rangeClosed(start + (closed ? 0 : -Mth.sign((double)start)), end + (endClosed ? 0 : -Mth.sign((double)end))).forEach(range::add);
                continue;
            }
            range.add(Integer.parseInt(numbers[i]));
        }
        return range;
    }

    public final void applyStatic(UIAccessor accessor) {
        accessor.getDefinitions().addAll(this.staticList);
    }

    public final void apply(UIAccessor accessor) {
        accessor.getDefinitions().addAll(this.map.values());
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        this.map.clear();
        resourceManager.listResources(UI_DEFINITIONS, r -> r.getPath().endsWith(".json")).forEach((l, r) -> {
            try (BufferedReader bufferedReader = r.openAsReader();){
                Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)GsonHelper.parse((Reader)bufferedReader));
                if (this.map.containsKey(l) && !dynamic.get("replace").asBoolean(false)) {
                    this.map.get(l).getStaticDefinitions().addAll(UIDefinitionManager.fromDynamic(l.toString(), dynamic).getStaticDefinitions());
                } else {
                    this.map.put((ResourceLocation)l, UIDefinitionManager.fromDynamicWithTarget(l.toString(), dynamic));
                }
            }
            catch (IOException exception) {
                FactoryAPI.LOGGER.warn(exception.getMessage());
            }
        });
    }

    public static Class<?> getClassFromString(String uiDefinitionName, String s) {
        try {
            return Class.forName(FactoryAPIPlatform.getCurrentClassName(s));
        }
        catch (ClassNotFoundException e) {
            FactoryAPI.LOGGER.warn("Incorrect Class Name {} from UI Definition {}: {}", (Object)s, (Object)uiDefinitionName, (Object)e.getMessage());
            return null;
        }
    }

    public static <T> UIDefinition.Instance fromDynamic(String name, Dynamic<T> dynamic, Predicate<UIAccessor> extraCondition) {
        Optional applyConditionDefinition = dynamic.get("applyCondition").map(d -> ElementType.parseBooleanElementOrReference("applyCondition", d)).result();
        UIDefinition.Instance uiDefinition = new UIDefinition.Instance(name, accessor -> {
            if (!extraCondition.test((UIAccessor)accessor)) {
                return false;
            }
            return applyConditionDefinition.isEmpty() || (Boolean)((ElementValue)applyConditionDefinition.get()).value().apply((UIAccessor)accessor) != false;
        });
        UIDefinitionManager.parseAllElements(uiDefinition, a -> a, dynamic, s -> s);
        return uiDefinition;
    }

    public static <T> UIDefinition.Instance fromDynamic(String name, Dynamic<T> dynamic) {
        return UIDefinitionManager.fromDynamic(name, dynamic, a -> true);
    }

    public static <T> UIDefinition.Instance fromDynamicWithTarget(String name, Dynamic<T> dynamic) {
        String targetType = dynamic.get("targetType").asString("id");
        Class targetClass = dynamic.get("targetUI").asString().map(s -> targetType.equals("id") ? NAMED_UI_TARGETS.get(ResourceLocation.tryParse((String)s)) : (targetType.equals("class") ? UIDefinitionManager.getClassFromString(name, s) : null)).result().orElse(null);
        Component targetTitle = targetType.equals("screenTitle") ? (Component)dynamic.get("targetUI").flatMap(arg_0 -> DynamicUtil.getComponentCodec().parse(arg_0)).result().orElse(null) : null;
        String targetRange = dynamic.get("targetRange").asString("instance");
        return UIDefinitionManager.fromDynamic(name, dynamic, accessor -> accessor.toString().equals(name) || targetClass != null && (targetRange.equals("instance") && targetClass.isInstance(accessor) || targetRange.equals("class") && targetClass == accessor.getClass()) || targetTitle != null && accessor.getScreen() != null && accessor.getScreen().getTitle().equals((Object)targetTitle));
    }

    public static void parseAllElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, Dynamic<?> dynamic, Function<String, String> nameModifier) {
        dynamic.get("elements").asMapOpt(Dynamic::asString, d -> d).result().ifPresentOrElse(m -> m.forEach((s, d) -> UIDefinitionManager.tryParseElement(uiDefinition, accessorFunction, (DataResult<String>)s, d, nameModifier)), () -> dynamic.get("elements").asStream().forEach(d -> UIDefinitionManager.tryParseElement(uiDefinition, accessorFunction, (DataResult<String>)d.get("name").asString(), d, nameModifier)));
        UIDefinitionManager.handleDeprecatedDefinitionsAddition(uiDefinition);
    }

    public static void tryParseElement(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, DataResult<String> name, Dynamic<?> dynamic, Function<String, String> nameModifier) {
        name.result().ifPresent(s -> dynamic.get("type").asString().map(ElementType::get).result().ifPresentOrElse(p -> p.parse(uiDefinition, accessorFunction, (String)nameModifier.apply((String)s), dynamic), () -> ArbitrarySupplier.of(ElementType.parseNumber((String)nameModifier.apply((String)s), dynamic)).ifPresent(uiDefinition::addStatic)));
    }

    @Deprecated
    private static void handleDeprecatedDefinitionsAddition(UIDefinition uiDefinition) {
        if (uiDefinition.getDefinitions().isEmpty()) {
            return;
        }
        uiDefinition.getStaticDefinitions().addAll(uiDefinition.getDefinitions());
        uiDefinition.getDefinitions().clear();
    }

    public void openDefaultScreenAndAddDefinition(Optional<ResourceLocation> defaultScreen, UIDefinition uiDefinition) {
        Screen s = defaultScreen.map(DEFAULT_SCREENS_MAP::get).orElse(parent -> new Screen(this, (Component)Component.empty()){}).apply(Minecraft.getInstance().screen);
        UIAccessor.of(s).addStatic(uiDefinition);
        Minecraft.getInstance().setScreen(s);
    }

    public static interface ElementType {
        public static final ListMap<ResourceLocation, ElementType> map = new ListMap();
        public static final ElementType CHILDREN = ElementType.registerConditional("children", (definition, accessorFunction, name, e) -> UIDefinitionManager.parseAllElements(definition, accessorFunction, e, s -> e.get("applyPrefix").asBoolean(true) ? name + "." + s : s));
        public static final ElementType ADD_BUTTON = ElementType.registerConditional("add_button", (definition, accessorFunction, name, e) -> {
            List<WidgetAction.PressSupplier<AbstractWidget>> actions = ElementType.parseActionsElement(definition, name, e);
            ElementType.parseWidgetElements(definition, name, e);
            definition.addStatic(UIDefinition.createAfterInit(a -> a.putWidget(name, ((UIAccessor)accessorFunction.apply(a)).addChild(name, Button.builder((Component)Component.empty(), b -> actions.forEach(c -> c.press((UIAccessor)a, b, WidgetAction.Type.ENABLE))).build()))));
        });
        public static final ElementType ADD_CHECKBOX = ElementType.registerConditional("add_checkbox", (definition, accessorFunction, name, e) -> {
            List<WidgetAction.PressSupplier<AbstractWidget>> actions = ElementType.parseActionsElement(definition, name, e);
            ElementType.parseWidgetElements(definition, name, e);
            ElementType.parseElement(definition, name, e, "selected", ElementType::parseBoolean);
            definition.addStatic(UIDefinition.createAfterInit(a -> a.putWidget(name, ((UIAccessor)accessorFunction.apply(a)).addChild(name, UIDefinitionManager.createCheckbox(a.getBoolean(name + ".selected"), (c, b) -> actions.forEach(c1 -> c1.press((UIAccessor)a, c, c.selected() ? WidgetAction.Type.ENABLE : WidgetAction.Type.DISABLE)))))));
        });
        public static final ElementType ADD_SLIDER = ElementType.registerConditional("add_slider", (definition, accessorFunction, name, e) -> {
            final List entries = e.get("entries").asList(d -> new WidgetAction.CycleEntry((Component)d.get("message").flatMap(arg_0 -> DynamicUtil.getComponentCodec().parse(arg_0)).result().orElse(Component.empty()), ElementType.parseActionsElement(definition, name, d)));
            ElementType.parseElement(definition, name, e, "initialIndex", ElementType::parseNumber);
            ElementType.parseWidgetElements(definition, name, e);
            definition.addStatic(UIDefinition.createAfterInit(a -> a.putWidget(name, ((UIAccessor)accessorFunction.apply(a)).addChild(name, new AbstractSliderButton(0, 0, 200, 20, (Component)Component.empty(), Math.min((double)(entries.size() - 1), (double)a.getInteger(name + "initialIndex", 0) / ((double)entries.size() - 1.0)), (UIAccessor)a){
                WidgetAction.CycleEntry entry;
                final /* synthetic */ UIAccessor val$a;
                {
                    this.val$a = uIAccessor;
                    super(i, j, k, l, arg, d);
                    this.entry = this.getActualEntry();
                }

                protected void updateMessage() {
                    this.setMessage(this.entry.message());
                }

                private WidgetAction.CycleEntry getActualEntry() {
                    return (WidgetAction.CycleEntry)entries.get((int)((double)(entries.size() - 1) * this.value));
                }

                protected void applyValue() {
                    WidgetAction.CycleEntry oldEntry = this.entry;
                    this.entry = this.getActualEntry();
                    if (!this.entry.equals(oldEntry)) {
                        oldEntry.actions().forEach(action -> action.press(this.val$a, this, WidgetAction.Type.DISABLE));
                        this.entry.actions().forEach(action -> action.press(this.val$a, this, WidgetAction.Type.ENABLE));
                    }
                }
            })).updateMessage()));
        });
        public static final ElementType MODIFY_WIDGET = ElementType.registerConditional("modify_widget", ElementType.createIndexable(i -> (definition, accessorFunction, name, e) -> {
            List<WidgetAction.PressSupplier<AbstractWidget>> actions = ElementType.parseActionsElement(definition, name, e);
            i.forEach(index -> ElementType.parseWidgetElements(definition, name + (String)(i.size() == 1 ? "" : "_" + index), e));
            definition.addStatic(UIDefinition.createAfterInit(a -> {
                Consumer<AbstractWidget> onPressOverride = actions.isEmpty() ? null : w -> actions.forEach(action -> action.press((UIAccessor)a, w, WidgetAction.Type.ENABLE));
                Bearer<Integer> count = Bearer.of(0);
                a.getElements().put(name + ".index", count);
                for (Integer index : i) {
                    GuiEventListener patt0$temp;
                    if (a.getChildren().size() <= index || !((patt0$temp = a.getChildren().get(index)) instanceof AbstractWidget)) continue;
                    AbstractWidget w2 = (AbstractWidget)patt0$temp;
                    String suffixedName = name + (String)(i.size() == 1 ? "" : "_" + index);
                    if (onPressOverride != null) {
                        a.putStaticElement(suffixedName + ".onPressOverride", onPressOverride);
                    }
                    ((UIAccessor)accessorFunction.apply(a)).putWidget(suffixedName, w2);
                    count.set((Integer)count.get() + 1);
                }
            }));
        }));
        public static final ElementType REMOVE_WIDGET = ElementType.registerConditional("remove_widget", ElementType.createIndexable(i -> (definition, accessorFunction, name, e) -> definition.addStatic(UIDefinition.createAfterInit(a -> {
            for (Integer index : i) {
                if (a.getChildren().size() <= index) continue;
                ((UIAccessor)accessorFunction.apply(a)).removeChild(a.getChildren().get(index));
            }
        }))));
        public static final ElementType PUT_NUMBER = ElementType.registerConditional("put_number", (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> ElementType.parseNumber(name, d)));
        public static final ElementType PUT_COMPONENT = ElementType.registerConditional("put_component", (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> ElementType.parseComponentElement(name, d)));
        public static final ElementType PUT_STRING = ElementType.registerCodec("put_string", Codec.STRING);
        public static final ElementType PUT_BOOLEAN = ElementType.registerConditional("put_boolean", (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> ElementType.parseBoolean(name, d)));
        public static final ElementType PUT_RESOURCE_LOCATION = ElementType.registerCodec("put_resource_location", ResourceLocation.CODEC);
        public static final ElementType PUT_VEC3 = ElementType.registerCodec("put_vec3", DynamicUtil.VEC3_OBJECT_CODEC);
        public static final ElementType PUT_VEC2 = ElementType.registerCodec("put_vec2", DynamicUtil.VEC2_CODEC);
        public static final ElementType BLIT = ElementType.registerConditional("blit", ElementType::parseBlitElements);
        public static final ElementType BLIT_SPRITE = ElementType.registerConditional("blit_sprite", ElementType::parseBlitSpriteElements);
        public static final ElementType FILL = ElementType.registerConditional("fill", ElementType::parseFillElements);
        public static final ElementType FILL_GRADIENT = ElementType.registerConditional("fill_gradient", ElementType::parseFillGradientElements);
        public static final ElementType DRAW_STRING = ElementType.registerConditional("draw_string", ElementType::parseDrawStringElements);
        public static final ElementType DRAW_MULTILINE_STRING = ElementType.registerConditional("draw_multiline_string", ElementType::parseDrawMultilineStringElements);
        public static final ElementType RENDER_ITEM = ElementType.registerConditional("render_item", ElementType::parseRenderItemElements);
        public static final ElementType RENDER_ITEMS = ElementType.registerConditional("render_items", ElementType::parseRenderItemsElements);
        public static final ElementType COMPARE_ITEMS = ElementType.registerConditional("compare_items", (uiDefinition, accessorFunction, elementName, element) -> {
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseItemStackElement, "firstItem", "secondItem");
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseBoolean, "checkCount", "strict");
            uiDefinition.addStatic(UIDefinition.createBeforeInit(a -> a.getElements().put(elementName, () -> FactoryItemUtil.compareItems(a.getItemStack(elementName + ".firstItem"), a.getItemStack(elementName + ".secondItem"), a.getBoolean(elementName + ".checkCount", true), a.getBoolean(elementName + ".strict", true)))));
        });
        public static final ElementType CHANCE = ElementType.registerConditional("chance", (uiDefinition, accessorFunction, elementName, element) -> {
            RandomSource rand = RandomSource.create();
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "min", "max");
            uiDefinition.addStatic(UIDefinition.createBeforeInit(a -> a.getElements().put(elementName, () -> rand.nextInt(a.getInteger(elementName + ".min", 0), a.getInteger(elementName + ".max", 0)))));
        });

        public static void parseWidgetElements(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "x", "y", "width", "height", "order");
            ElementType.parseElements(uiDefinition, elementName, element, (s, d) -> ElementType.parseComponentElement(elementName, s, d), "message", "tooltip");
            ElementType.parseElement(uiDefinition, elementName, element, "spriteOverride", ResourceLocation.CODEC);
            ElementType.parseElement(uiDefinition, elementName, element, "highlightedSpriteOverride", ResourceLocation.CODEC);
            ElementType.parseElement(uiDefinition, elementName, element, "isVisible", ElementType::parseBoolean);
        }

        public static void parseFillElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "x", "y", "width", "height", "color", "order");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.addStatic(UIDefinition.createAfterInit(a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> guiGraphics.fill(a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".x", 0) + a.getInteger(elementName + ".width", 0), a.getInteger(elementName + ".y", 0) + a.getInteger(elementName + ".height", 0), a.getInteger(elementName + ".color", -1))))));
        }

        public static void parseFillGradientElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "x", "y", "width", "height", "color", "secondColor", "order");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.addStatic(UIDefinition.createAfterInit(a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> guiGraphics.fillGradient(a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".x", 0) + a.getInteger(elementName + ".width", 0), a.getInteger(elementName + ".y", 0) + a.getInteger(elementName + ".height", 0), a.getInteger(elementName + ".color", -1), a.getInteger(elementName + ".secondColor", -1))))));
        }

        public static void parseBlitElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElement(uiDefinition, elementName, element, "texture", ResourceLocation.CODEC);
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "x", "y", "uvX", "uvY", "width", "height", "imageWidth", "imageHeight", "renderColor", "order", "amount");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.addStatic(UIDefinition.createAfterInitWithAmount(elementName, a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> a.getElement(elementName + ".texture", ResourceLocation.class).ifPresent(t -> FactoryGuiGraphics.of(guiGraphics).blit((ResourceLocation)t, a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".uvX", 0), a.getInteger(elementName + ".uvY", 0), a.getInteger(elementName + ".width", 0), a.getInteger(elementName + ".height", 0), a.getInteger(elementName + ".imageWidth", 256), a.getInteger(elementName + ".imageHeight", 256)))))));
        }

        public static void parseTranslationElements(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "translateX", "translateY", "translateZ", "scaleX", "scaleY", "scaleZ");
        }

        public static void parseBlitSpriteElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElement(uiDefinition, elementName, element, "sprite", ResourceLocation.CODEC);
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "x", "y", "width", "height", "renderColor", "order", "amount");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.addStatic(UIDefinition.createAfterInitWithAmount(elementName, a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> a.getElement(elementName + ".sprite", ResourceLocation.class).ifPresent(t -> FactoryGuiGraphics.of(guiGraphics).blitSprite((ResourceLocation)t, a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".width", 0), a.getInteger(elementName + ".height", 0)))))));
        }

        public static void parseTextElements(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            ElementType.parseElement(uiDefinition, elementName, element, "component", (String s, Dynamic<?> d) -> ElementType.parseComponentElement(elementName, s, d));
            ElementType.parseElement(uiDefinition, elementName, element, "shadow", ElementType::parseBoolean);
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "x", "y", "color", "order");
        }

        public static void parseDrawStringElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseTextElements(uiDefinition, elementName, element);
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.addStatic(UIDefinition.createAfterInit(a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> a.getElement(elementName + ".component", Component.class).ifPresent(c -> guiGraphics.drawString(Minecraft.getInstance().font, c, a.getInteger(elementName + ".x", 0), a.getInteger(elementName + ".y", 0), a.getInteger(elementName + ".color", -1), a.getBoolean(elementName + ".shadow", true).booleanValue()))))));
        }

        public static void parseDrawMultilineStringElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseTextElements(uiDefinition, elementName, element);
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "lineSpacing", "width");
            ElementType.parseElement(uiDefinition, elementName, element, "centered", ElementType::parseBoolean);
            uiDefinition.addStatic(UIDefinition.createAfterInit(a -> a.getElement(elementName + ".component", Component.class).ifPresent(c -> {
                int lineSpacing = a.getInteger(elementName + ".lineSpacing", 12);
                int width = a.getInteger(elementName + ".width", 0);
                AdvancedTextWidget advancedTextWidget = a.putLayoutElement(elementName, ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addChild(elementName, new AdvancedTextWidget((UIAccessor)a).lineSpacing(lineSpacing).withLines((Component)c, width).withColor(a.getInteger(elementName + ".color", -1)).withShadow(a.getBoolean(elementName + ".shadow", true)).centered(a.getBoolean(elementName + ".centered", false))), i -> {}, i -> {});
                a.putStaticElement(elementName + ".linesCount", advancedTextWidget.getLines().size());
            })));
        }

        public static void parseRenderItemsElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseBoolean, "isFake", "allowDecorations");
            ElementType.parseElement(uiDefinition, elementName, element, "items", (String s, Dynamic<?> d) -> d.asListOpt(d1 -> DynamicUtil.getItemFromDynamic(d1, true)).result().map(l -> UIDefinition.createBeforeInit(a -> a.putStaticElement((String)s, (ItemStack[])l.stream().map(Supplier::get).toArray(ItemStack[]::new)))).orElse(null));
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "x", "y", "order");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.addStatic(UIDefinition.createAfterInit(a -> {
                UIAccessor accessor = (UIAccessor)accessorFunction.apply((UIAccessor)a);
                Bearer<Integer> index = Bearer.of(0);
                a.putBearer(elementName + ".index", index);
                a.getElement(elementName + ".items", ItemStack[].class).ifPresent(stacks -> {
                    accessor.putStaticElement(elementName + ".amount", ((ItemStack[])stacks).length);
                    accessor.addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> {
                        ItemStack s = stacks[a.getInteger(elementName + ".index", 0)];
                        int x = a.getInteger(elementName + ".x", 0);
                        int y = a.getInteger(elementName + ".y", 0);
                        if (a.getBoolean(elementName + ".isFake", false).booleanValue()) {
                            guiGraphics.renderFakeItem(s, x, y);
                        } else {
                            guiGraphics.renderItem(s, x, y);
                        }
                        if (a.getBoolean(elementName + ".allowDecorations", true).booleanValue()) {
                            guiGraphics.renderItemDecorations(Minecraft.getInstance().font, s, x, y);
                        }
                    }));
                });
            }));
        }

        public static void parseRenderItemElements(UIDefinition uiDefinition, Function<UIAccessor, UIAccessor> accessorFunction, String elementName, Dynamic<?> element) {
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseBoolean, "isFake", "allowDecorations");
            ElementType.parseElement(uiDefinition, elementName, element, "item", (String s, Dynamic<?> d) -> ElementType.parseItemStackElement(s, d));
            ElementType.parseElements(uiDefinition, elementName, element, ElementType::parseNumber, "x", "y", "order", "amount");
            ElementType.parseTranslationElements(uiDefinition, elementName, element);
            uiDefinition.addStatic(UIDefinition.createAfterInit(a -> ((UIAccessor)accessorFunction.apply((UIAccessor)a)).addRenderable(elementName, a.createModifiableRenderable(elementName, (guiGraphics, i, j, f) -> a.getElement(elementName + ".item", ItemStack.class).ifPresent(s -> {
                int x = a.getInteger(elementName + ".x", 0);
                int y = a.getInteger(elementName + ".y", 0);
                if (a.getBoolean(elementName + ".isFake", false).booleanValue()) {
                    guiGraphics.renderFakeItem(s, x, y);
                } else {
                    guiGraphics.renderItem(s, x, y);
                }
                if (a.getBoolean(elementName + ".allowDecorations", true).booleanValue()) {
                    guiGraphics.renderItemDecorations(Minecraft.getInstance().font, s, x, y);
                }
            })))));
        }

        public static List<WidgetAction.PressSupplier<AbstractWidget>> parseActionsElement(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            return element.get("actions").asMapOpt().result().map(m -> m.map(p -> {
                String actionName = elementName + ".actions." + ((Dynamic)p.getFirst()).asString("");
                ElementType.parseElement(uiDefinition, actionName, (Dynamic)p.getSecond(), "applyCondition", ElementType::parseBoolean);
                return WidgetAction.CODEC.parse((Dynamic)p.getFirst()).result().flatMap(c -> c.press(a -> a.getBoolean(actionName + ".applyCondition", true), (Dynamic)p.getSecond()));
            }).filter(Optional::isPresent).map(Optional::get).toList()).orElse(Collections.emptyList());
        }

        public static ElementValue<ItemStack> parseItemStackElement(String field, Dynamic<?> element) {
            ArbitrarySupplier<ItemStack> stackSupplier = DynamicUtil.getItemFromDynamic(element, true);
            return new ElementValue<ItemStack>(field, a -> (ItemStack)stackSupplier.get());
        }

        @Deprecated
        public static UIDefinition parseItemStackElement(String elementName, String field, Dynamic<?> element) {
            return ElementType.parseItemStackElement(field, element);
        }

        public static ElementValue<Number> parseNumber(String field, Dynamic<?> element) {
            Optional numberResult = element.asNumber().result();
            if (numberResult.isPresent()) {
                return numberResult.map(n -> new ElementValue<Number>(field, a -> n)).orElse(null);
            }
            return element.asString().map(ExpressionEvaluator::of).map(e -> new ElementValue<Number>(field, e::evaluate)).result().orElse(null);
        }

        @Deprecated
        public static UIDefinition parseNumberElement(String elementName, String field, Dynamic<?> element) {
            return ElementType.parseNumber(field, element);
        }

        public static ElementValue<Boolean> parseBooleanElementOrReference(String elementName, Dynamic<?> element) {
            return ElementType.parseElementReference(elementName, element).orElseGet(() -> ElementType.parseBoolean(elementName, element));
        }

        public static <T> ElementValue<Boolean> parseBoolean(String field, Dynamic<T> element) {
            Optional booleanResult = element.getOps().getBooleanValue(element.getValue()).result();
            if (booleanResult.isPresent()) {
                return booleanResult.map(n -> new ElementValue<Boolean>(field, a -> n)).orElse(null);
            }
            return element.asString().map(BooleanExpressionEvaluator::of).map(e -> new ElementValue<Boolean>(field, e::evaluate)).result().orElse(null);
        }

        @Deprecated
        public static <T> UIDefinition parseBooleanElement(String elementName, String field, Dynamic<T> element) {
            return ElementType.parseBoolean(field, element);
        }

        public static UIDefinition parseExternalComponentElement(String elementName, String field, Dynamic<?> element) {
            return element.get("baseDir").flatMap(arg_0 -> ((Codec)ResourceLocation.CODEC).parse(arg_0)).result().map(r -> {
                HashMap componentByLang = new HashMap();
                for (String s : Minecraft.getInstance().getLanguageManager().getLanguages().keySet()) {
                    ResourceLocation location = r.withSuffix("/" + s + ".txt");
                    Optional externalComponent = Minecraft.getInstance().getResourceManager().getResource(location);
                    externalComponent.ifPresent(resource -> {
                        MutableComponent c = Component.empty();
                        try (BufferedReader reader = resource.openAsReader();){
                            reader.lines().forEach(l -> {
                                c.append(l);
                                c.append("\n");
                            });
                            componentByLang.put(s, c);
                        }
                        catch (IOException e) {
                            FactoryAPI.LOGGER.warn("Failed to parse {}, this external component won't be loaded.", (Object)location, (Object)e);
                        }
                    });
                }
                return UIDefinition.createBeforeInit(a -> {
                    block3: {
                        String lang;
                        block2: {
                            lang = Minecraft.getInstance().getLanguageManager().getSelected();
                            if (componentByLang.containsKey(lang)) break block2;
                            lang = "en_us";
                            if (!componentByLang.containsKey("en_us")) break block3;
                        }
                        a.putComponent(field, (Component)componentByLang.get(lang));
                    }
                });
            }).orElse(null);
        }

        public static UIDefinition parseComponentElement(String elementName, String field, Dynamic<?> element) {
            UIDefinition externalComponentUIDefinition = ElementType.parseExternalComponentElement(elementName, field, element);
            if (externalComponentUIDefinition != null) {
                return externalComponentUIDefinition;
            }
            return (element.get("allowVariables").asBoolean(false) ? element.get("translate").flatMap(d -> d.asString().map(s -> UIDefinition.createBeforeInit(a -> a.putComponent(field, (Component)Component.translatable((String)s, (Object[])element.get("args").asStream().map(d1 -> d1.asString().result().map(k -> a.getElementValue((String)k, null, Object.class))).filter(Optional::isPresent).map(Optional::get).toArray(Object[]::new)))))) : DynamicUtil.getComponentCodec().parse(element).map(c -> UIDefinition.createBeforeInit(a -> a.putComponent(field, (Component)c)))).result().orElse(null);
        }

        public static UIDefinition parseComponentElement(String elementName, Dynamic<?> element) {
            return ElementType.parseComponentElement(elementName, elementName, element);
        }

        public static void parseElements(UIDefinition uiDefinition, String elementName, Dynamic<?> element, BiFunction<String, Dynamic<?>, UIDefinition> dynamicToDefinition, String ... fields) {
            for (String field : fields) {
                ElementType.parseElement(uiDefinition, elementName, element, field, dynamicToDefinition);
            }
        }

        public static void parseElement(UIDefinition uiDefinition, String elementName, Dynamic<?> element, String field, Codec<?> codec) {
            ElementType.parseElement(uiDefinition, elementName, element, field, (String s, Dynamic<?> d) -> codec.parse(d).result().map(c -> UIDefinition.createBeforeInit(a -> a.putStaticElement((String)s, c))).orElse(null));
        }

        public static void parseElement(UIDefinition uiDefinition, String elementName, Dynamic<?> element, String field, BiFunction<String, Dynamic<?>, UIDefinition> dynamicToDefinition) {
            element.get(field).result().map(d -> ElementType.parseElementReference(elementName + "." + field, d).map(value -> value).orElseGet(() -> (UIDefinition)dynamicToDefinition.apply(elementName + "." + field, (Dynamic<?>)d))).ifPresent(uiDefinition::addStatic);
        }

        public static <T> Optional<ElementValue<T>> parseElementReference(String field, Dynamic<?> element) {
            return element.get("reference").asString().result().map(s -> new ElementValue<Object>(field, a -> a.getElement((String)s).get()));
        }

        public static ElementType get(String id) {
            return ElementType.get(ResourceLocation.tryParse((String)id));
        }

        public static ElementType get(ResourceLocation id) {
            return map.getOrDefault(id, PUT_NUMBER);
        }

        public static ResourceLocation getId(ElementType type) {
            return map.getKeyOrDefault(type, null);
        }

        public void parse(UIDefinition var1, Function<UIAccessor, UIAccessor> var2, String var3, Dynamic<?> var4);

        default public void parse(UIDefinition uiDefinition, String elementName, Dynamic<?> element) {
            this.parse(uiDefinition, a -> a, elementName, element);
        }

        public static ElementType createIndexable(Function<List<Integer>, ElementType> parser) {
            return (uiDefinition, accessorFunction, elementName, element) -> ((ElementType)parser.apply(element.get("range").asString().result().map(UIDefinitionManager::parseIntRange).orElse(List.of(Integer.valueOf(element.get("index").asInt(0)))))).parse(uiDefinition, accessorFunction, elementName, element);
        }

        public static ElementType createConditional(ElementType type) {
            return (uiDefinition, accessorFunction, elementName, element) -> {
                Optional applyCondition = element.get("applyCondition").map(e -> ElementType.parseBooleanElementOrReference(elementName + ".applyCondition", e)).result();
                UIDefinition.Instance condDefinition = new UIDefinition.Instance(elementName, a -> applyCondition.isEmpty() || (Boolean)((ElementValue)applyCondition.get()).value().apply((UIAccessor)a) != false);
                type.parse(condDefinition, accessorFunction, elementName, element);
                UIDefinitionManager.handleDeprecatedDefinitionsAddition(condDefinition);
                uiDefinition.addStatic(condDefinition);
            };
        }

        public static ElementType registerConditional(String path, ElementType type) {
            return ElementType.register(FactoryAPI.createVanillaLocation(path), ElementType.createConditional(type));
        }

        public static <T> ElementType registerCodec(String path, Codec<T> codec) {
            return ElementType.registerConditional(path, (definition, accessorFunction, name, e) -> ElementType.parseElement(definition, name, e, "value", (String s, Dynamic<?> d) -> codec.parse(d).result().map(r -> UIDefinition.createBeforeInit(a -> a.putStaticElement(name, r))).orElse(null)));
        }

        public static ElementType register(String path, ElementType type) {
            return ElementType.register(FactoryAPI.createVanillaLocation(path), type);
        }

        public static ElementType register(ResourceLocation id, ElementType type) {
            map.put(id, type);
            return type;
        }
    }

    public record ElementValue<T>(String name, Function<UIAccessor, T> value) implements UIDefinition
    {
        @Override
        public void beforeInit(UIAccessor accessor) {
            accessor.getElements().put(this.name, () -> this.value.apply(accessor));
        }
    }

    public static interface WidgetAction<P, W extends AbstractWidget> {
        public static final ListMap<ResourceLocation, WidgetAction<?, AbstractWidget>> map = new ListMap.Builder().put("open_default_screen", WidgetAction.create(ResourceLocation.CODEC, s -> (a, w, t) -> Minecraft.getInstance().setScreen(DEFAULT_SCREENS_MAP.getOrDefault(s, s1 -> null).apply(a.getScreen())))).put("open_config_screen", WidgetAction.create(Codec.STRING, s -> (a, w, t) -> Minecraft.getInstance().setScreen(FactoryAPIClient.getConfigScreen(FactoryAPIPlatform.getModInfo(s), a.getScreen())))).put("reload_ui", WidgetAction.create(Codec.unit((Object)Unit.INSTANCE), s -> (a, w, t) -> a.reloadUI())).put("run_command", WidgetAction.createRunCommand(s -> true)).put("run_windows_command", WidgetAction.createRunCommand(s -> Util.getPlatform() == Util.OS.WINDOWS)).put("run_linux_command", WidgetAction.createRunCommand(s -> Util.getPlatform() == Util.OS.LINUX)).put("run_osx_command", WidgetAction.createRunCommand(s -> Util.getPlatform() == Util.OS.OSX)).put("toggle_datapacks", WidgetAction.createToggleDatapacks()).mapKeys(FactoryAPI::createVanillaLocation).build();
        public static final Codec<WidgetAction<?, AbstractWidget>> CODEC = map.createCodec((Codec<ResourceLocation>)ResourceLocation.CODEC);

        public Codec<P> getCodec();

        public PressSupplier<W> press(P var1);

        default public Optional<PressSupplier<W>> press(Predicate<UIAccessor> canApply, Dynamic<?> dynamic) {
            return this.getCodec().parse(dynamic).result().or(() -> dynamic.get("value").get().result().flatMap(d -> this.getCodec().parse(d).result())).map(p -> (a, w, type) -> {
                if (canApply.test(a)) {
                    this.press(p).press(a, w, type);
                }
            });
        }

        public static WidgetAction<String, AbstractWidget> createRunCommand(Predicate<String> shouldRun) {
            return WidgetAction.create(Codec.STRING, s -> (a, w, t) -> {
                if (shouldRun.test((String)s)) {
                    try {
                        new ProcessBuilder(s.split(" ")).start();
                    }
                    catch (IOException e) {
                        FactoryAPI.LOGGER.warn(e.getMessage());
                    }
                }
            });
        }

        public static WidgetAction<List<String>, AbstractWidget> createToggleDatapacks() {
            return WidgetAction.create(Codec.STRING.listOf(), s -> (a, w, t) -> {
                if (a instanceof DatapackRepositoryAccessor) {
                    DatapackRepositoryAccessor datapackAccessor = (DatapackRepositoryAccessor)((Object)a);
                    PackRepository repo = datapackAccessor.getDatapackRepository();
                    switch (t.ordinal()) {
                        case 0: {
                            ArrayList<String> datapacks = new ArrayList<String>((Collection<String>)s);
                            datapacks.removeIf(pack -> !repo.isAvailable(pack));
                            Collections.reverse(datapacks);
                            datapacks.addAll(0, repo.getSelectedIds());
                            repo.setSelected(datapacks);
                            datapackAccessor.tryApplyNewDataPacks(repo);
                            break;
                        }
                        case 1: {
                            ArrayList<String> datapacks = new ArrayList<String>(repo.getSelectedIds());
                            datapacks.removeIf(s::contains);
                            repo.setSelected(datapacks);
                            datapackAccessor.tryApplyNewDataPacks(repo);
                        }
                    }
                }
            });
        }

        public static <P, W extends AbstractWidget> WidgetAction<P, W> create(final Codec<P> codec, final Function<P, PressSupplier<W>> onPress) {
            return new WidgetAction<P, W>(){

                @Override
                public Codec<P> getCodec() {
                    return codec;
                }

                @Override
                public PressSupplier<W> press(P result) {
                    return (PressSupplier)onPress.apply(result);
                }
            };
        }

        public static interface PressSupplier<W extends AbstractWidget> {
            public void press(UIAccessor var1, W var2, Type var3);
        }

        public static enum Type {
            ENABLE,
            DISABLE;

        }

        public record CycleEntry(Component message, List<PressSupplier<AbstractWidget>> actions) {
        }
    }
}

