/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import com.mojang.brigadier.CommandDispatcher;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.IFactoryItem;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.config.FactoryCommonOptions;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.network.CommonConfigSyncPayload;
import wily.factoryapi.base.network.CommonNetwork;
import wily.factoryapi.base.network.FactoryAPICommand;
import wily.factoryapi.base.network.HelloPayload;
import wily.factoryapi.base.network.OpenExtraMenuPayload;
import wily.factoryapi.base.network.SecureExecutor;
import wily.factoryapi.init.FactoryRegistries;

@Mod(value="factory_api")
public class FactoryAPI {
    public static final String MOD_ID = "factory_api";
    public static final SecureExecutor SECURE_EXECUTOR = new SecureExecutor(){

        @Override
        public boolean isSecure() {
            return true;
        }
    };
    public static final Logger LOGGER = LogManager.getLogger((String)"factory_api");
    public static MinecraftServer currentServer;

    public FactoryAPI() {
        FactoryAPI.init();
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, event -> {
            Object patt0$temp = event.getObject();
            if (patt0$temp instanceof IFactoryStorage) {
                final IFactoryStorage be = (IFactoryStorage)patt0$temp;
                event.addCapability(FactoryAPI.createModLocation("fallback_capabilities"), new ICapabilityProvider(){

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                        FactoryStorage<?> storage = FactoryAPIPlatform.BLOCK_CAPABILITY_MAP.get(capability);
                        ArbitrarySupplier<?> handler = be.getStorage(storage, arg);
                        if (storage != null && handler.isPresent()) {
                            return LazyOptional.of(handler::get).cast();
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        });
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, event -> {
            Item patt0$temp = ((ItemStack)event.getObject()).getItem();
            if (patt0$temp instanceof IFactoryItem) {
                final IFactoryItem i = (IFactoryItem)patt0$temp;
                event.addCapability(FactoryAPI.createModLocation("item_fallback_capabilities"), new ICapabilityProvider(){
                    final /* synthetic */ AttachCapabilitiesEvent val$event;
                    {
                        this.val$event = attachCapabilitiesEvent;
                    }

                    @NotNull
                    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
                        FactoryStorage<?> storage = FactoryAPIPlatform.ITEM_CAPABILITY_MAP.get(capability);
                        ArbitrarySupplier<?> handler = i.getStorage(storage, (ItemStack)this.val$event.getObject());
                        if (storage != null && handler.isPresent()) {
                            return LazyOptional.of(handler::get).cast();
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        });
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FactoryAPIClient.init();
        }
    }

    public static void init() {
        LOGGER.info("Initializing FactoryAPI!");
        FactoryConfig.registerCommonStorage(FactoryAPI.createModLocation("common"), FactoryCommonOptions.COMMON_STORAGE);
        FactoryEvent.registerPayload(r -> {
            r.register(false, FactoryAPICommand.UIDefinitionPayload.ID);
            r.register(false, HelloPayload.ID_S2C);
            r.register(true, HelloPayload.ID_C2S);
            r.register(false, CommonConfigSyncPayload.ID_S2C);
            r.register(true, CommonConfigSyncPayload.ID_C2S);
            r.register(false, OpenExtraMenuPayload.ID);
        });
        FactoryEvent.preServerTick(s -> SECURE_EXECUTOR.executeAll());
        FactoryEvent.registerCommands((TriConsumer<CommandDispatcher<CommandSourceStack>, CommandBuildContext, Commands.CommandSelection>)((TriConsumer)(commandSourceStackCommandDispatcher, commandBuildContext, commandSelection) -> FactoryAPICommand.register((CommandDispatcher<CommandSourceStack>)commandSourceStackCommandDispatcher, commandBuildContext)));
        FactoryRegistries.init();
        FactoryIngredient.init();
        FactoryEvent.setup(() -> {
            FactoryAPIPlatform.registerByClassArgumentType(FactoryAPICommand.JsonArgument.class, (ArgumentTypeInfo)FactoryRegistries.JSON_ARGUMENT_TYPE.get());
            FactoryCommonOptions.COMMON_STORAGE.load();
        });
        FactoryEvent.PlayerEvent.JOIN_EVENT.register(HelloPayload::sendInitialPayloads);
        FactoryEvent.PlayerEvent.REMOVED_EVENT.register(sp -> CommonNetwork.ENABLED_PLAYERS.removeAll((Object)sp.getUUID()));
        FactoryEvent.serverStopped(s -> {
            SECURE_EXECUTOR.clear();
            CommonNetwork.ENABLED_PLAYERS.clear();
            currentServer = null;
        });
    }

    public static ResourceLocation createLocation(String namespace, String path) {
        return ResourceLocation.tryBuild((String)namespace, (String)path);
    }

    public static ResourceLocation createLocation(String location) {
        return ResourceLocation.tryParse((String)location);
    }

    public static ResourceLocation createModLocation(String path) {
        return FactoryAPI.createLocation(MOD_ID, path);
    }

    public static ResourceLocation createVanillaLocation(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static Loader getLoader() {
        return Loader.FORGE;
    }

    public static boolean isLoadingMod(String modId) {
        return LoadingModList.get().getModFileById(modId) != null;
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static boolean isClient() {
        return FMLEnvironment.dist.isClient();
    }

    public static <T> Field getAccessibleField(Class<T> fieldClass, String field) {
        try {
            Field f = fieldClass.getDeclaredField(field);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException var1) {
            throw new IllegalStateException("Couldn't get field %s for %s".formatted(field, fieldClass), var1);
        }
    }

    public static <T> Map<String, Field> getAccessibleFieldsMap(Class<T> fieldsClass, String ... fields) {
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (String s : fields) {
            map.put(s, FactoryAPI.getAccessibleField(fieldsClass, s));
        }
        return map;
    }

    public static enum Loader {
        FABRIC,
        FORGE,
        NEOFORGE;


        public boolean isForgeLike() {
            return this == FORGE || this == NEOFORGE;
        }

        public boolean isFabric() {
            return this == FABRIC;
        }
    }
}

