/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi;

import com.mojang.brigadier.arguments.ArgumentType;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.FactoryEnergyStorage;
import wily.factoryapi.base.FactoryFluidHandler;
import wily.factoryapi.base.FactoryItemHandler;
import wily.factoryapi.base.FactoryStorage;
import wily.factoryapi.base.ICraftyEnergyStorage;
import wily.factoryapi.base.IFactoryStorage;
import wily.factoryapi.base.IModifiableTransportHandler;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandler;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.RegisterListing;
import wily.factoryapi.base.SideList;
import wily.factoryapi.base.TransportState;
import wily.factoryapi.base.forge.FactoryCapabilities;
import wily.factoryapi.util.FluidInstance;
import wily.factoryapi.util.ListMap;
import wily.factoryapi.util.ModInfo;

public interface FactoryAPIPlatform {
    public static final Map<IPlatformHandler, SideList<? super IModifiableTransportHandler>> filteredHandlersCache = new ConcurrentHashMap<IPlatformHandler, SideList<? super IModifiableTransportHandler>>();
    public static final Map<BlockEntity, IFactoryStorage> platformStorageWrappersCache = new ConcurrentHashMap<BlockEntity, IFactoryStorage>();
    public static final ListMap<Capability<?>, FactoryStorage<?>> ITEM_CAPABILITY_MAP = new ListMap.Builder<Capability, FactoryStorage<IPlatformFluidHandler>>().put(ForgeCapabilities.FLUID_HANDLER_ITEM, FactoryStorage.FLUID).put(ForgeCapabilities.ITEM_HANDLER, FactoryStorage.ITEM).put(ForgeCapabilities.ENERGY, FactoryStorage.ENERGY).put(FactoryCapabilities.CRAFTY_ENERGY, FactoryStorage.CRAFTY_ENERGY).build();
    public static final ListMap<Capability<?>, FactoryStorage<?>> BLOCK_CAPABILITY_MAP = new ListMap.Builder<Capability, FactoryStorage<IPlatformFluidHandler>>().put(ForgeCapabilities.FLUID_HANDLER, FactoryStorage.FLUID).put(ForgeCapabilities.ITEM_HANDLER, FactoryStorage.ITEM).put(ForgeCapabilities.ENERGY, FactoryStorage.ENERGY).put(FactoryCapabilities.CRAFTY_ENERGY, FactoryStorage.CRAFTY_ENERGY).build();
    public static final ListMap<String, ModInfo> MOD_INFOS = new ListMap();

    public static Component getPlatformEnergyComponent() {
        return Component.translatable((String)"energy.factory_api.forge").withStyle(ChatFormatting.GREEN);
    }

    public static <T> T getRegistryValue(ResourceLocation location, Registry<T> registry) {
        return (T)registry.get(location);
    }

    public static <T> Optional<Holder.Reference<T>> getRegistryValue(RegistryAccess access, ResourceKey<T> resourceKey) {
        return access.lookupOrThrow(ResourceKey.createRegistryKey((ResourceLocation)resourceKey.registry())).get(resourceKey);
    }

    public static BlockBehaviour.Properties setupBlockProperties(BlockBehaviour.Properties properties, RegisterListing.Holder<? extends Block> blockHolder) {
        return FactoryAPIPlatform.setupBlockProperties(properties, blockHolder.getId());
    }

    public static BlockBehaviour.Properties setupBlockProperties(BlockBehaviour.Properties properties, ResourceLocation id) {
        return properties;
    }

    public static Item.Properties setupItemProperties(Item.Properties properties, RegisterListing.Holder<? extends Item> itemHolder) {
        return FactoryAPIPlatform.setupItemProperties(properties, itemHolder.getId());
    }

    public static Item.Properties setupItemProperties(Item.Properties properties, ResourceLocation id) {
        return properties;
    }

    public static Item.Properties setupBlockItemProperties(Item.Properties properties, RegisterListing.Holder<? extends Block> blockHolder) {
        return FactoryAPIPlatform.setupBlockItemProperties(properties, blockHolder.getId());
    }

    public static Item.Properties setupBlockItemProperties(Item.Properties properties, ResourceLocation id) {
        return properties;
    }

    public static <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BlockEntitySupplier<T> supplier, Block ... blocks) {
        return BlockEntityType.Builder.of(supplier::create, (Block[])blocks).build(null);
    }

    public static IPlatformFluidHandler getItemFluidHandler(ItemStack container) {
        IPlatformFluidHandler iPlatformFluidHandler;
        IFluidHandlerItem handler = ItemContainerPlatform.getItemFluidHandler(container);
        if (handler == null) {
            iPlatformFluidHandler = null;
        } else if (handler instanceof IPlatformFluidHandler) {
            IPlatformFluidHandler f = (IPlatformFluidHandler)handler;
            iPlatformFluidHandler = f;
        } else {
            iPlatformFluidHandler = () -> handler;
        }
        return iPlatformFluidHandler;
    }

    public static RegistryAccess getRegistryAccess() {
        return FactoryAPI.currentServer == null || FactoryAPIPlatform.isClient() && FactoryAPIClient.hasLevel() ? FactoryAPIClient.getRegistryAccess() : FactoryAPI.currentServer.registryAccess();
    }

    public static IPlatformEnergyStorage getItemEnergyStorage(ItemStack stack) {
        IPlatformEnergyStorage iPlatformEnergyStorage;
        IEnergyStorage storage = ItemContainerPlatform.getItemEnergyStorage(stack);
        if (storage == null) {
            iPlatformEnergyStorage = null;
        } else if (storage instanceof IPlatformEnergyStorage) {
            IPlatformEnergyStorage f = (IPlatformEnergyStorage)storage;
            iPlatformEnergyStorage = f;
        } else {
            iPlatformEnergyStorage = () -> storage;
        }
        return iPlatformEnergyStorage;
    }

    public static ICraftyEnergyStorage getItemCraftyEnergyStorage(ItemStack stack) {
        return (ICraftyEnergyStorage)stack.getCapability(FactoryCapabilities.CRAFTY_ENERGY).orElse(null);
    }

    public static <T> RegisterListing.Holder<T> deferredToRegisterHolder(final RegistryObject<T> holder) {
        return new RegisterListing.Holder<T>(){

            @Override
            public ResourceLocation getId() {
                return holder.getId();
            }

            @Override
            public T get() {
                return holder.get();
            }
        };
    }

    public static <T> T getBlockCapability(BlockEntity entity, Capability<T> capability, Direction direction) {
        return (T)(capability == null ? null : entity.getCapability(capability, direction).orElse(null));
    }

    public static IEventBus getModEventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }

    public static IEventBus getForgeEventBus() {
        return MinecraftForge.EVENT_BUS;
    }

    public static IFluidHandler.FluidAction fluidActionOf(boolean simulate) {
        return simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE;
    }

    public static FluidInstance fluidStackToInstance(FluidStack stack) {
        return new FluidInstance(stack.getFluid(), stack.getAmount());
    }

    public static <T extends IPlatformHandler, U extends IModifiableTransportHandler & IPlatformHandler> U filteredOf(T handler, Direction direction, TransportState transportState, Function<T, U> sidedGetter) {
        filteredHandlersCache.entrySet().removeIf(e -> ((IPlatformHandler)e.getKey()).isRemoved());
        SideList list = filteredHandlersCache.computeIfAbsent(handler, d -> new SideList<IModifiableTransportHandler>(() -> null));
        if (!list.contains(direction)) {
            list.put(direction, (IModifiableTransportHandler)sidedGetter.apply(handler));
        }
        list.get(direction).setTransport(transportState);
        return list.get(direction) != null ? (U)list.get(direction) : null;
    }

    public static IPlatformItemHandler filteredOf(IPlatformItemHandler itemHandler, Direction direction, int[] slots, TransportState transportState) {
        FactoryItemHandler.SidedWrapper storage = FactoryAPIPlatform.filteredOf(itemHandler, direction, transportState, FactoryItemHandler.SidedWrapper::new);
        if (storage != null) {
            storage.slots = slots;
        }
        return storage;
    }

    public static IPlatformFluidHandler filteredOf(IPlatformFluidHandler fluidHandler, Direction direction, TransportState transportState) {
        return FactoryAPIPlatform.filteredOf((FactoryFluidHandler)fluidHandler, direction, transportState, FactoryFluidHandler.SidedWrapper::new);
    }

    public static IPlatformEnergyStorage filteredOf(IPlatformEnergyStorage energyStorage, Direction direction, TransportState transportState) {
        return FactoryAPIPlatform.filteredOf((FactoryEnergyStorage)energyStorage, direction, transportState, FactoryEnergyStorage.SidedWrapper::new);
    }

    public static IFactoryStorage getPlatformFactoryStorage(final BlockEntity be) {
        if (be instanceof IFactoryStorage) {
            IFactoryStorage st = (IFactoryStorage)be;
            return st;
        }
        platformStorageWrappersCache.entrySet().removeIf(e -> ((BlockEntity)e.getKey()).isRemoved());
        return platformStorageWrappersCache.computeIfAbsent(be, be1 -> new IFactoryStorage(){

            @Override
            public <T extends IPlatformHandler> ArbitrarySupplier<T> getStorage(FactoryStorage<T> storage, Direction direction) {
                Object handler = FactoryAPIPlatform.getBlockCapability(be, BLOCK_CAPABILITY_MAP.getKey(storage), direction);
                if (handler != null) {
                    if (storage == FactoryStorage.ENERGY) {
                        return () -> {
                            IPlatformEnergyStorage iPlatformEnergyStorage;
                            if (handler instanceof IPlatformEnergyStorage) {
                                IPlatformEnergyStorage energyHandler = (IPlatformEnergyStorage)handler;
                                iPlatformEnergyStorage = energyHandler;
                            } else {
                                iPlatformEnergyStorage = () -> (IEnergyStorage)handler;
                            }
                            return iPlatformEnergyStorage;
                        };
                    }
                    if (storage == FactoryStorage.CRAFTY_ENERGY && handler instanceof ICraftyEnergyStorage) {
                        ICraftyEnergyStorage energyHandler = (ICraftyEnergyStorage)handler;
                        return () -> energyHandler;
                    }
                    if (storage == FactoryStorage.ITEM) {
                        return () -> {
                            IPlatformItemHandler iPlatformItemHandler;
                            if (handler instanceof IPlatformItemHandler) {
                                IPlatformItemHandler itemHandler = (IPlatformItemHandler)handler;
                                iPlatformItemHandler = itemHandler;
                            } else {
                                iPlatformItemHandler = () -> (IItemHandler)handler;
                            }
                            return iPlatformItemHandler;
                        };
                    }
                    if (storage == FactoryStorage.FLUID) {
                        return () -> {
                            IPlatformFluidHandler iPlatformFluidHandler;
                            if (handler instanceof IPlatformFluidHandler) {
                                IPlatformFluidHandler fluidHandler = (IPlatformFluidHandler)handler;
                                iPlatformFluidHandler = fluidHandler;
                            } else {
                                iPlatformFluidHandler = () -> (IFluidHandler)handler;
                            }
                            return iPlatformFluidHandler;
                        };
                    }
                }
                return ArbitrarySupplier.empty();
            }
        });
    }

    public static boolean isClient() {
        return FMLEnvironment.dist.isClient();
    }

    public static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> void registerByClassArgumentType(Class<A> infoClass, I argumentTypeInfo) {
        ArgumentTypeInfos.registerByClass(infoClass, argumentTypeInfo);
    }

    public static <T> RegisterListing<T> createRegister(final String namespace, final Registry<T> registry) {
        return new RegisterListing<T>(){
            private final DeferredRegister<T> REGISTER;
            {
                this.REGISTER = DeferredRegister.create((ResourceKey)registry.key(), (String)namespace);
            }

            @Override
            public Collection<RegisterListing.Holder<T>> getEntries() {
                return this.stream().collect(Collectors.toSet());
            }

            @Override
            public Registry<T> getRegistry() {
                return registry;
            }

            @Override
            public String getNamespace() {
                return namespace;
            }

            @Override
            public void register() {
                this.REGISTER.register(FactoryAPIPlatform.getModEventBus());
            }

            @Override
            public <V extends T> RegisterListing.Holder<V> add(String name, Function<ResourceLocation, V> supplier) {
                return FactoryAPIPlatform.deferredToRegisterHolder(this.REGISTER.register(name, () -> supplier.apply(FactoryAPI.createLocation(this.getNamespace(), name))));
            }

            @Override
            @NotNull
            public Iterator<RegisterListing.Holder<T>> iterator() {
                return this.stream().iterator();
            }

            @Override
            public Stream<RegisterListing.Holder<T>> stream() {
                return this.REGISTER.getEntries().stream().map(h -> FactoryAPIPlatform.deferredToRegisterHolder(h));
            }
        };
    }

    public static String getCurrentClassName(String className) {
        return className;
    }

    public static Stream<ModInfo> getVisibleModsStream() {
        return FactoryAPIPlatform.getMods().stream().filter(info -> !info.isHidden());
    }

    public static Collection<ModInfo> getMods() {
        LoadingModList.get().getMods().forEach(m -> FactoryAPIPlatform.getModInfo(m.getModId()));
        return MOD_INFOS.values();
    }

    public static ModInfo getModInfo(final String modId) {
        return FactoryAPI.isModLoaded(modId) ? MOD_INFOS.computeIfAbsent(modId, s -> new ModInfo(){
            IModFileInfo info;
            Optional<? extends ModContainer> opt;
            {
                this.info = ModList.get().getModFileById(modId);
                this.opt = ModList.get().getModContainerById(modId);
            }

            @Override
            public Collection<String> getAuthors() {
                return this.opt.flatMap(c -> c.getModInfo().getConfig().getConfigElement("authors").map(s -> Collections.singleton(String.valueOf(s)))).orElse(Collections.emptySet());
            }

            @Override
            public Optional<String> getHomepage() {
                return this.opt.flatMap(c -> c.getModInfo().getConfig().getConfigElement("displayURL").map(String::valueOf));
            }

            @Override
            public Optional<String> getIssues() {
                URL uRL;
                IModFileInfo iModFileInfo = this.info;
                if (iModFileInfo instanceof ModFileInfo) {
                    ModFileInfo i = (ModFileInfo)iModFileInfo;
                    uRL = i.getIssueURL();
                } else {
                    uRL = null;
                }
                return Optional.ofNullable(uRL).map(URL::toString);
            }

            @Override
            public Optional<String> getSources() {
                return Optional.empty();
            }

            @Override
            public Collection<String> getCredits() {
                return this.opt.flatMap(c -> c.getModInfo().getConfig().getConfigElement("credits").map(o -> Set.of(String.valueOf(o)))).orElse(Collections.emptySet());
            }

            @Override
            public Collection<String> getLicense() {
                return Collections.singleton(this.info.getLicense());
            }

            @Override
            public String getDescription() {
                return this.opt.map(c -> c.getModInfo().getDescription()).orElse("");
            }

            @Override
            public Optional<String> getLogoFile(int i) {
                return this.info.getMods().stream().filter(m -> m.getModId().equals(modId)).findFirst().flatMap(IModInfo::getLogoFile);
            }

            @Override
            public Optional<Path> findResource(String s) {
                return Optional.of(this.info.getFile().findResource(new String[]{s})).filter(x$0 -> Files.exists(x$0, new LinkOption[0]));
            }

            @Override
            public String getId() {
                return modId;
            }

            @Override
            public String getVersion() {
                return this.opt.map(c -> c.getModInfo().getVersion().toString()).orElse("");
            }

            @Override
            public String getName() {
                return this.opt.map(c -> c.getModInfo().getDisplayName()).orElse("");
            }
        }) : null;
    }

    public static boolean isPackHidden(Pack pack) {
        return false;
    }

    @FunctionalInterface
    public static interface BlockEntitySupplier<T extends BlockEntity> {
        public T create(BlockPos var1, BlockState var2);
    }
}

