/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import wily.factoryapi.FactoryAPI;

public interface FactoryGuiGraphics {
    public static final Map<TextureAtlasSprite, Map<String, ResourceLocation>> spriteTilesCache = new ConcurrentHashMap<TextureAtlasSprite, Map<String, ResourceLocation>>();

    public GuiGraphics context();

    public MultiBufferSource.BufferSource getBufferSource();

    public void pushBufferSource(MultiBufferSource.BufferSource var1);

    public void popBufferSource();

    public static FactoryGuiGraphics of(GuiGraphics guiGraphics) {
        return ((Accessor)guiGraphics).getFactoryGuiGraphics();
    }

    public static GuiSpriteManager getSprites() {
        return Minecraft.getInstance().getGuiSprites();
    }

    public void blit(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public void blit(ResourceLocation var1, int var2, int var3, int var4, float var5, float var6, int var7, int var8, int var9, int var10);

    public void blit(ResourceLocation var1, int var2, int var3, int var4, int var5, float var6, float var7, int var8, int var9, int var10, int var11);

    public void blit(ResourceLocation var1, int var2, int var3, float var4, float var5, int var6, int var7, int var8, int var9);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6);

    public void blitSprite(ResourceLocation var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public void blit(int var1, int var2, int var3, int var4, int var5, TextureAtlasSprite var6);

    default public void blitSprite(ResourceLocation resourceLocation, int textureWidth, int textureHeight, int uvX, int uvY, int x, int y, int width, int height) {
        this.blitSprite(resourceLocation, textureWidth, textureHeight, uvX, uvY, x, y, 0, width, height);
    }

    public void enableScissor(int var1, int var2, int var3, int var4, boolean var5);

    default public void enableScissor(int x, int y, int xd, int yd) {
        this.enableScissor(x, y, xd, yd, true);
    }

    default public void blitTiledSprite(TextureAtlasSprite textureAtlasSprite, int i, int j, int k, int l, int m, int n, int o, int p, int q, int r, int s) {
        Minecraft minecraft = Minecraft.getInstance();
        if (l <= 0 || m <= 0) {
            return;
        }
        if (p <= 0 || q <= 0) {
            throw new IllegalArgumentException("Tiled sprite texture size must be positive, got " + p + "x" + q);
        }
        ResourceLocation tile = spriteTilesCache.computeIfAbsent(textureAtlasSprite, sp -> new ConcurrentHashMap()).computeIfAbsent("tile_" + n + "x" + o + "_" + p + "x" + q, string -> {
            try {
                TextureAtlas atlas = (TextureAtlas)minecraft.getTextureManager().getTexture(textureAtlasSprite.atlasLocation());
                Optional<ResourceLocation> opt = AtlasAccessor.of(atlas).getTexturesByName().entrySet().stream().filter(e -> e.getValue() == textureAtlasSprite).findFirst().map(Map.Entry::getKey);
                if (opt.isPresent()) {
                    NativeImage image = NativeImage.read((InputStream)minecraft.getResourceManager().getResourceOrThrow(opt.get().withPath("textures/gui/sprites/" + opt.get().getPath() + ".png")).open());
                    int width = (int)Math.ceil((double)(p * image.getWidth()) / (double)r);
                    int height = (int)Math.ceil((double)(q * image.getHeight()) / (double)s);
                    NativeImage tileImage = new NativeImage(width, height, false);
                    image.copyRect(tileImage, n * image.getWidth() / r, o * image.getHeight() / s, 0, 0, width, height, false, false);
                    return minecraft.getTextureManager().register("tile", new DynamicTexture(tileImage));
                }
            }
            catch (IOException e2) {
                FactoryAPI.LOGGER.warn(e2.getMessage());
            }
            return null;
        });
        this.blit(tile, i, j, Math.min(n, p), Math.min(o, q), l, m, p, q);
    }

    public void setColor(int var1, boolean var2);

    public void setColor(float var1, float var2, float var3, float var4, boolean var5);

    default public void setColor(int color) {
        this.setColor(color, false);
    }

    default public void setColor(float r, float g, float b, float a) {
        this.setColor(r, g, b, a, false);
    }

    public float[] getColor();

    default public void clearColor(boolean changeBlend) {
        this.setColor(1.0f, 1.0f, 1.0f, 1.0f, changeBlend);
    }

    default public void clearColor() {
        this.clearColor(false);
    }

    public void disableDepthTest();

    public void enableDepthTest();

    public static interface Accessor {
        public FactoryGuiGraphics getFactoryGuiGraphics();
    }

    public static interface AtlasAccessor {
        public static AtlasAccessor of(TextureAtlas atlas) {
            return (AtlasAccessor)atlas;
        }

        public Map<ResourceLocation, TextureAtlasSprite> getTexturesByName();
    }
}

