/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.base.config.FactoryConfigControl;
import wily.factoryapi.base.config.FactoryConfigDisplay;

public class FactoryConfigWidgets {
    private static final List<WidgetOverride<?>> overrides = new ArrayList();
    public static final Function<Component, Tooltip> TOOLTIP_CACHE = Util.memoize(c -> Tooltip.create((Component)c));

    public static Tooltip getCachedTooltip(Component component) {
        return component == null ? null : TOOLTIP_CACHE.apply(component);
    }

    public static <T> AbstractWidget getOverride(FactoryConfig<T> config, Function<T, Tooltip> tooltipFunction, int x, int y, int width, Consumer<T> afterSet) {
        for (WidgetOverride<?> override : overrides) {
            AbstractWidget widgetOverride = override.createWidget(config, tooltipFunction, x, y, width, afterSet);
            if (widgetOverride == null) continue;
            return widgetOverride;
        }
        return null;
    }

    public static <T> AbstractWidget createWidget(FactoryConfig<T> config, int x, int y, int width, Consumer<T> afterSet) {
        FactoryConfigDisplay display = config.getDisplay();
        Function<Object, Tooltip> tooltipFunction = v -> FactoryConfigWidgets.getCachedTooltip(display.tooltip().apply(v));
        AbstractWidget override = FactoryConfigWidgets.getOverride(config, tooltipFunction, x, y, width, afterSet);
        if (override != null) {
            return override;
        }
        if (config.control().equals(FactoryConfigControl.TOGGLE)) {
            return CycleButton.builder(b -> display.valueToComponent().apply((Boolean)b)).withValues(OptionInstance.BOOLEAN_VALUES.valueListSupplier()).withTooltip(tooltipFunction::apply).withInitialValue((Object)((Boolean)config.get())).create(x, y, width, 20, display.name(), (cycleButton, object) -> FactoryConfig.saveOptionAndConsume(config, object, afterSet));
        }
        FactoryConfigControl<T> factoryConfigControl = config.control();
        if (factoryConfigControl instanceof FactoryConfigControl.FromInt) {
            FactoryConfigControl.FromInt c = (FactoryConfigControl.FromInt)factoryConfigControl;
            return CycleButton.builder(display.valueToComponent()).withValues(FactoryConfigWidgets.listSupplier(c.valueGetter(), c.valuesSize())).withTooltip(tooltipFunction::apply).withInitialValue(config.get()).create(x, y, width, 20, display.name(), (cycleButton, object) -> FactoryConfig.saveOptionAndConsume(config, object, afterSet));
        }
        factoryConfigControl = config.control();
        if (factoryConfigControl instanceof FactoryConfigControl.FromDouble) {
            FactoryConfigControl.FromDouble c = (FactoryConfigControl.FromDouble)factoryConfigControl;
            return FactoryConfigWidgets.createSlider(config, x, y, width, afterSet, c.valueGetter(), c.valueSetter(), tooltipFunction);
        }
        factoryConfigControl = config.control();
        if (factoryConfigControl instanceof FactoryConfigControl.Int) {
            FactoryConfigControl.Int c = (FactoryConfigControl.Int)factoryConfigControl;
            return FactoryConfigWidgets.createSlider(config, x, y, width, afterSet, d -> (int)((double)(c.max().getAsInt() - c.min()) * d) + c.min(), i -> (double)(i - c.min()) / (double)(c.max().getAsInt() - c.min()), tooltipFunction);
        }
        factoryConfigControl = config.control();
        if (factoryConfigControl instanceof FactoryConfigControl.TextEdit) {
            FactoryConfigControl.TextEdit c = (FactoryConfigControl.TextEdit)factoryConfigControl;
            EditBox editBox = new EditBox(Minecraft.getInstance().font, x, y, width, 20, display.name());
            c.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, config.get()).result().ifPresent(v -> editBox.setValue(v.toString()));
            editBox.setResponder(s -> {
                DataResult result;
                try {
                    result = c.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new StringReader((String)s)));
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    result = DataResult.error(() -> ((JsonParseException)e).getMessage());
                }
                if (result.result().isPresent()) {
                    editBox.setTextColor(0xE0E0E0);
                    config.set(result.result().get());
                    config.save();
                    editBox.setTooltip((Tooltip)tooltipFunction.apply(config.get()));
                } else {
                    editBox.setTextColor(0xFF5555);
                    editBox.setTooltip(Tooltip.create((Component)Component.literal((String)((DataResult.Error)result.error().get()).message())));
                }
            });
            return editBox;
        }
        return null;
    }

    public static <T> AbstractSliderButton createSlider(final FactoryConfig<T> config, int x, int y, int width, final Consumer<T> afterSet, final Function<Double, T> valueGetter, final Function<T, Double> valueSetter, final Function<T, Tooltip> tooltipFunction) {
        return new AbstractSliderButton(x, y, width, 20, config.getDisplay().getMessage(config.get()), valueSetter.apply(config.get())){

            protected void updateMessage() {
                this.setMessage(config.getDisplay().getMessage(valueGetter.apply(this.value)));
                this.setTooltip((Tooltip)tooltipFunction.apply(valueGetter.apply(this.value)));
            }

            protected void applyValue() {
                FactoryConfig.saveOptionAndConsume(config, valueGetter.apply(this.value), afterSet);
                this.value = (Double)valueSetter.apply(config.get());
            }
        };
    }

    public static <T> AbstractWidget createWidget(FactoryConfig<T> config) {
        return FactoryConfigWidgets.createWidget(config, 0, 0, 0, v -> {});
    }

    public static <T> CycleButton.ValueListSupplier<T> listSupplier(Function<Integer, T> valueGetter, Supplier<Integer> valuesSize) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < valuesSize.get(); ++i) {
            list.add(valueGetter.apply(i));
        }
        return CycleButton.ValueListSupplier.create(list);
    }

    public static interface WidgetOverride<T> {
        public AbstractWidget createWidget(FactoryConfig<T> var1, Function<T, Tooltip> var2, int var3, int var4, int var5, Consumer<T> var6);
    }
}

