/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.config;

import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import wily.factoryapi.util.FactoryComponents;

public interface FactoryConfigDisplay<T> {
    public Component name();

    public Function<T, Component> tooltip();

    @Deprecated
    public BiFunction<Component, T, Component> captionFunction();

    public Function<T, Component> valueToComponent();

    public BiFunction<FactoryConfigDisplay<T>, T, Component> messageFunction();

    default public Component getMessage(T value) {
        return this.messageFunction().apply(this, (FactoryConfigDisplay)value);
    }

    public static Instance<Boolean> createToggle(Component name, Function<Boolean, Component> tooltip) {
        return FactoryConfigDisplay.toggleBuilder().tooltip(tooltip).build(name);
    }

    public static Instance<Boolean> createToggle(Component name) {
        return FactoryConfigDisplay.toggleBuilder().build(name);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static Builder<Boolean> toggleBuilder() {
        return new Builder<Boolean>().valueToComponent(b -> b != false ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
    }

    public static Builder<Integer> intBuilder() {
        return FactoryConfigDisplay.builder();
    }

    public static Builder<Integer> intPercentBuilder() {
        return FactoryConfigDisplay.intBuilder().messageFunctionLabel(FactoryComponents::percentValueLabel);
    }

    public static Builder<Double> doubleBuilder() {
        return FactoryConfigDisplay.builder();
    }

    public static Builder<Double> percentBuilder() {
        return FactoryConfigDisplay.doubleBuilder().valueToComponent(value -> Component.literal((String)String.valueOf((int)(value * 100.0)))).messageFunctionLabel(FactoryComponents::percentValueLabel);
    }

    public static class Builder<T> {
        private Function<T, Component> valueToComponent = t -> Component.literal((String)t.toString());
        private BiFunction<FactoryConfigDisplay<T>, T, Component> messageFunction = (display, t) -> CommonComponents.optionNameValue((Component)display.name(), (Component)display.valueToComponent().apply(t));
        private Function<T, Component> tooltip = value -> null;

        public Builder<T> valueToComponent(Function<T, Component> valueToComponent) {
            this.valueToComponent = valueToComponent;
            return this;
        }

        public Builder<T> messageFunction(BiFunction<FactoryConfigDisplay<T>, T, Component> messageFunction) {
            this.messageFunction = messageFunction;
            return this;
        }

        public Builder<T> messageFunctionLabel(BiFunction<Component, Component, Component> messageFunction) {
            return this.messageFunction((display, t) -> (Component)messageFunction.apply(display.name(), display.valueToComponent().apply(t)));
        }

        public Builder<T> messageFunctionCaption(BiFunction<Component, T, Component> messageFunction) {
            return this.messageFunction((display, t) -> (Component)messageFunction.apply(display.name(), t));
        }

        public Builder<T> tooltip(Function<T, Component> tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Instance<T> build(Component name) {
            return new Instance<T>(name, this.tooltip, this.valueToComponent, this.messageFunction);
        }
    }

    public record Instance<T>(Component name, Function<T, Component> tooltip, Function<T, Component> valueToComponent, BiFunction<FactoryConfigDisplay<T>, T, Component> messageFunction, BiFunction<Component, T, Component> captionFunction) implements FactoryConfigDisplay<T>
    {
        public Instance(Component name, Function<T, Component> tooltip, Function<T, Component> valueToComponent, BiFunction<FactoryConfigDisplay<T>, T, Component> messageFunction) {
            this(name, tooltip, valueToComponent, messageFunction, (n, value) -> (Component)valueToComponent.apply(value));
        }

        @Deprecated
        public Instance(Component name, Function<T, Component> tooltip, BiFunction<Component, T, Component> captionFunction) {
            this(name, tooltip, t -> Component.literal((String)t.toString()), (display, value) -> (Component)captionFunction.apply(display.name(), value), captionFunction);
        }

        @Deprecated
        public Instance(Component name, BiFunction<Component, T, Component> captionFunction) {
            this(name, v -> null, captionFunction);
        }

        @Deprecated
        public Instance(Component name, Function<T, Component> tooltip) {
            this(name, tooltip, (c, v) -> c);
        }

        @Deprecated
        public Instance(Component name) {
            this(name, (Component c, T v) -> c);
        }
    }
}

