/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base;

import com.mojang.serialization.Codec;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;

public enum FactoryCapacityTier implements StringRepresentable
{
    BURNED("burned", ChatFormatting.DARK_RED, 0.0, 0, 0),
    BASIC("basic", ChatFormatting.GRAY, 0.2, 800, 1),
    ADVANCED("advanced", ChatFormatting.RED, 0.6, 2000, 3),
    HIGH("high", ChatFormatting.BLUE, 0.5, 4000, 8),
    ULTIMATE("ultimate", ChatFormatting.DARK_PURPLE, 0.63, 6000, 12),
    QUANTUM("quantum", ChatFormatting.DARK_AQUA, 0.8, 10000, 16),
    CREATIVE("creative", ChatFormatting.LIGHT_PURPLE, 1.0, Integer.MAX_VALUE, Integer.MAX_VALUE);

    public static final Codec<FactoryCapacityTier> CODEC;
    public static final StreamCodec<FriendlyByteBuf, FactoryCapacityTier> STREAM_CODEC;
    public final ChatFormatting formatting;
    private final double conductivity;
    public final int initialCapacity;
    public final int capacityMultiplier;
    private final String name;
    public final Component localizedName;

    private FactoryCapacityTier(String name, ChatFormatting formatting, double j, int initialCapacity, int multiplier) {
        this(name, (Component)Component.translatable((String)("tier.factory_api" + name)), formatting, j, initialCapacity, multiplier);
    }

    private FactoryCapacityTier(String name, Component displayName, ChatFormatting formatting, double j, int initialCapacity, int multiplier) {
        this.name = name;
        this.localizedName = displayName;
        this.formatting = formatting;
        this.conductivity = j;
        this.initialCapacity = initialCapacity;
        this.capacityMultiplier = multiplier;
    }

    public MutableComponent getEnergyTierComponent(boolean isStored) {
        return this.getPrefixComponent("energy", isStored).withStyle(ChatFormatting.AQUA).append(this.localizedName);
    }

    public MutableComponent getOutputTierComponent() {
        return this.getPrefixComponent("energy", Component.translatable((String)"tier.factory_api.output")).withStyle(ChatFormatting.AQUA).append(this.localizedName);
    }

    public MutableComponent getTierComponent(boolean isStored) {
        return this.getPrefixComponent("capacity", isStored).withStyle(ChatFormatting.GRAY).append(this.localizedName);
    }

    public MutableComponent getPrefixComponent(String keyType, boolean isStored) {
        if (isStored) {
            return this.getPrefixComponent(keyType, Component.translatable((String)"tier.factory_api.stored"));
        }
        return this.getPrefixComponent(keyType, "");
    }

    public MutableComponent getPrefixComponent(String keyType, Object ... objects) {
        return Component.translatable((String)"tier.factory_api.display", (Object[])new Object[]{Component.translatable((String)("tier.factory_api." + keyType), (Object[])objects)});
    }

    public boolean supportTier(FactoryCapacityTier tier) {
        return this.ordinal() >= tier.ordinal();
    }

    public double getConductivity() {
        return this.conductivity;
    }

    public double getPowFactor() {
        return Math.pow(this.conductivity, 2.0);
    }

    public boolean isBurned() {
        return this == BURNED;
    }

    public int getDefaultCapacity() {
        return this.initialCapacity * 10;
    }

    public int getStorageCapacity() {
        return this.getDefaultCapacity() * this.capacityMultiplier;
    }

    public FactoryCapacityTier increase(int ordinal) {
        return FactoryCapacityTier.values()[Math.min(FactoryCapacityTier.values().length - 1, this.ordinal() + ordinal)];
    }

    public int convertEnergyTo(int energy, FactoryCapacityTier tier) {
        return (int)Math.round(Math.max((double)energy + (this.getConductivity() - tier.getConductivity()) * (double)energy * (double)this.initialCapacity / (double)tier.initialCapacity, 0.0));
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(FactoryCapacityTier::values);
        STREAM_CODEC = StreamCodec.of(FriendlyByteBuf::writeEnum, b -> (FactoryCapacityTier)b.readEnum(FactoryCapacityTier.class));
    }
}

