/*
 * Decompiled with CFR 0.152.
 */
package wily.factoryapi.base.client;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.FactoryGuiMatrixStack;
import wily.factoryapi.base.client.FactoryOptions;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.base.client.WidgetAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.VariableResolver;
import wily.factoryapi.util.VariablesMap;

public interface UIAccessor
extends UIDefinition,
VariableResolver {
    public static UIAccessor of(Screen screen) {
        return (UIAccessor)screen;
    }

    public static UIAccessor of(Gui gui) {
        return (UIAccessor)gui;
    }

    @Nullable
    public Screen getScreen();

    default public void reloadUI() {
        this.beforeInit();
        this.getChildrenRenderables().clear();
        this.afterInit();
    }

    public boolean initialized();

    @Override
    default public void beforeInit(UIAccessor accessor) {
        Inventory inventory;
        this.getElements().clear();
        this.putStaticElement("windowWidth", Minecraft.getInstance().getWindow().getWidth());
        this.putStaticElement("windowHeight", Minecraft.getInstance().getWindow().getHeight());
        this.putStaticElement("width", Minecraft.getInstance().getWindow().getGuiScaledWidth());
        this.putStaticElement("height", Minecraft.getInstance().getWindow().getGuiScaledHeight());
        this.getElements().put("hasScreen", () -> Minecraft.getInstance().screen != null);
        if (this.getChildrenRenderables() != null) {
            this.getElements().put("renderablesCount", this.getChildrenRenderables()::size);
        }
        FactoryAPIPlatform.getMods().forEach(i -> this.putStaticElement("loadedMods." + i.getId(), true));
        ServerData serverData = Minecraft.getInstance().getCurrentServer();
        if (serverData != null) {
            this.putStaticElement("serverIp." + serverData.ip, true);
        }
        Inventory inventory2 = inventory = Minecraft.getInstance().player == null ? null : Minecraft.getInstance().player.getInventory();
        if (inventory != null) {
            NonNullList items = inventory.getNonEquipmentItems();
            int i2 = 0;
            while (i2 < items.size()) {
                int index = i2++;
                this.getElements().put("inventory." + index, () -> UIAccessor.lambda$beforeInit$2((List)items, index));
            }
            Inventory.EQUIPMENT_SLOT_MAPPING.forEach((i, equipmentSlot) -> {
                if (equipmentSlot == EquipmentSlot.OFFHAND) {
                    return;
                }
                this.getElements().put("inventory.armor." + equipmentSlot.getIndex(), () -> inventory.getItem(i.intValue()));
            });
            this.getElements().put("inventory.offhand", () -> inventory.getItem(40));
        }
        this.putSupplierComponent("username", () -> Component.literal((String)Minecraft.getInstance().getUser().getName()));
        Screen screen = this.getScreen();
        if (screen instanceof MenuAccess) {
            MenuAccess access = (MenuAccess)screen;
            this.getElements().put("slotsCount", () -> ((NonNullList)access.getMenu().slots).size());
            for (Slot slot : access.getMenu().slots) {
                this.getElements().put("menu.slot." + slot.getContainerSlot(), () -> ((Slot)slot).getItem());
            }
        }
        this.getDefinitions().clear();
        FactoryAPIClient.uiDefinitionManager.applyStatic(accessor);
        this.getDefinitions().addAll(this.getStaticDefinitions());
        FactoryAPIClient.uiDefinitionManager.apply(accessor);
        UIDefinition.super.beforeInit(accessor);
    }

    default public void beforeInit() {
        this.beforeInit(this);
    }

    default public void afterInit() {
        this.afterInit(this);
        if (((Boolean)FactoryOptions.UI_DEFINITION_LOGGING.get()).booleanValue()) {
            FactoryAPI.LOGGER.warn(this.getElements());
        }
    }

    default public void beforeTick() {
        this.beforeTick(this);
    }

    default public void afterTick() {
        this.afterTick(this);
    }

    public List<GuiEventListener> getChildren();

    public List<Renderable> getChildrenRenderables();

    public <T extends GuiEventListener> T removeChild(T var1);

    public <T extends GuiEventListener> T addChild(int var1, T var2, boolean var3, boolean var4);

    default public <T extends GuiEventListener> T addChild(int renderableIndex, T listener) {
        return this.addChild(renderableIndex, listener, true, true);
    }

    default public <T extends GuiEventListener> T addChild(String name, T listener) {
        return this.addChild(this.getInteger(name + ".order", this.getChildrenRenderables().size()), listener);
    }

    default public <T extends Renderable> T addRenderable(T renderable) {
        return this.addRenderable(this.getChildrenRenderables().size(), renderable);
    }

    default public <T extends Renderable> T addRenderable(int index, T renderable) {
        this.getChildrenRenderables().add(Math.min(Math.max(0, index), this.getChildrenRenderables().size()), renderable);
        return renderable;
    }

    default public <T extends Renderable> T addRenderable(String name, T renderable) {
        return this.addRenderable(this.getInteger(name + ".order", this.getChildrenRenderables().size()), renderable);
    }

    public VariablesMap<String, ArbitrarySupplier<?>> getElements();

    default public <E> E putStaticElement(String name, E e) {
        this.getElements().put(name, ArbitrarySupplier.of(e));
        return e;
    }

    default public <E> E putBearer(String name, Bearer<E> e, Function<Object, E> convertOldValue) {
        ArbitrarySupplier oldElement = this.getElements().put(name, e);
        if (oldElement != null) {
            oldElement.map(convertOldValue::apply).ifPresent(e::set);
        }
        return (E)e.get();
    }

    default public <E> E putBearer(String name, Bearer<E> e) {
        return (E)this.putBearer(name, e, o -> o);
    }

    default public Integer putIntegerBearer(String name, Bearer<Integer> e) {
        return this.putBearer(name, e, o -> {
            Integer n;
            if (o instanceof Number) {
                Number n2 = (Number)o;
                n = n2.intValue();
            } else if (o instanceof String) {
                String s = (String)o;
                n = Integer.parseInt(s);
            } else {
                n = null;
            }
            return n;
        });
    }

    default public <E extends AbstractWidget> E putWidget(String name, E e) {
        this.putBearer(name + ".message", Bearer.of(() -> e.getMessage(), arg_0 -> e.setMessage(arg_0)));
        this.getElement(name + ".tooltip", Component.class).ifPresent(c -> e.setTooltip(Tooltip.create((Component)c)));
        this.putBearer(name + ".spriteOverride", Bearer.of(WidgetAccessor.of(e)::getSpriteOverride, WidgetAccessor.of(e)::setSpriteOverride));
        this.putBearer(name + ".highlightedSpriteOverride", Bearer.of(WidgetAccessor.of(e)::getSpriteOverride, WidgetAccessor.of(e)::setHighlightedSpriteOverride));
        this.putBearer(name + ".onPressOverride", Bearer.of(WidgetAccessor.of(e)::getOnPressOverride, WidgetAccessor.of(e)::setOnPressOverride));
        WidgetAccessor.of(e).setVisibility(this.getElement(name + ".isVisible", Boolean.class));
        return this.putLayoutElement(name, e, arg_0 -> e.setWidth(arg_0), arg_0 -> e.setHeight(arg_0));
    }

    default public Component putComponent(String name, Component component) {
        this.putStaticElement(name, component);
        this.putStaticElement(name + ".width", Minecraft.getInstance().font.width((FormattedText)component));
        return component;
    }

    default public void putSupplierComponent(String name, ArbitrarySupplier<Component> component) {
        this.getElements().put(name, component);
        this.getElements().put(name + ".width", component.map(c -> Minecraft.getInstance().font.width((FormattedText)c)));
    }

    default public Vec3 putVec3(String name, Vec3 vec3) {
        this.putStaticElement(name, vec3);
        this.putStaticElement(name + ".x", vec3.x());
        this.putStaticElement(name + ".y", vec3.y());
        this.putStaticElement(name + ".z", vec3.z());
        return vec3;
    }

    default public Vec2 putVec2(String name, Vec2 offset) {
        this.putStaticElement(name, offset);
        this.putStaticElement(name + ".x", Float.valueOf(offset.x));
        this.putStaticElement(name + ".y", Float.valueOf(offset.y));
        return offset;
    }

    default public Renderable createModifiableRenderable(String name, Renderable renderable) {
        return (guiGraphics, i, j, f) -> {
            int amount = this.getInteger(name + ".amount", 1);
            for (int i1 = 0; i1 < amount; ++i1) {
                ArbitrarySupplier<?> patt0$temp = this.getElements().get(name + ".index");
                if (patt0$temp instanceof Bearer) {
                    Bearer b = (Bearer)patt0$temp;
                    b.secureCast(Integer.class).set(i1);
                }
                FactoryGuiMatrixStack.of(guiGraphics.pose()).pushPose();
                int color = this.getInteger(name + ".renderColor", -1);
                FactoryGuiGraphics.of(guiGraphics).setBlitColor(color);
                FactoryGuiMatrixStack.of(guiGraphics.pose()).translate(this.getDouble(name + ".translateX", 0.0), this.getDouble(name + ".translateY", 0.0), this.getDouble(name + ".translateZ", 0.0));
                FactoryGuiMatrixStack.of(guiGraphics.pose()).scale(this.getFloat(name + ".scaleX", 1.0f), this.getFloat(name + ".scaleY", 1.0f), this.getFloat(name + ".scaleZ", 1.0f));
                renderable.render(guiGraphics, i, j, f);
                FactoryGuiMatrixStack.of(guiGraphics.pose()).popPose();
                FactoryScreenUtil.disableBlend();
                FactoryGuiGraphics.of(guiGraphics).clearBlitColor();
            }
        };
    }

    default public <E extends LayoutElement> E putLayoutElement(String name, E e, Consumer<Integer> setWidth, Consumer<Integer> setHeight) {
        this.putIntegerBearer(name + ".x", Bearer.of(() -> e.getX(), arg_0 -> e.setX(arg_0)));
        this.putIntegerBearer(name + ".y", Bearer.of(() -> e.getY(), arg_0 -> e.setY(arg_0)));
        this.putIntegerBearer(name + ".width", Bearer.of(() -> e.getWidth(), setWidth));
        this.putIntegerBearer(name + ".height", Bearer.of(() -> e.getHeight(), setHeight));
        return this.putStaticElement(name, e);
    }

    default public String replaceValidElementValues(String s) {
        this.getElements().updatePattern();
        Matcher matcher = this.getElements().getPattern().matcher(s);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String key = matcher.group(1);
            matcher.appendReplacement(result, String.valueOf(this.getElements().get(key).get()));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    default public <V> ArbitrarySupplier<V> getElement(String name, Class<V> valueClass) {
        return this.getElements().getOrDefault(name, ArbitrarySupplier.empty()).secureCast(valueClass);
    }

    default public ArbitrarySupplier<?> getElement(String name) {
        return this.getElements().getOrDefault(name, ArbitrarySupplier.empty());
    }

    default public ArbitrarySupplier<Boolean> getBooleanElement(String name) {
        return this.getElement(name, Boolean.class);
    }

    default public ArbitrarySupplier<Integer> getIntegerElement(String name) {
        return this.getElement(name, Number.class).map(Number::intValue);
    }

    default public <V> V getElementValue(String name, V defaultValue, Class<V> valueClass) {
        Object value;
        ArbitrarySupplier<?> element = this.getElements().get(name);
        return element != null && valueClass.isInstance(value = element.get()) ? valueClass.cast(value) : defaultValue;
    }

    default public int getInteger(String name, int defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class).intValue();
    }

    default public double getDouble(String name, double defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class).doubleValue();
    }

    default public float getFloat(String name, float defaultValue) {
        return this.getElementValue(name, Float.valueOf(defaultValue), Number.class).floatValue();
    }

    @Override
    default public Boolean getBoolean(String name, Boolean defaultValue) {
        return this.getElementValue(name, defaultValue, Boolean.class);
    }

    default public Boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    default public ResourceLocation getResourceLocation(String name, ResourceLocation defaultValue) {
        return this.getElementValue(name, defaultValue, ResourceLocation.class);
    }

    default public ResourceLocation getResourceLocation(String name) {
        return this.getResourceLocation(name, null);
    }

    default public ItemStack getItemStack(String name) {
        return this.getElementValue(name, ItemStack.EMPTY, ItemStack.class);
    }

    default public ItemStack getItemStack(String name, ItemStack defaultValue) {
        return this.getElementValue(name, defaultValue, ItemStack.class);
    }

    default public Component getComponent(String name, Component defaultValue) {
        return this.getElementValue(name, defaultValue, Component.class);
    }

    default public Component getComponent(String name) {
        return this.getComponent(name, null);
    }

    default public Vec3 getVec3(String name, Vec3 defaultValue) {
        return this.getElementValue(name, defaultValue, Vec3.class);
    }

    default public Vec3 getVec3(String name) {
        return this.getVec3(name, null);
    }

    @Override
    default public Number getNumber(String name, Number defaultValue) {
        return this.getElementValue(name, defaultValue, Number.class);
    }

    public static UIAccessor createRenderablesWrapper(final UIAccessor accessor, final List<Renderable> renderables) {
        return new UIAccessor(){

            @Override
            @Nullable
            public Screen getScreen() {
                return accessor.getScreen();
            }

            @Override
            public List<UIDefinition> getDefinitions() {
                return accessor.getDefinitions();
            }

            @Override
            public void reloadUI() {
                accessor.reloadUI();
            }

            @Override
            public boolean initialized() {
                return accessor.initialized();
            }

            @Override
            public List<UIDefinition> getStaticDefinitions() {
                return accessor.getStaticDefinitions();
            }

            @Override
            public List<GuiEventListener> getChildren() {
                return Collections.emptyList();
            }

            @Override
            public List<Renderable> getChildrenRenderables() {
                return renderables;
            }

            @Override
            public <T extends GuiEventListener> T removeChild(T widget) {
                if (widget instanceof Renderable) {
                    renderables.remove(widget);
                }
                return widget;
            }

            @Override
            public <T extends GuiEventListener> T addChild(int renderableIndex, T listener, boolean isRenderable, boolean isNarratable) {
                if (isRenderable && listener instanceof Renderable) {
                    Renderable r = (Renderable)listener;
                    renderables.add(renderableIndex, r);
                }
                return listener;
            }

            @Override
            public VariablesMap<String, ArbitrarySupplier<?>> getElements() {
                return accessor.getElements();
            }
        };
    }

    private static /* synthetic */ Object lambda$beforeInit$2(List items, int index) {
        return items.get(index);
    }
}

